package org.dyndns.nuda.mapper.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLInterfaceEventProcessor {
	private static Map<Class<?>, List<SQLInterfaceEventListener<?>>>	listenerMap	=
																						new HashMap<Class<?>, List<SQLInterfaceEventListener<?>>>();
	
	private SQLInterfaceEventProcessor() {
		
	}
	
	public static SQLInterfaceEventProcessor newInstance() {
		return new SQLInterfaceEventProcessor();
	}
	
	public <T extends SQLInterfaceEvent> SQLInterfaceEventProcessor addEventListener(
			final SQLInterfaceEventListener<T> listener) {
		if (listener == null) {
			return this;
		}
		
		Class<?> eventListenerObject = listener.getClass();
		
		Class<?> paramType = getGenClass(eventListenerObject);
		
		if (listenerMap.containsKey(paramType)) {
			List<SQLInterfaceEventListener<?>> listenerList =
				listenerMap.get(paramType);
			listenerList.add(listener);
		} else {
			List<SQLInterfaceEventListener<?>> listenerList =
				new ArrayList<SQLInterfaceEventListener<?>>();
			listenerList.add(listener);
			listenerMap.put(paramType, listenerList);
		}
		return this;
	}
	
	public void broadcast(final SQLInterfaceEvent event) {
		if (event == null) {
			return;
		}
		Class<?> eventClass = event.getClass();
		
		if (listenerMap.containsKey(eventClass)) {
			List<SQLInterfaceEventListener<?>> listenerList =
				listenerMap.get(eventClass);
			
			for (SQLInterfaceEventListener<?> listener : listenerList) {
				Class<?> listenerClass = listener.getClass();
				try {
					Method m =
						listenerClass.getDeclaredMethod(
							"handle",
							event.getClass());
					if (m.getModifiers() == Modifier.PUBLIC) {
						if (!m.isAccessible()) {
							m.setAccessible(true);
						}
						m.invoke(listener, new Object[] { event });
					}
					
				} catch (SecurityException e) {
					e.printStackTrace();
				} catch (IllegalArgumentException e) {
					e.printStackTrace();
				} catch (NoSuchMethodException e) {
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					e.printStackTrace();
				}
			}
		}
	}
	
	public static Class<?> getGenClass(final Class<?> param) {
		Class<?> result = null;
		
		Type[] intfTypes = param.getGenericInterfaces();
		if (intfTypes.length == 0) {
			return null;
		} else {
			Type type0 = intfTypes[0];
			if (type0 instanceof ParameterizedType) {
				ParameterizedType parameterizedType = (ParameterizedType) type0;
				Type[] actTypes = parameterizedType.getActualTypeArguments();
				if (actTypes.length != 0) {
					if (actTypes[0] instanceof Class) {
						Class<?> genType = (Class<?>) actTypes[0];
						result = genType;
					}
					
				}
			}
		}
		
		return result;
	}
}
