/*
 * Decompiled with CFR 0.152.
 */
package sos.awt;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import sos.awt.ImageTransform;
import sos.awt.JCanvas;

public class JImageCanvas
extends JCanvas {
    protected ImageTransform imageTransform = null;
    private int oldX;
    private int oldY;

    public boolean createOffScreenImage() {
        if (super.createOffScreenImage()) {
            if (this.imageTransform == null) {
                this.imageTransform = new ImageTransform(this.getWidth(), this.getHeight(), null);
            } else {
                this.imageTransform.setDestSize(this.getWidth(), this.getHeight());
            }
            this.imageTransform.translateScreen(this.deltaWidth, this.deltaHeight);
            return true;
        }
        return false;
    }

    public void setImageTransform(ImageTransform trImg) {
        this.imageTransform = trImg;
    }

    public void setImage(Image img) {
        if (this.imageTransform == null) {
            this.imageTransform = new ImageTransform(this.getWidth(), this.getHeight(), img);
        } else {
            this.imageTransform.setImage(img);
        }
    }

    public void drawImage() {
        if (this.imageTransform != null) {
            this.imageTransform.drawImage(this.getOffGraphics());
        }
    }

    public void drawImage(Rectangle bounds) {
        if (this.imageTransform != null) {
            this.imageTransform.drawImage(this.getOffGraphics(), bounds);
        }
    }

    public void setFullSrc() {
        if (this.imageTransform != null) {
            this.imageTransform.setFullSrc();
        }
    }

    public void scaleImage(double ratio, double screenX, double screenY) {
        if (this.imageTransform != null) {
            this.imageTransform.scaleImage(ratio, screenX, screenY);
        }
    }

    public void scaleImage(double ratio) {
        if (this.imageTransform != null) {
            this.imageTransform.scaleImage(ratio);
        }
    }

    public void translateScreen(int dx, int dy) {
        this.imageTransform.translateScreen(dx, dy);
    }

    public Rectangle getVisibleBounds(int scale) {
        return this.imageTransform.getVisibleBounds(scale);
    }

    public Rectangle2D.Double getVisibleBounds() {
        return this.imageTransform.getVisibleBounds();
    }

    public double getMagnification() {
        return this.imageTransform.getMagnification();
    }

    public int getImageWidth() {
        return this.imageTransform.getOriginalImageWidth();
    }

    public int getImageHeight() {
        return this.imageTransform.getOriginalImageHeight();
    }

    public Point2D.Double getScreenOffset() {
        return this.imageTransform.getScreenOffset();
    }

    public ImageTransform getImageTransform() {
        return this.imageTransform;
    }

    public AffineTransform getAffineTransform() {
        return this.imageTransform.getAffineTransform();
    }

    public void calcMagnification() {
        this.imageTransform.calcMagnification();
    }

    public void mouseClicked(MouseEvent evt) {
        int modifier = evt.getModifiers();
        double rate = 2.0;
        if ((modifier & 8) != 0 || (modifier & 4) != 0) {
            rate = 0.5;
        }
        this.scaleImage(rate, evt.getX(), evt.getY());
    }

    public void mouseDragged(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        int dx = x - this.oldX;
        int dy = y - this.oldY;
        this.oldX = x;
        this.oldY = y;
        this.translateScreen(dx, dy);
    }

    public void mousePressed(MouseEvent evt) {
        this.oldX = evt.getX();
        this.oldY = evt.getY();
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
        double ratio = 1.0 + (double)evt.getWheelRotation() * 0.05;
        this.scaleImage(ratio);
    }

    public BufferedImage getImage() {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.imageTransform.drawImage(img.getGraphics());
        return img;
    }
}

