/*
 * Decompiled with CFR 0.152.
 */
package taktstock;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.Serializable;

public class CommentInfo
implements Serializable {
    private static final long serialVersionUID = 2446785629534268399L;
    private Point location = new Point(30, 30);
    private Color color;
    private String text;
    private String fontName;
    private int fontStyle = 0;
    private int fontSize = 28;

    public void setText(String arg) {
        this.text = arg;
    }

    public String getText() {
        if (this.text == null) {
            return "";
        }
        return this.text;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = Color.black;
        }
        return this.color;
    }

    public void translate(int dx, int dy) {
        this.location.x += dx;
        this.location.y += dy;
    }

    public void draw(Graphics2D g) {
        if (this.text != null) {
            if (this.fontName != null && 0 <= this.fontStyle && 0 < this.fontSize) {
                Font font = new Font(this.fontName, this.fontStyle, this.fontSize);
                g.setFont(font);
            }
            if (this.color != null) {
                g.setColor(this.color);
            }
            int height = g.getFontMetrics().getHeight();
            int offset = this.location.y;
            String[] args = this.text.split("\n");
            for (int i = 0; i < args.length; ++i) {
                g.drawString(args[i], this.location.x, offset);
                offset += height;
            }
        }
    }

    public String getFontName() {
        if (this.fontName == null) {
            this.fontName = "Arial";
        }
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public int getFontSize() {
        if (this.fontSize <= 0) {
            this.fontSize = 28;
        }
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }
}

