/*
 * CommentInfo.java
 *
 * Created on 2005/01/16, 16:48
 */

package taktstock;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.Serializable;

/**
 *
 * @author pathologist
 */
public class CommentInfo implements Serializable{
	static private final long serialVersionUID = 2446785629534268399L;
	
	private Point location = new Point(30,30);
	private Color color;
	private String text;
	private String fontName;
	private int fontStyle = 0;
	private int fontSize = 28;
	
	/** Creates a new instance of CommentInfo */
	public CommentInfo() {
	}
	
	public void setText(String arg){
		text = arg;
	}
	
	public String getText(){
		if (text==null){
			return "";
		}
		return text;
	}
	
	public void setColor(Color color){
		this.color = color;
	}
	
	public Color getColor(){
		if (color==null){
			color = Color.black;
		}
		return color;
	}
	
	public void translate(int dx, int dy){
		location.x += dx;
		location.y += dy;
	}
	
	public void draw(Graphics2D g){
		if (text!=null){
			if (fontName!=null && 0<=fontStyle && 0<fontSize){
				Font font = new Font(fontName, fontStyle, fontSize);
				g.setFont(font);
			}
			if (color!=null){
				g.setColor(color);
			}
			
			int height = g.getFontMetrics().getHeight();
			int offset = location.y;
			String[] args = text.split("\n");
			for (int i=0; i<args.length; i++){
				g.drawString(args[i],location.x, offset);
				offset += height;
			}
		}
	}
	
	public String getFontName(){
		if (fontName==null){
			fontName = "Arial";
		}
		return fontName;
	}
	
	public void setFontName(String fontName) {
		this.fontName = fontName;
	}
	
	public int getFontStyle() {
		return fontStyle;
	}
	
	public void setFontStyle(int fontStyle) {
		this.fontStyle = fontStyle;
	}
	
	public int getFontSize() {
		if (fontSize<=0){
			fontSize = 28;
		}
		return fontSize;
	}
	
	public void setFontSize(int fontSize) {
		this.fontSize = fontSize;
	}
}
