/*
 * CommentInfoEditor.java
 *
 * Created on 2005/02/13, 11:48
 */

package taktstock.animation;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.table.TableCellEditor;
import taktstock.CommentInfo;
import taktstock.TaktstockViewer;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/02/15)
 */
public class KeyFrameEditor extends javax.swing.AbstractCellEditor implements TableCellEditor {
	private TaktstockViewer viewer;
	private CommentInfo currentCommentInfo;
	protected static final String EDIT = "edit";
	
	/** Creates new form BeanForm */
	public KeyFrameEditor(){
	}
	
	public KeyFrameEditor(TaktstockViewer viewer) {
		this.viewer = viewer;
		
		initComponents();
		jButton.setActionCommand(EDIT);
		
		String fonts[]= GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
		for (int i=0; i<fonts.length; i++){
			jComboFont.addItem(fonts[i]);
		}
		
		jDialog.pack();
	}
	
	public Object getCellEditorValue() {
		return currentCommentInfo;
	}
	
	public boolean isCellEditable(java.util.EventObject eventObject) {
		if (jDialog.isVisible()){
			fireEditingStopped();
		}
		
		Point p = MouseInfo.getPointerInfo().getLocation();
		jDialog.setLocation(p.x+5,p.y+5);
		return true;
	}
	
	public java.awt.Component getTableCellEditorComponent(javax.swing.JTable jTable, Object obj, boolean param, int param3, int param4) {
		currentCommentInfo = (CommentInfo)obj;
		return jButton;
	}
	
	private void setTextColor(Color color){
		if (color!=null){
			currentCommentInfo.setColor(color);
			jLabelColor.setBackground(color);
			jLabelColorString.setText("["+color.getRed()+","+color.getGreen()+","+color.getBlue()+"]");
			viewer.updateCanvas();
		}
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jDialog = new javax.swing.JDialog();
        jLabel4 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jComboFont = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jComboStyle = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        jSpinnerSize = new javax.swing.JSpinner();
        jLabelColor = new javax.swing.JLabel();
        jLabelColorString = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaComment = new javax.swing.JTextArea();
        jButton = new javax.swing.JButton();

        jDialog.getContentPane().setLayout(new java.awt.GridBagLayout());

        jDialog.setTitle("Text property editor");
        jDialog.setAlwaysOnTop(true);
        jDialog.setModal(false);
        jDialog.addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                jDialogWindowClosing(evt);
            }
        });

        jLabel4.setText("Color:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 0);
        jDialog.getContentPane().add(jLabel4, gridBagConstraints);

        jLabel3.setText("Font:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        jDialog.getContentPane().add(jLabel3, gridBagConstraints);

        jComboFont.setPreferredSize(new java.awt.Dimension(200, 24));
        jComboFont.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboFontItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jDialog.getContentPane().add(jComboFont, gridBagConstraints);

        jLabel1.setText("Style:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        jDialog.getContentPane().add(jLabel1, gridBagConstraints);

        jComboStyle.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "PLAIN", "BOLD", "ITALIC", "BOLD+ITALIC" }));
        jComboStyle.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboStyleItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        jDialog.getContentPane().add(jComboStyle, gridBagConstraints);

        jLabel2.setText(" Size:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        jDialog.getContentPane().add(jLabel2, gridBagConstraints);

        jSpinnerSize.setPreferredSize(new java.awt.Dimension(50, 20));
        jSpinnerSize.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerSizeStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jDialog.getContentPane().add(jSpinnerSize, gridBagConstraints);

        jLabelColor.setBackground(new java.awt.Color(0, 0, 0));
        jLabelColor.setEnabled(false);
        jLabelColor.setOpaque(true);
        jLabelColor.setPreferredSize(new java.awt.Dimension(15, 15));
        jLabelColor.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jLabelColorMousePressed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 0);
        jDialog.getContentPane().add(jLabelColor, gridBagConstraints);

        jLabelColorString.setText("[0,0,0]");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 0);
        jDialog.getContentPane().add(jLabelColorString, gridBagConstraints);

        jTextAreaComment.setRows(5);
        jTextAreaComment.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTextAreaCommentKeyReleased(evt);
            }
        });
        jTextAreaComment.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jTextAreaCommentMouseReleased(evt);
            }
        });

        jScrollPane1.setViewportView(jTextAreaComment);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jDialog.getContentPane().add(jScrollPane1, gridBagConstraints);

        jButton.setBorderPainted(false);
        jButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonActionPerformed(evt);
            }
        });

    }//GEN-END:initComponents
	
	private void jTextAreaCommentKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextAreaCommentKeyReleased
		currentCommentInfo.setText(jTextAreaComment.getText());
		viewer.updateCanvas();
	}//GEN-LAST:event_jTextAreaCommentKeyReleased
	
	private void jDialogWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_jDialogWindowClosing
		viewer.setEditingComment(false);
		jDialog.setVisible(false);
		fireEditingStopped();
	}//GEN-LAST:event_jDialogWindowClosing
	
	private void jButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonActionPerformed
		if (EDIT.equals(evt.getActionCommand())) {
			viewer.setCurrentComment(currentCommentInfo);
			viewer.setEditingComment(true);
			
			jTextAreaComment.setText(currentCommentInfo.getText());
			jComboFont.setSelectedItem(currentCommentInfo.getFontName());
			jComboStyle.setSelectedIndex(currentCommentInfo.getFontStyle());
			jSpinnerSize.setValue(currentCommentInfo.getFontSize());
			setTextColor(currentCommentInfo.getColor());
			jDialog.setVisible(true);
		}
	}//GEN-LAST:event_jButtonActionPerformed
	
	private void jTextAreaCommentMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTextAreaCommentMouseReleased
		
	}//GEN-LAST:event_jTextAreaCommentMouseReleased
	
	private void jComboStyleItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboStyleItemStateChanged
		if (currentCommentInfo!=null){
			int fontStyle = jComboStyle.getSelectedIndex();
			currentCommentInfo.setFontStyle(fontStyle);
			viewer.updateCanvas();
		}
	}//GEN-LAST:event_jComboStyleItemStateChanged
	
	private void jComboFontItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboFontItemStateChanged
		if (currentCommentInfo!=null){
			String fontName = (String)jComboFont.getSelectedItem();
			currentCommentInfo.setFontName(fontName);
			viewer.updateCanvas();
		}
	}//GEN-LAST:event_jComboFontItemStateChanged
	
	private void jLabelColorMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabelColorMousePressed
		Color color = JColorChooser.showDialog(jDialog, "Color for the text", jLabelColor.getBackground());
		if (color!=null){
			setTextColor(color);
		}
	}//GEN-LAST:event_jLabelColorMousePressed
	
	private void jSpinnerSizeStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSpinnerSizeStateChanged
		if (currentCommentInfo!=null){
			int fontSize = (Integer)jSpinnerSize.getValue();
			currentCommentInfo.setFontSize(fontSize);
			viewer.updateCanvas();
		}
	}//GEN-LAST:event_jSpinnerSizeStateChanged
	
	
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JButton jButton;
    private javax.swing.JComboBox jComboFont;
    private javax.swing.JComboBox jComboStyle;
    private javax.swing.JDialog jDialog;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabelColor;
    private javax.swing.JLabel jLabelColorString;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSpinner jSpinnerSize;
    private javax.swing.JTextArea jTextAreaComment;
    // ϐ錾̏I//GEN-END:variables
	
}
