/*
 * PlayListEditor.java
 *
 * Created on 2005/02/12, 1:55
 */

package taktstock.animation;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableCellEditor;

/**
 *
 * @author  pathologist
 */
public class PlayListEditor extends javax.swing.AbstractCellEditor implements TableCellEditor{

	private int currentColumn;
	
	/** Creates new form BeanForm */
	public PlayListEditor() {
		initComponents();
		SpinnerNumberModel spinnerModel = new SpinnerNumberModel(100,100,Integer.MAX_VALUE,100);
		jSpinner.setModel(spinnerModel);
	}
	
	public Object getCellEditorValue() {
		Object aValue = null;
		if (currentColumn==3){
			aValue = (Boolean)jCheckBox.isSelected();
		}else{
			aValue = jSpinner.getValue();
		}
		return aValue;
	}
	
	public Component getTableCellEditorComponent(JTable jTable, Object obj, boolean param, int row, int column) {
		currentColumn = column;
		
		if (column==3){
			jCheckBox.setSelected((Boolean)obj);
			return jCheckBox;
		}else{
			int value = (Integer)obj;
			jSpinner.setValue(value);
			return jSpinner;
		}
	}
	
	public boolean isCellEditable(java.util.EventObject eventObject) {
		JTable table = (JTable)eventObject.getSource();
		int row = table.rowAtPoint(((MouseEvent)eventObject).getPoint());
		if (row==table.getRowCount()-1){
			return false;
		}
		return true;
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        jCheckBox = new javax.swing.JCheckBox();
        jSpinner = new javax.swing.JSpinner();

        jCheckBox.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);

    }//GEN-END:initComponents
	
	
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBox;
    private javax.swing.JSpinner jSpinner;
    // ϐ錾̏I//GEN-END:variables
	
}
