/*
 * NewBeanForm.java
 *
 * Created on 2005/01/03, 13:15
 */

package taktstock.animation;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;
import taktstock.TaktstockFile;

/**
 *
 * @author  Gaku Tanaka
 */
public class PlayListRenderer implements TableCellRenderer{
	static private DecimalFormat decimal = new DecimalFormat("00");
	private DefaultListModel listModel;
	private Color selectedColor = new Color(255,230,210);
	private Color uneditableColor = new Color(230,230,230); 
	
	/** Creates new form BeanForm */
	public PlayListRenderer(JList list) {
		listModel = (DefaultListModel)list.getModel();
		initComponents();
	}
	
	public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
		JComponent component = null;
		if (obj!=null){
			jLabel.setHorizontalAlignment(SwingConstants.LEADING);
			int index;
			switch (column){
				case 0:
					index = (Integer)obj;
					TaktstockFile file = (TaktstockFile)listModel.getElementAt(index);
					jLabel.setText(file.getFile().getName());
					component = jLabel;
					break;
				case 1:
					index = (Integer)obj;
					jLabel.setText(Integer.toString(index+1));
					component = jLabel;
					break;
				case 2:
					int sec = ((Long)obj).intValue()/1000;
					int min = sec/60;
					int hour = min/60;
					jLabel.setText(decimal.format(hour)+":"+decimal.format(min)+":"+decimal.format(sec));
					jLabel.setHorizontalAlignment(SwingConstants.TRAILING);
					component = jLabel;
					break;
				case 3:
					if (row<jTable.getRowCount()-1){
						jCheckBox.setSelected((Boolean)obj);
						component = jCheckBox;
					}
					break;
				case 4:
					if (row<jTable.getRowCount()-1){
						int time = (Integer)obj;
						jLabel.setText(Integer.toString(time));
						jLabel.setHorizontalAlignment(SwingConstants.TRAILING);
						component = jLabel;
					}
					break;
			}
			
			if (component!=null){
				if(isSelected){
					component.setBackground(selectedColor);
					component.setOpaque(true);
				}else{
					component.setOpaque(false);
				}
			}
		}
		
		return component;
	}
	
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        jLabel = new javax.swing.JLabel();
        jCheckBox = new javax.swing.JCheckBox();

        jLabel.setText("jLabel1");
        jLabel.setOpaque(true);
        jCheckBox.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);

    }//GEN-END:initComponents
	
	
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBox;
    private javax.swing.JLabel jLabel;
    // ϐ錾̏I//GEN-END:variables
	
}
