/*
 * Viewer.java
 *
 * Created on 2004/12/18, 9:17
 */

package orch;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;

import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import orch.plugin.CoarseFineMatching;
import orch.plugin.Matching;
import sos.gui.JProgressDialog;
import sos.gui.MarnerSetting;
import sos.io.SOSImageIO;
import sos.io.SOSFileIO;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/02/15)
 */
public class OrchViewer extends javax.swing.JFrame{
	
	private ImagePiece[][] tnArray;
	private Rectangle rectThumbnailExist = null;
	private LinkedList<Point> thumbnails = new LinkedList<Point>();
	private Matching imageMatching;
	
	private Timer timer;
	private TimerTask taskLoadImage;
	private TimerTask taskAnalyze;
	
	private SOSImageIO imageIO = new SOSImageIO();
	
	/** Creates new form Viewer */
	public OrchViewer() {
		
		initComponents();
		
		jTableImages.setDefaultRenderer(Object.class, new ImageTableCellRenderer());
		jTableImages.applyCellSize();
		jTableImages.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		jTableImages.setComponentPopupMenu(jPopupRemove);
		
		jScrollTableImages.setColumnHeader(null);
		
		SpinnerNumberModel nColumnModel = new SpinnerNumberModel(3,1,100,1);
		jSpinnerColumnNumber.setModel(nColumnModel);
		SpinnerNumberModel nRowModel = new SpinnerNumberModel(3,1,100,1);
		jSpinnerRowNumber.setModel(nRowModel);
		jDialogSetTable.setLocation(getX()+getWidth()/2, getY()+getHeight()/2);
		jDialogSetTable.pack();
		
		SpinnerNumberModel horizontalModel = new SpinnerNumberModel(0.3, 0.1,1.0, 0.1);
		jSpinnerHorizontal.setModel(horizontalModel);
		SpinnerNumberModel verticalModel = new SpinnerNumberModel(0.8, 0.1,1.0, 0.1);
		jSpinnerVertical.setModel(verticalModel);
		SpinnerNumberModel minimumModel = new SpinnerNumberModel(0.01, 0.01,0.3, 0.01);
		jSpinnerMinimum.setModel(minimumModel);
		jDialogOption.pack();
		
		timer = new Timer();
	}
	
	private void createLoadImageTask(){
		final JFrame frame = this;
		
		taskLoadImage = new TimerTask(){
			public void run(){
				ArrayList<String> args = imageIO.readStrings();
				final Point size = stringToPoint(args.get(0));
				try{
					EventQueue.invokeAndWait(new Runnable() {
						public void run() {
							jTableImages.setTable(size.x*2+1,size.y*2+1);
						}
					});
				}catch(Exception e){
					e.printStackTrace();
				}
				
				JProgressDialog progress = new JProgressDialog(frame);
				progress.setLocation(frame.getX()+frame.getWidth()/2, frame.getY()+frame.getHeight()/2);
				progress.start("Loading...", false);
				
				int progressRatio = 0;
				for (int i=1; i<args.size(); i+=2){
					Point p = stringToPoint(args.get(i));
					String path = args.get(i+1);
					ImagePiece tn = new ImagePiece(160,120,new File(path));
					jTableImages.setValueAt(tn, p.y*2+1, p.x*2+1);
					
					progressRatio = 100*i/(args.size()-1);
					progress.setValue(progressRatio);
				}
				progress.stop();
			}
		};
	}
	
	private void createAnalyzeTask(){
		taskAnalyze = new TimerTask(){
			public void run(){
				if (!pickupThumbnailFromTable()){
					return;
				}
				setVisible(false);
				uniteAllImages();
				saveResult();
				setVisible(true);
			}
		};
	}
	
	private boolean pickupThumbnailFromTable(){
		TableModel model = jTableImages.getModel();
		rectThumbnailExist = null;
		thumbnails = new LinkedList<Point>();
		int nImageRow = model.getRowCount()/2;
		int nImageHeight = model.getColumnCount()/2;
		for (int y=0; y<nImageRow; y++){
			for (int x=0; x<nImageHeight; x++){
				ImagePiece tn = (ImagePiece)model.getValueAt(y*2+1,x*2+1);
				if (tn!=null && tn.hasImage()){
					if (rectThumbnailExist==null){
						rectThumbnailExist = new Rectangle(x,y,0,0);
					}else{
						rectThumbnailExist.add(x,y);
					}
					thumbnails.add(new Point(x,y));
				}
			}
		}
		if (rectThumbnailExist==null){
			return false;
		}
		rectThumbnailExist.width++;
		rectThumbnailExist.height++;
		return true;
	}
	
	private void uniteAllImages(){
		
		TableModel model = jTableImages.getModel();
		tnArray = new ImagePiece[rectThumbnailExist.height][rectThumbnailExist.width];
		while(!thumbnails.isEmpty()){
			Point p = thumbnails.removeFirst();
			int newX = p.x-rectThumbnailExist.x;
			int newY = p.y-rectThumbnailExist.y;
			tnArray[newY][newX] = (ImagePiece)model.getValueAt(p.y*2+1,p.x*2+1);
			tnArray[newY][newX].setFixed(false);
		}
		
		double verticalOverlapRatio = (Double)jSpinnerVertical.getValue();
		double horizontalOverlapRatio = (Double)jSpinnerHorizontal.getValue();
		double minOverlapRatio = (Double)jSpinnerMinimum.getValue();
		
		imageMatching = new CoarseFineMatching();
		imageMatching.init(tnArray);
		imageMatching.start(horizontalOverlapRatio,verticalOverlapRatio,minOverlapRatio);
	}
	
	private void saveResult(){
		imageIO.setAllWritableFilters();
		File file = imageIO.getSaveFile();
		if (file==null){
			return;
		}
		int type = imageIO.getFileType();
		imageMatching.setVisible(false);
		
		JProgressDialog progress = new JProgressDialog(this);
		progress.setLocation(getX()+getWidth()/2, getY()+getHeight()/2);
		progress.start("Saving the result image...", true);
		
		// calculate the bounding rectangle which include all images
		Rectangle uniteRect = new Rectangle();
		for (int y=0; y<tnArray.length; y++){
			for (int x=0; x<tnArray[y].length; x++){
				if (tnArray[y][x]!=null){
					uniteRect.add(tnArray[y][x].getBounds());
					tnArray[y][x].clearPixelsData(); // release the pixelsData to save a memory usage
					tnArray[y][x].clearThumbnail();
				}
			}
		}
		
		// draw images on the rectangle(image)
		BufferedImage img = new BufferedImage(uniteRect.width,uniteRect.height,BufferedImage.TYPE_INT_RGB);
		Graphics g = img.getGraphics();
		for (int y=0; y<tnArray.length; y++){
			for (int x=0; x<tnArray[y].length; x++){
				if (tnArray[y][x]!=null){
					Rectangle rect = tnArray[y][x].getBounds();
					g.drawImage(tnArray[y][x].getImage(), rect.x-uniteRect.x,rect.y-uniteRect.y, null);
				}
			}
		}
		
		imageIO.writeImage(file,type,img);
		progress.stop();
	}
	
	private Point stringToPoint(String arg){
		String[] location = arg.split(",");
		return new Point(Integer.parseInt(location[0]), Integer.parseInt(location[1]));
	}
	
	private void drawOverlap(){
		
		Graphics2D g = (Graphics2D)jCanvasOverlap.getOffGraphics();
		if (g==null){
			return;
		}
		jCanvasOverlap.clearCanvas();
		
		Rectangle rect = new Rectangle(160,120,160,120);
		g.setColor(Color.yellow);
		g.draw(rect);
		
		double verticalOverlapRatio = (Double)jSpinnerVertical.getValue();
		double horizontalOverlapRatio = (Double)jSpinnerHorizontal.getValue();
		double minOverlapRatio = (Double)jSpinnerMinimum.getValue();
		Dimension size = new Dimension();
		size.width = (int)(rect.width*horizontalOverlapRatio);
		size.height = (int)(rect.height*verticalOverlapRatio);
		Dimension minSize = new Dimension();
		minSize.width = (int)(rect.width*minOverlapRatio);
		minSize.height = (int)(rect.height*minOverlapRatio);
		
		rect.setLocation(rect.x+rect.width-size.width, rect.y-size.height);
		rect.width += size.width-minSize.width;
		rect.height += size.height*2;
		g.setColor(new Color(0,0,255,32));
		g.fill(rect);
		
		rect.setBounds(160,120, 160,120);
		rect.setLocation(rect.x-size.width, rect.y+rect.height-size.height);
		rect.width += size.width*2;
		rect.height += size.height-minSize.height;
		g.fill(rect);
		
		jCanvasOverlap.repaint();
		
	}
	
	public void checkMaxOfMinOverlap(){
		double min = Math.min((Double)jSpinnerHorizontal.getValue(),(Double)jSpinnerVertical.getValue());
		SpinnerNumberModel model = (SpinnerNumberModel)jSpinnerMinimum.getModel();
		model.setMaximum(min);
		if (min<(Double)jSpinnerMinimum.getValue()){
			model.setValue(min);
		}
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPopupRemove = new javax.swing.JPopupMenu();
        jMenuDeleteImage = new javax.swing.JMenuItem();
        jMenuRemoveColumn = new javax.swing.JMenuItem();
        jMenuRemoveRow = new javax.swing.JMenuItem();
        jDialogSetTable = new javax.swing.JDialog();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jSpinnerColumnNumber = new javax.swing.JSpinner();
        jSpinnerRowNumber = new javax.swing.JSpinner();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jDialogOption = new javax.swing.JDialog();
        jCanvasOverlap = new sos.awt.JCanvas();
        jPanel1 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jSpinnerHorizontal = new javax.swing.JSpinner();
        jLabel4 = new javax.swing.JLabel();
        jSpinnerVertical = new javax.swing.JSpinner();
        jLabel5 = new javax.swing.JLabel();
        jSpinnerMinimum = new javax.swing.JSpinner();
        jScrollTableImages = new javax.swing.JScrollPane();
        jTableImages = new orch.JDropableTable();
        jMenuBarMain = new javax.swing.JMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuOpenTable = new javax.swing.JMenuItem();
        jMenuSaveTable = new javax.swing.JMenuItem();
        jMenuTable = new javax.swing.JMenu();
        jMenuSetTable = new javax.swing.JMenuItem();
        jMenuClearTable = new javax.swing.JMenuItem();
        jMenuAnalyze = new javax.swing.JMenu();
        jMenuAnalyzeStart = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        jMenuOption = new javax.swing.JMenuItem();

        jMenuDeleteImage.setText("Delete Image");
        jMenuDeleteImage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuDeleteImageActionPerformed(evt);
            }
        });

        jPopupRemove.add(jMenuDeleteImage);

        jMenuRemoveColumn.setText("Remove column");
        jMenuRemoveColumn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuRemoveColumnActionPerformed(evt);
            }
        });

        jPopupRemove.add(jMenuRemoveColumn);

        jMenuRemoveRow.setText("Remove row");
        jMenuRemoveRow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuRemoveRowActionPerformed(evt);
            }
        });

        jPopupRemove.add(jMenuRemoveRow);

        jDialogSetTable.getContentPane().setLayout(new java.awt.GridBagLayout());

        jDialogSetTable.setAlwaysOnTop(true);
        jDialogSetTable.setModal(true);
        jDialogSetTable.setResizable(false);
        jLabel1.setText("column (x): ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jDialogSetTable.getContentPane().add(jLabel1, gridBagConstraints);

        jLabel2.setText("row (y): ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jDialogSetTable.getContentPane().add(jLabel2, gridBagConstraints);

        jSpinnerColumnNumber.setRequestFocusEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jDialogSetTable.getContentPane().add(jSpinnerColumnNumber, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jDialogSetTable.getContentPane().add(jSpinnerRowNumber, gridBagConstraints);

        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 5);
        jDialogSetTable.getContentPane().add(jButtonOK, gridBagConstraints);

        jButtonCancel.setText("CANCEL");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 6, 0, 0);
        jDialogSetTable.getContentPane().add(jButtonCancel, gridBagConstraints);

        jDialogOption.setTitle("Overlap Setting");
        jCanvasOverlap.setPreferredSize(new java.awt.Dimension(480, 360));
        jDialogOption.getContentPane().add(jCanvasOverlap, java.awt.BorderLayout.CENTER);

        jLabel3.setText("Horizontal:");
        jPanel1.add(jLabel3);

        jSpinnerHorizontal.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerHorizontalStateChanged(evt);
            }
        });

        jPanel1.add(jSpinnerHorizontal);

        jLabel4.setText(" Vertical:");
        jPanel1.add(jLabel4);

        jSpinnerVertical.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerVerticalStateChanged(evt);
            }
        });

        jPanel1.add(jSpinnerVertical);

        jLabel5.setText(" Minimum:");
        jPanel1.add(jLabel5);

        jSpinnerMinimum.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerMinimumStateChanged(evt);
            }
        });

        jPanel1.add(jSpinnerMinimum);

        jDialogOption.getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Orch 1.0");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jScrollTableImages.setPreferredSize(new java.awt.Dimension(518, 398));
        jTableImages.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null, null, null, null},
                {null, null, null, null, null, null, null},
                {null, null, null, null, null, null, null},
                {null, null, null, null, null, null, null},
                {null, null, null, null, null, null, null},
                {null, null, null, null, null, null, null},
                {null, null, null, null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4", "Title 5", "Title 6", "Title 7"
            }
        ));
        jTableImages.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        jTableImages.setCellSelectionEnabled(true);
        jTableImages.setDragEnabled(true);
        jScrollTableImages.setViewportView(jTableImages);

        getContentPane().add(jScrollTableImages, java.awt.BorderLayout.CENTER);

        jMenuFile.setText("File");
        jMenuOpenTable.setText("Open Table file");
        jMenuOpenTable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuOpenTableActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuOpenTable);

        jMenuSaveTable.setText("Save Table file");
        jMenuSaveTable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSaveTableActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuSaveTable);

        jMenuBarMain.add(jMenuFile);

        jMenuTable.setText("Table");
        jMenuSetTable.setText("Set Table");
        jMenuSetTable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSetTableActionPerformed(evt);
            }
        });

        jMenuTable.add(jMenuSetTable);

        jMenuClearTable.setText("Clear Table");
        jMenuClearTable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuClearTableActionPerformed(evt);
            }
        });

        jMenuTable.add(jMenuClearTable);

        jMenuBarMain.add(jMenuTable);

        jMenuAnalyze.setText("Analyze");
        jMenuAnalyzeStart.setText("Start");
        jMenuAnalyzeStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuAnalyzeStartActionPerformed(evt);
            }
        });

        jMenuAnalyze.add(jMenuAnalyzeStart);

        jMenuAnalyze.add(jSeparator1);

        jMenuOption.setText("Overlap Setting");
        jMenuOption.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuOptionActionPerformed(evt);
            }
        });

        jMenuAnalyze.add(jMenuOption);

        jMenuBarMain.add(jMenuAnalyze);

        setJMenuBar(jMenuBarMain);

        pack();
    }//GEN-END:initComponents
		
	private void jSpinnerMinimumStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSpinnerMinimumStateChanged
		drawOverlap();
	}//GEN-LAST:event_jSpinnerMinimumStateChanged
	
	private void jSpinnerVerticalStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSpinnerVerticalStateChanged
		checkMaxOfMinOverlap();
		drawOverlap();
	}//GEN-LAST:event_jSpinnerVerticalStateChanged
	
	private void jSpinnerHorizontalStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSpinnerHorizontalStateChanged
		checkMaxOfMinOverlap();
		drawOverlap();
	}//GEN-LAST:event_jSpinnerHorizontalStateChanged
	
	private void jMenuOptionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuOptionActionPerformed
		
		PointerInfo pointerInfo = MouseInfo.getPointerInfo();
		jDialogOption.setLocation(pointerInfo.getLocation());
		jDialogOption.setVisible(true);
		//jCanvasOverlap.paintImmediately(0,0, jCanvasOverlap.getWidth(),jCanvasOverlap.getHeight());
		drawOverlap();
	}//GEN-LAST:event_jMenuOptionActionPerformed
	
	private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
		if (timer!=null){
			timer.cancel();
		}
	}//GEN-LAST:event_formWindowClosing
	
	private void jMenuClearTableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuClearTableActionPerformed
		jTableImages.clearContents();
	}//GEN-LAST:event_jMenuClearTableActionPerformed
	
	private void jMenuSaveTableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuSaveTableActionPerformed
		if (!pickupThumbnailFromTable()){
			return;
		}
		
		TableModel model = jTableImages.getModel();
		String[] args = new String[thumbnails.size()*2+1];
		args[0] = rectThumbnailExist.height+","+rectThumbnailExist.width;
		for (int i=0; i<thumbnails.size(); i++){
			Point p = thumbnails.get(i);
			ImagePiece tn = (ImagePiece)model.getValueAt(p.y*2+1,p.x*2+1);
			args[i*2+1] = p.x+","+p.y;
			args[i*2+2] = tn.getPath();
		}
		imageIO.writeStrings(args);
	}//GEN-LAST:event_jMenuSaveTableActionPerformed
	
	private void jMenuOpenTableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuOpenTableActionPerformed
		createLoadImageTask();
		timer.schedule(taskLoadImage, 100);
	}//GEN-LAST:event_jMenuOpenTableActionPerformed
	
	private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
		jDialogSetTable.setVisible(false);
	}//GEN-LAST:event_jButtonCancelActionPerformed
	
	private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
		int row = (Integer)jSpinnerRowNumber.getValue();
		int column = (Integer)jSpinnerColumnNumber.getValue();
		jTableImages.setTable(row*2+1,column*2+1);
		jDialogSetTable.setVisible(false);
	}//GEN-LAST:event_jButtonOKActionPerformed
	
	private void jMenuSetTableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuSetTableActionPerformed
		jSpinnerColumnNumber.setValue(jTableImages.getColumnCount()/2);
		jSpinnerRowNumber.setValue(jTableImages.getRowCount()/2);
		jDialogSetTable.setVisible(true);
	}//GEN-LAST:event_jMenuSetTableActionPerformed
	
	private void jMenuAnalyzeStartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuAnalyzeStartActionPerformed
		createAnalyzeTask();
		timer.schedule(taskAnalyze,50);
	}//GEN-LAST:event_jMenuAnalyzeStartActionPerformed
	
	private void jMenuDeleteImageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuDeleteImageActionPerformed
		int rowIndex = jTableImages.getSelectedRow();
		int columnIndex = jTableImages.getSelectedColumn();
		jTableImages.setValueAt(null, rowIndex,columnIndex);
	}//GEN-LAST:event_jMenuDeleteImageActionPerformed
	
	private void jMenuRemoveRowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuRemoveRowActionPerformed
		if (3<jTableImages.getRowCount()){
			int rowIndex = jTableImages.getSelectedRow();
			if (rowIndex%2==1){
				DefaultTableModel model = (DefaultTableModel)jTableImages.getModel();
				model.removeRow(rowIndex);
				model.removeRow(rowIndex);
			}
		}
		jTableImages.setDragging(false);
	}//GEN-LAST:event_jMenuRemoveRowActionPerformed
	
	private void jMenuRemoveColumnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuRemoveColumnActionPerformed
		if (3<jTableImages.getColumnCount()){
			int columnIndex = jTableImages.getSelectedColumn();
			if (columnIndex%2==1){
				jTableImages.removeColumnAndData(columnIndex,2);
			}
		}
		jTableImages.setDragging(false);
	}//GEN-LAST:event_jMenuRemoveColumnActionPerformed
	
	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				new OrchViewer().setVisible(true);
			}
		});
	}
	
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private sos.awt.JCanvas jCanvasOverlap;
    private javax.swing.JDialog jDialogOption;
    private javax.swing.JDialog jDialogSetTable;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JMenu jMenuAnalyze;
    private javax.swing.JMenuItem jMenuAnalyzeStart;
    private javax.swing.JMenuBar jMenuBarMain;
    private javax.swing.JMenuItem jMenuClearTable;
    private javax.swing.JMenuItem jMenuDeleteImage;
    private javax.swing.JMenu jMenuFile;
    private javax.swing.JMenuItem jMenuOpenTable;
    private javax.swing.JMenuItem jMenuOption;
    private javax.swing.JMenuItem jMenuRemoveColumn;
    private javax.swing.JMenuItem jMenuRemoveRow;
    private javax.swing.JMenuItem jMenuSaveTable;
    private javax.swing.JMenuItem jMenuSetTable;
    private javax.swing.JMenu jMenuTable;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPopupMenu jPopupRemove;
    private javax.swing.JScrollPane jScrollTableImages;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSpinner jSpinnerColumnNumber;
    private javax.swing.JSpinner jSpinnerHorizontal;
    private javax.swing.JSpinner jSpinnerMinimum;
    private javax.swing.JSpinner jSpinnerRowNumber;
    private javax.swing.JSpinner jSpinnerVertical;
    private orch.JDropableTable jTableImages;
    // ϐ錾̏I//GEN-END:variables
	
}
