/*
 * Decompiled with CFR 0.152.
 */
import gunmetry.ExtractMarkerPlugin;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import sos.gui.JGenericPanel;
import sos.process.Morphology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnePerRegion
implements ExtractMarkerPlugin {
    private JGenericPanel optionPanel = new JGenericPanel();

    public OnePerRegion() {
        this.optionPanel.addNumericSpinner("min distance = ", new SpinnerNumberModel(2, 1, Integer.MAX_VALUE, 1));
    }

    @Override
    public JPanel getOptionPanel() {
        return this.optionPanel;
    }

    @Override
    public ArrayList<Point> extractMarker(Morphology mo, boolean[] binaryMap) {
        int minDistance = (Integer)this.optionPanel.getSpinnerNumber(0);
        int[] distanceMap = mo.geodesicDistance8(binaryMap);
        ArrayList<Point> result = new ArrayList<Point>();
        int[] regionMap = new int[binaryMap.length];
        int nRegion = mo.extractRegion4(binaryMap, regionMap);
        Point[] markers = new Point[nRegion];
        int[] maxDistance = new int[nRegion];
        for (int y = 0; y < mo.getHeight(); ++y) {
            for (int x = 0; x < mo.getWidth(); ++x) {
                int region;
                int offset = x + y * mo.getWidth();
                if (minDistance > distanceMap[offset] || maxDistance[region = regionMap[offset]] >= distanceMap[offset]) continue;
                maxDistance[region] = distanceMap[offset];
                if (markers[region] != null) {
                    markers[region].setLocation(x, y);
                    continue;
                }
                markers[region] = new Point(x, y);
            }
        }
        for (int i = 0; i < markers.length; ++i) {
            if (markers[i] == null) continue;
            result.add(markers[i]);
        }
        return result;
    }
}

