/*
 * Decompiled with CFR 0.152.
 */
package gunmetry;

import gunmetry.AnalyzePlugin;
import gunmetry.ExtractMarkerPlugin;
import gunmetry.ImageColorPicker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import sos.awt.JImageCanvas;
import sos.gui.JCanvasColor;
import sos.io.Extension;
import sos.io.ExtensionFilter;
import sos.io.PluginClassLoader;
import sos.io.SOSFileIO;
import sos.io.SOSImageIO;
import sos.process.ImageInfo;
import sos.process.ImagePixelMediator;
import sos.process.Morphology;
import sos.process.NeighborFrame;
import sos.process.ROI;
import sos.process.Watershed;
import sos.util.ColorVector;
import sos.util.FirstInFirstOut;
import sos.util.MinMaxDouble;
import sos.util.PointRect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GunmetryViewer
extends JFrame {
    private static final String sep = System.getProperty("file.separator");
    private static final String pathExtractMarker = "extractMarker";
    private static final String pathAnalyze = "analyze";
    private static final ExtensionFilter filterImg;
    private static final ExtensionFilter filterGifPng;
    private static ImageIcon iconObject;
    private static ImageIcon iconBackground;
    private static Cursor cursorObject;
    private static Cursor cursorBackground;
    private static int BACKGROUND;
    private File fileOriginal = null;
    private File fileCluster = null;
    private BufferedImage imgBackground;
    private Image imgResult;
    private BufferedImage imgOverlap;
    private ArrayList<Point> markersObject = new ArrayList();
    private ArrayList<Point> markersBackground = new ArrayList();
    private boolean[] analyzeMask;
    private ImageInfo imiAnalyze = new ImageInfo();
    private double[] gradient;
    private int[] contourRegion;
    private int[] contourSkiz;
    private ROI[] nuclei;
    private ROI[] skiz;
    private Point focusedMarker = new Point(0, 0);
    private Point dragStartPoint = new Point();
    private Rectangle selectionRect;
    private HashSet<Point> selectedMarkers = new HashSet();
    private HashSet<Rectangle> dirtyRegion = new HashSet();
    private PointRect pointRect = new PointRect(0, 0, 5);
    private int[] stepArray;
    private int[] orderArray;
    private int currentOrder;
    private SOSImageIO imageFileIO = new SOSImageIO();
    private SOSFileIO textFileIO = new SOSFileIO();
    private int preWidth;
    private int preHeight;
    private BufferedImage imgCursor = new BufferedImage(32, 32, 2);
    private boolean isObjectActive = true;
    private ExtractMarkerPlugin pluginMarkerObject;
    private ExtractMarkerPlugin pluginMarkerBackground;
    private ButtonGroup buttonGroupImage;
    private ButtonGroup buttonGroupOperation;
    private ImageColorPicker imageColorPickerMarker;
    private ImageColorPicker imageColorPickerMask;
    private JButton jButtonAnalyze;
    private JButton jButtonAnimation;
    private JButton jButtonAssignColorsToMarkers;
    private JButton jButtonCancelMarker;
    private JButton jButtonCancelMask;
    private JButton jButtonCancelResult;
    private JButton jButtonOKResult;
    private JButton jButtonSaveAnimation;
    private JButton jButtonSetCluster;
    private JButton jButtonSetMarker;
    private JButton jButtonSetMask;
    private JButton jButtonSetOriginal;
    private JButton jButtonSwitchMarker;
    private JCanvasColor jCanvasColorBack;
    private JCanvasColor jCanvasColorMask;
    private JCanvasColor jCanvasColorNearestNeighbor;
    private JCanvasColor jCanvasColorObj;
    private JCanvasColor jCanvasColorObjCent;
    private JCanvasColor jCanvasColorSkiz;
    private JCanvasColor jCanvasColorSkizCent;
    private JCanvasColor jCanvasColorWatershed;
    private JCheckBox jCheckMask;
    private JComboBox jComboBackAlgorithm;
    private JComboBox jComboObjAlgorithm;
    private JDialog jDialogAnalyze;
    private JDialog jDialogAnimation;
    private JDialog jDialogMarker;
    private JDialog jDialogMask;
    private JImageCanvas jImageAnimation;
    private JImageCanvas jImageMain;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JLabel jLabelFrame;
    private JLabel jLabelInfo;
    private JLabel jLabelNBackground;
    private JLabel jLabelNObject;
    private JMenuBar jMenuBarMain;
    private JMenuItem jMenuDeleteSelection;
    private JMenu jMenuFile;
    private JMenuItem jMenuOpenMarkers;
    private JMenu jMenuResult;
    private JMenuItem jMenuSaveData;
    private JMenuItem jMenuSaveImage;
    private JMenuItem jMenuSaveMarkers;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanelBackground;
    private JPanel jPanelButtons;
    private JPanel jPanelButtons1;
    private JPanel jPanelImage;
    private JPanel jPanelMain;
    private JPanel jPanelMarkers;
    private JPanel jPanelObject;
    private JPanel jPanelOeration;
    private JPanel jPanelResult;
    private JPopupMenu jPopupMenuDelete;
    private JRadioButton jRadioCluster;
    private JRadioButton jRadioGradient;
    private JRadioButton jRadioOriginal;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneMarker;
    private JScrollPane jScrollPaneMask;
    private JSlider jSliderAlpha;
    private JSlider jSliderFrame;
    private JSpinner jSpinnerMarkerSize;
    private JTable jTableAnalyze;
    private JToggleButton jToggleBackground;
    private JToggleButton jToggleImage;
    private JToggleButton jToggleMarker;
    private JToggleButton jToggleNearestNeighbor;
    private JToggleButton jToggleObjCent;
    private JToggleButton jToggleObject;
    private JToggleButton jToggleSkiz;
    private JToggleButton jToggleSkizCent;
    private JToggleButton jToggleWatershed;

    public GunmetryViewer() {
        iconObject = new ImageIcon(this.getClass().getResource("/opBtn1.gif"));
        iconBackground = new ImageIcon(this.getClass().getResource("/opBtn2.gif"));
        this.setupKeyInput();
        this.initComponents();
        this.jCanvasColorMask.setColor(Color.black);
        this.jCanvasColorObj.setColor(Color.red);
        this.jCanvasColorBack.setColor(Color.yellow);
        this.jCanvasColorWatershed.setColor(Color.black);
        this.jCanvasColorSkiz.setColor(Color.black);
        this.jCanvasColorObjCent.setColor(Color.cyan);
        this.jCanvasColorSkizCent.setColor(Color.blue);
        this.jCanvasColorNearestNeighbor.setColor(Color.black);
        cursorObject = this.createCursor(this.jCanvasColorObj.getColor());
        cursorBackground = this.createCursor(this.jCanvasColorBack.getColor());
        SpinnerNumberModel modelMarkerSize = new SpinnerNumberModel(5, 1, 1000, 1);
        this.jSpinnerMarkerSize.setModel(modelMarkerSize);
        this.pack();
        this.loadExtractMarkerPlugin();
        this.jDialogMarker.pack();
        this.jDialogMask.pack();
        this.loadAnalyzePlugin();
        this.jDialogAnalyze.pack();
        DefaultTableColumnModel columnModel = (DefaultTableColumnModel)this.jTableAnalyze.getColumnModel();
        columnModel.getColumn(1).setPreferredWidth(50);
        this.setVisible(true);
    }

    private Cursor createCursor(Color color) {
        int size = this.imgCursor.getWidth();
        int hSize = size / 2;
        int fqSize = size / 4;
        Graphics g = this.imgCursor.getGraphics();
        Color colorClear = new Color(0, 0, 0, 0);
        g.setColor(colorClear);
        g.fillRect(0, 0, size, size);
        g.setColor(Color.black);
        g.fillRect(fqSize, hSize - 1, hSize + 1, 3);
        g.fillRect(hSize - 1, fqSize, 3, hSize + 1);
        g.setColor(color);
        g.drawLine(fqSize, hSize, size - fqSize, hSize);
        g.drawLine(hSize, fqSize, hSize, size - fqSize);
        return Toolkit.getDefaultToolkit().createCustomCursor(this.imgCursor, new Point(hSize, hSize), "object");
    }

    private void setupKeyInput() {
        KeyboardFocusManager keyboardManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardManager.addKeyEventPostProcessor(new KeyEventPostProcessor(){

            public boolean postProcessKeyEvent(KeyEvent evt) {
                switch (evt.getID()) {
                    case 401: {
                        int keyCode = evt.getKeyCode();
                        if (keyCode == 127) {
                            GunmetryViewer.this.removeSelectedMarkers();
                            break;
                        }
                        if (keyCode == 88) {
                            GunmetryViewer.this.switchEditableMarkerType();
                            break;
                        }
                        if (keyCode == 9) {
                            GunmetryViewer.this.changeOperationButton();
                            break;
                        }
                        if (37 > keyCode || keyCode > 40) break;
                        GunmetryViewer.this.moveMarker(keyCode);
                        break;
                    }
                    case 402: {
                        break;
                    }
                }
                return false;
            }
        });
    }

    private void moveMarker(int keyCode) {
        if (0 < this.selectedMarkers.size()) {
            int dx = 0;
            int dy = 0;
            switch (keyCode) {
                case 37: {
                    dx = -1;
                    break;
                }
                case 38: {
                    dy = -1;
                    break;
                }
                case 39: {
                    dx = 1;
                    break;
                }
                case 40: {
                    dy = 1;
                }
            }
            for (Point p : this.selectedMarkers) {
                p.translate(dx, dy);
            }
            this.drawMarkers();
            this.updateFullCanvas();
        }
    }

    private void switchEditableMarkerType() {
        boolean bl = this.isObjectActive = !this.isObjectActive;
        if (this.isObjectActive) {
            this.jToggleMarker.setIcon(iconObject);
            if (this.jToggleMarker.isSelected()) {
                this.jImageMain.setCursor(cursorObject);
            }
        } else {
            this.jToggleMarker.setIcon(iconBackground);
            if (this.jToggleMarker.isSelected()) {
                this.jImageMain.setCursor(cursorBackground);
            }
        }
    }

    private void changeOperationButton() {
        if (this.jToggleMarker.isSelected()) {
            this.jToggleImage.setSelected(true);
        } else {
            this.jToggleMarker.setSelected(true);
        }
    }

    private void loadExtractMarkerPlugin() {
        File file = new File(pathExtractMarker);
        File[] fileList = file.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            String algorithmName = Extension.remove(fileList[i].getName());
            this.jComboObjAlgorithm.addItem(algorithmName);
            this.jComboBackAlgorithm.addItem(algorithmName);
        }
        this.jComboObjAlgorithm.setSelectedItem("HDoom");
        this.jComboBackAlgorithm.setSelectedItem("HDoom");
    }

    private ExtractMarkerPlugin setMarkerOption(JPanel panel, String algorithmName) {
        PluginClassLoader loader = new PluginClassLoader(pathExtractMarker);
        ExtractMarkerPlugin plugin = null;
        try {
            plugin = (ExtractMarkerPlugin)loader.loadClass(algorithmName).newInstance();
            JPanel optionPanel = plugin.getOptionPanel();
            if (2 == panel.getComponentCount()) {
                panel.remove(1);
            }
            if (optionPanel != null) {
                panel.add((Component)optionPanel, "Center");
            }
            this.jDialogMarker.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return plugin;
    }

    private void loadAnalyzePlugin() {
        File file = new File(pathAnalyze);
        File[] fileList = file.listFiles();
        DefaultTableModel model = (DefaultTableModel)this.jTableAnalyze.getModel();
        model.setRowCount(fileList.length);
        for (int i = 0; i < fileList.length; ++i) {
            String algorithmName = Extension.remove(fileList[i].getName());
            model.setValueAt(algorithmName, i, 0);
            model.setValueAt(false, i, 1);
        }
    }

    private void updateResultImage() {
        if (this.imgResult != null) {
            double value = (double)this.jSliderAlpha.getValue() / 100.0;
            this.imgResult = ImagePixelMediator.setAlpha(this.imgResult, value);
            this.overlapImage();
            this.drawMarkers();
            this.updateFullCanvas();
        }
    }

    private boolean checkBackgroundImageSize(Dimension size) {
        return this.imgBackground != null && size.width == this.imgBackground.getWidth() && size.height == this.imgBackground.getHeight();
    }

    private void drawImageToImgBackground(Image img) {
        if (img == null) {
            return;
        }
        Graphics g = this.imgBackground.getGraphics();
        g.drawImage(img, 0, 0, null);
        this.overlapImage();
        this.jImageMain.setFullSrc();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void overlapImage() {
        int i;
        Graphics g;
        BufferedImage img = this.imgBackground;
        if (this.imgResult != null) {
            g = (Graphics2D)this.imgOverlap.getGraphics();
            g.drawImage(this.imgBackground, 0, 0, this);
            g.drawImage(this.imgResult, 0, 0, this);
            if (this.jToggleWatershed.isSelected()) {
                g.setColor(this.jCanvasColorWatershed.getColor());
                this.drawContour(g, this.contourRegion);
            }
            if (this.jToggleSkiz.isSelected()) {
                g.setColor(this.jCanvasColorSkiz.getColor());
                this.drawContour(g, this.contourSkiz);
            }
            if (this.jToggleObjCent.isSelected()) {
                g.setColor(this.jCanvasColorObjCent.getColor());
                this.drawCentroid((Graphics2D)g, this.nuclei);
            }
            if (this.jToggleSkizCent.isSelected()) {
                g.setColor(this.jCanvasColorSkizCent.getColor());
                this.drawCentroid((Graphics2D)g, this.skiz);
            }
            if (this.jToggleNearestNeighbor.isSelected()) {
                g.setColor(this.jCanvasColorNearestNeighbor.getColor());
                for (i = 0; i < this.nuclei.length; ++i) {
                    Point2D.Double p1 = this.nuclei[i].getCentroid();
                    Point2D.Double p2 = this.nuclei[i].getNearestNeighbor().getCentroid();
                    g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
                }
            }
            img = this.imgOverlap;
        }
        if (this.jCheckMask.isSelected()) {
            g = img.getGraphics();
            g.setColor(this.jCanvasColorMask.getColor());
            for (i = 0; i < this.analyzeMask.length; ++i) {
                if (!this.analyzeMask[i]) continue;
                int x = i % img.getWidth();
                int y = i / img.getWidth();
                g.drawLine(x, y, x, y);
            }
        }
        this.jImageMain.setImage(img);
    }

    private void drawContour(Graphics g, int[] contourPixels) {
        for (int i = 0; i < contourPixels.length; ++i) {
            int x = contourPixels[i] % this.imgBackground.getWidth();
            int y = contourPixels[i] / this.imgBackground.getWidth();
            g.drawLine(x, y, x, y);
        }
    }

    private void drawCentroid(Graphics2D g, ROI[] roiSet) {
        for (ROI roi : roiSet) {
            Point2D.Double p = roi.getCentroid();
            Rectangle2D.Double r = new Rectangle2D.Double(p.x, p.y, 1.0, 1.0);
            g.draw(r);
        }
    }

    private void drawMarkers() {
        this.jImageMain.drawImage();
        Graphics2D g = (Graphics2D)this.jImageMain.getOffGraphics();
        g.setTransform(this.jImageMain.getAffineTransform());
        if (this.jToggleObject.isSelected() && 0 < this.markersObject.size()) {
            g.setColor(this.jCanvasColorObj.getColor());
            for (Point p : this.markersObject) {
                this.pointRect.setLocation(p.x, p.y);
                g.draw(this.pointRect.getBounds());
            }
        }
        if (this.jToggleBackground.isSelected() && 0 < this.markersBackground.size()) {
            g.setColor(this.jCanvasColorBack.getColor());
            for (Point p : this.markersBackground) {
                this.pointRect.setLocation(p.x, p.y);
                g.draw(this.pointRect.getBounds());
            }
        }
        g.setColor(Color.white);
        PointRect pointRect = new PointRect(0, 0, (Integer)this.jSpinnerMarkerSize.getValue());
        for (Point p : this.selectedMarkers) {
            pointRect.setLocation(p.x, p.y);
            g.fill(pointRect.getBounds());
        }
        if (this.selectionRect != null) {
            g.draw(this.selectionRect);
        }
    }

    private void updateFullCanvas() {
        this.jImageMain.repaint();
        this.dirtyRegion.clear();
    }

    private void updatePartialCanvas(Rectangle rect) {
        this.dirtyRegion.add(rect);
        this.repaintDirtyRegion();
        this.dirtyRegion.add((Rectangle)rect.clone());
    }

    private void repaintDirtyRegion() {
        int extra = (int)this.jImageMain.getMagnification();
        AffineTransform it = this.jImageMain.getAffineTransform();
        for (Rectangle r : this.dirtyRegion) {
            Shape shape = it.createTransformedShape(r);
            if (shape == null) continue;
            Rectangle transR = shape.getBounds();
            transR.grow(extra, extra);
            this.jImageMain.paintImmediately(transR);
        }
        this.dirtyRegion.clear();
    }

    private ArrayList<Point> extractMarker(ExtractMarkerPlugin plugin, boolean[] binaryMap, String algorithmName) {
        NeighborFrame nf = new NeighborFrame(this.imgBackground.getWidth(), this.imgBackground.getHeight());
        Morphology mo = new Morphology(nf);
        return plugin.extractMarker(mo, binaryMap);
    }

    private Point contains(ArrayList<Point> markers, Point2D point) {
        for (Point p : markers) {
            this.pointRect.setLocation(p.x, p.y);
            if (!this.pointRect.contains(point)) continue;
            return p;
        }
        return null;
    }

    private void findFocusedMarker(Point mousePoint) {
        Point preFocus = this.focusedMarker;
        Point2D mousePoint2D = this.jImageMain.getImageTransform().inverseTransform(mousePoint);
        this.focusedMarker = this.contains(this.markersObject, mousePoint2D);
        if (this.focusedMarker == null) {
            this.focusedMarker = this.contains(this.markersBackground, mousePoint2D);
        }
        if (preFocus != this.focusedMarker) {
            if (this.focusedMarker != null) {
                this.jImageMain.setCursor(new Cursor(13));
                this.pointRect.setLocation(this.focusedMarker.x, this.focusedMarker.y);
                this.dirtyRegion.add(this.pointRect.getRectangle());
            } else if (this.isObjectActive) {
                this.jImageMain.setCursor(cursorObject);
            } else {
                this.jImageMain.setCursor(cursorBackground);
            }
        }
    }

    private void addToSelectedMarkers(ArrayList<Point> markers) {
        for (Point p : markers) {
            if (!this.selectionRect.contains(p)) continue;
            this.selectedMarkers.add(p);
        }
    }

    private void removeSelectedMarkers() {
        if (0 == this.selectedMarkers.size()) {
            return;
        }
        this.readyToDrawSelectMarkers();
        this.markersObject.removeAll(this.selectedMarkers);
        this.markersBackground.removeAll(this.selectedMarkers);
        this.selectedMarkers.clear();
        this.drawMarkers();
        this.repaintDirtyRegion();
        this.updateMarkerNumber();
        this.checkReadyToAnalyze();
    }

    private void checkSelectionType(int modifier) {
        if ((modifier & 1) == 0) {
            this.readyToDrawSelectMarkers();
            this.selectedMarkers.clear();
        }
    }

    private void readyToDrawSelectMarkers() {
        for (Point p : this.selectedMarkers) {
            this.pointRect.setLocation(p.x, p.y);
            this.dirtyRegion.add(this.pointRect.getRectangle());
        }
    }

    private ROI[] makeROI() {
        ROI[] result = new ROI[this.markersObject.size()];
        for (int n = 0; n < result.length; ++n) {
            result[n] = new ROI();
        }
        int count = 0;
        for (Point p : this.markersObject) {
            result[count].expandRegion(p.x, p.y);
            ++count;
        }
        int FIRST_LABEL = BACKGROUND + 1;
        for (int y = 0; y < this.imgBackground.getHeight(); ++y) {
            int offset = y * this.imgBackground.getWidth();
            for (int x = 0; x < this.imgBackground.getWidth(); ++x) {
                int pn = x + offset;
                int index = this.imiAnalyze.getPixelsLabel(pn) - FIRST_LABEL;
                if (0 > index) continue;
                result[index].expandRegion(x, y);
            }
        }
        for (int n = 0; n < result.length; ++n) {
            result[n].initMask();
            Rectangle bounds = result[n].getBounds();
            for (int y = 0; y < bounds.height; ++y) {
                int offset = (y + bounds.y) * this.imgBackground.getWidth();
                for (int x = 0; x < bounds.width; ++x) {
                    int pn = x + bounds.x + offset;
                    if (this.imiAnalyze.getPixelsLabel(pn) - FIRST_LABEL != n) continue;
                    result[n].setMask(x, y);
                }
            }
        }
        return result;
    }

    private boolean[] getBinaryMap(boolean[] flag, int[] cluster) {
        boolean[] result = new boolean[cluster.length];
        for (int i = 0; i < cluster.length; ++i) {
            result[i] = flag[cluster[i]];
        }
        return result;
    }

    private void setMarkers(boolean[] flag, int[] colorCluster) {
        boolean[] binaryMap = this.getBinaryMap(flag, colorCluster);
        this.markersObject = this.extractMarker(this.pluginMarkerObject, binaryMap, (String)this.jComboObjAlgorithm.getSelectedItem());
        for (int i = 0; i < binaryMap.length; ++i) {
            binaryMap[i] = !binaryMap[i];
        }
        this.markersBackground = this.extractMarker(this.pluginMarkerBackground, binaryMap, (String)this.jComboBackAlgorithm.getSelectedItem());
        this.drawMarkers();
        this.updateFullCanvas();
        this.updateMarkerNumber();
        this.checkReadyToAnalyze();
    }

    private void checkReadyToAnalyze() {
        boolean isReady = false;
        if (0 < this.markersObject.size() && 0 < this.markersBackground.size()) {
            isReady = true;
        }
        this.jMenuSaveMarkers.setEnabled(isReady);
        this.jCheckMask.setEnabled(isReady);
        this.jButtonAnalyze.setEnabled(isReady);
        if (isReady) {
            this.jLabelInfo.setText("Seed setting is done.");
        } else {
            this.jLabelInfo.setText("Inproper seed setting");
        }
    }

    private void removeMaskedMarkers(ArrayList<Point> markers) {
        HashSet<Point> removeSet = new HashSet<Point>();
        for (Point p : markers) {
            if (!this.analyzeMask[this.pointToOffset(p)]) continue;
            removeSet.add(p);
        }
        markers.removeAll(removeSet);
    }

    private int pointToOffset(Point p) {
        return p.x + p.y * this.imiAnalyze.getWidth();
    }

    private void convertMaskToWatershed(int indexWatershed) {
        if (this.jCheckMask.isSelected()) {
            for (int pn = 0; pn < this.imiAnalyze.getImageSize(); ++pn) {
                if (!this.analyzeMask[pn]) continue;
                this.imiAnalyze.setPixelsLabel(pn, indexWatershed);
            }
        }
    }

    private void makeResultImage() {
        int[] result = new int[this.imiAnalyze.getImageSize()];
        for (int i = 0; i < result.length; ++i) {
            int label = this.imiAnalyze.getPixelsLabel(i);
            result[i] = label > BACKGROUND ? this.jCanvasColorObj.getColorInt() : (label == BACKGROUND ? this.jCanvasColorBack.getColorInt() : this.jCanvasColorMask.getColorInt());
        }
        this.imgResult = ImagePixelMediator.convertToImage(result, this.imiAnalyze.getWidth(), this.imiAnalyze.getHeight());
    }

    private int[] deleteMaskedContour(int[] contour) {
        ArrayList<Integer> notMaskedContour = new ArrayList<Integer>();
        for (int i = 0; i < contour.length; ++i) {
            if (this.analyzeMask[contour[i]]) continue;
            notMaskedContour.add(contour[i]);
        }
        int[] result = new int[notMaskedContour.size()];
        for (int i = 0; i < notMaskedContour.size(); ++i) {
            result[i] = (Integer)notMaskedContour.get(i);
        }
        return result;
    }

    private void initializeAnalysis() {
        this.imgResult = null;
        this.imgOverlap = null;
        this.fileCluster = null;
        this.markersObject.clear();
        this.markersBackground.clear();
        this.jMenuFile.setEnabled(false);
        this.jMenuSaveMarkers.setEnabled(false);
        this.jMenuResult.setEnabled(false);
        this.jCheckMask.setEnabled(false);
        this.jRadioCluster.setEnabled(false);
        this.jButtonSetCluster.setEnabled(false);
        this.jButtonAnalyze.setEnabled(false);
    }

    private void setNearestNeighbor(int[] distanceMap) {
        int i;
        NeighborFrame nf = this.imiAnalyze.getNeighborFrame();
        nf.set8();
        for (i = 0; i < this.skiz.length; ++i) {
            this.skiz[i].setMinDistance(Integer.MAX_VALUE);
        }
        for (i = 0; i < this.contourSkiz.length; ++i) {
            int pn = this.contourSkiz[i];
            int[] neighbor = nf.getDir(pn);
            for (int n = 0; n < neighbor.length; ++n) {
                int label;
                if (neighbor[n] == 0 || 0 > (label = this.imiAnalyze.getPixelsLabel(pn + neighbor[n]) - BACKGROUND - 1) || distanceMap[pn + neighbor[n]] >= this.skiz[label].getMinDistance()) continue;
                int contraNeighbor = pn + neighbor[(n + 4) % neighbor.length];
                int contraLabel = this.imiAnalyze.getPixelsLabel(contraNeighbor) - BACKGROUND - 1;
                if (pn == contraNeighbor || 0 > contraLabel) continue;
                this.skiz[label].setMinDistance(distanceMap[pn + neighbor[n]]);
                this.skiz[label].setNearestNeighbor(this.skiz[contraLabel]);
                this.nuclei[label].setNearestNeighbor(this.nuclei[contraLabel]);
            }
        }
    }

    private void updateMarkerNumber() {
        this.jLabelNObject.setText(Integer.toString(this.markersObject.size()));
        this.jLabelNBackground.setText(Integer.toString(this.markersBackground.size()));
    }

    private Image createImageFromGradient() {
        MinMaxDouble mmd = new MinMaxDouble();
        mmd.compareMax(this.gradient);
        double maxGradient = mmd.getValue();
        int[] pixels = new int[this.gradient.length];
        int alpha = -16777216;
        for (int i = 0; i < this.gradient.length; ++i) {
            int value = (int)(255.0 * this.gradient[i] / maxGradient);
            pixels[i] = alpha + (value << 16) + (value << 8) + value;
        }
        return ImagePixelMediator.convertToImage(pixels, this.imgBackground.getWidth(), this.imgBackground.getHeight());
    }

    private void initComponents() {
        this.buttonGroupImage = new ButtonGroup();
        this.buttonGroupOperation = new ButtonGroup();
        this.jDialogMarker = new JDialog();
        this.jPanelButtons = new JPanel();
        this.jButtonSetMarker = new JButton();
        this.jButtonCancelMarker = new JButton();
        this.jPanelObject = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jComboObjAlgorithm = new JComboBox();
        this.jPanelBackground = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jComboBackAlgorithm = new JComboBox();
        this.jScrollPaneMarker = new JScrollPane();
        this.imageColorPickerMarker = new ImageColorPicker();
        this.jDialogMask = new JDialog();
        this.jPanelButtons1 = new JPanel();
        this.jButtonSetMask = new JButton();
        this.jButtonCancelMask = new JButton();
        this.jScrollPaneMask = new JScrollPane();
        this.imageColorPickerMask = new ImageColorPicker();
        this.jDialogAnimation = new JDialog();
        this.jImageAnimation = new JImageCanvas();
        this.jPanel7 = new JPanel();
        this.jSliderFrame = new JSlider();
        this.jPanel8 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabelFrame = new JLabel();
        this.jButtonSaveAnimation = new JButton();
        this.jDialogAnalyze = new JDialog();
        this.jScrollPane1 = new JScrollPane();
        this.jTableAnalyze = new JTable();
        this.jButtonOKResult = new JButton();
        this.jButtonCancelResult = new JButton();
        this.jPopupMenuDelete = new JPopupMenu();
        this.jMenuDeleteSelection = new JMenuItem();
        this.jImageMain = new JImageCanvas();
        this.jLabelInfo = new JLabel();
        this.jPanelMain = new JPanel();
        this.jPanelImage = new JPanel();
        this.jRadioCluster = new JRadioButton();
        this.jRadioOriginal = new JRadioButton();
        this.jButtonSetOriginal = new JButton();
        this.jButtonSetCluster = new JButton();
        this.jCheckMask = new JCheckBox();
        this.jCanvasColorMask = new JCanvasColor();
        this.jRadioGradient = new JRadioButton();
        this.jPanelMarkers = new JPanel();
        this.jButtonAssignColorsToMarkers = new JButton();
        this.jToggleObject = new JToggleButton();
        this.jToggleBackground = new JToggleButton();
        this.jLabel1 = new JLabel();
        this.jSpinnerMarkerSize = new JSpinner();
        this.jCanvasColorObj = new JCanvasColor();
        this.jCanvasColorBack = new JCanvasColor();
        this.jLabel7 = new JLabel();
        this.jLabelNObject = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabelNBackground = new JLabel();
        this.jPanelOeration = new JPanel();
        this.jButtonAnalyze = new JButton();
        this.jToggleMarker = new JToggleButton();
        this.jToggleImage = new JToggleButton();
        this.jButtonSwitchMarker = new JButton();
        this.jPanelResult = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSliderAlpha = new JSlider();
        this.jToggleWatershed = new JToggleButton();
        this.jToggleSkiz = new JToggleButton();
        this.jToggleObjCent = new JToggleButton();
        this.jToggleSkizCent = new JToggleButton();
        this.jToggleNearestNeighbor = new JToggleButton();
        this.jCanvasColorWatershed = new JCanvasColor();
        this.jCanvasColorSkiz = new JCanvasColor();
        this.jCanvasColorObjCent = new JCanvasColor();
        this.jCanvasColorSkizCent = new JCanvasColor();
        this.jCanvasColorNearestNeighbor = new JCanvasColor();
        this.jButtonAnimation = new JButton();
        this.jMenuBarMain = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuOpenMarkers = new JMenuItem();
        this.jMenuSaveMarkers = new JMenuItem();
        this.jMenuResult = new JMenu();
        this.jMenuSaveData = new JMenuItem();
        this.jMenuSaveImage = new JMenuItem();
        this.jDialogMarker.getContentPane().setLayout(new GridBagLayout());
        this.jDialogMarker.setTitle("Set Maker");
        this.jDialogMarker.setModal(true);
        this.jButtonSetMarker.setText("SET");
        this.jButtonSetMarker.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonSetMarkerActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonSetMarker);
        this.jButtonCancelMarker.setText("CANCEL");
        this.jButtonCancelMarker.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonCancelMarkerActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonCancelMarker);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jDialogMarker.getContentPane().add((Component)this.jPanelButtons, gridBagConstraints);
        this.jPanelObject.setLayout(new BorderLayout());
        this.jPanelObject.setBorder(new TitledBorder("Object"));
        this.jLabel4.setText("algorithm: ");
        this.jPanel1.add(this.jLabel4);
        this.jComboObjAlgorithm.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jComboObjAlgorithmItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.jComboObjAlgorithm);
        this.jPanelObject.add((Component)this.jPanel1, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jDialogMarker.getContentPane().add((Component)this.jPanelObject, gridBagConstraints);
        this.jPanelBackground.setLayout(new BorderLayout());
        this.jPanelBackground.setBorder(new TitledBorder("Background"));
        this.jLabel5.setText("algorithm: ");
        this.jPanel2.add(this.jLabel5);
        this.jComboBackAlgorithm.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jComboBackAlgorithmItemStateChanged(evt);
            }
        });
        this.jPanel2.add(this.jComboBackAlgorithm);
        this.jPanelBackground.add((Component)this.jPanel2, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jDialogMarker.getContentPane().add((Component)this.jPanelBackground, gridBagConstraints);
        this.jScrollPaneMarker.setBorder(new TitledBorder("Select colors as OBJECT"));
        this.jScrollPaneMarker.setViewportView(this.imageColorPickerMarker);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jDialogMarker.getContentPane().add((Component)this.jScrollPaneMarker, gridBagConstraints);
        this.jDialogMask.getContentPane().setLayout(new GridBagLayout());
        this.jDialogMask.setTitle("Set Mask");
        this.jDialogMask.setModal(true);
        this.jButtonSetMask.setText("SET");
        this.jButtonSetMask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonSetMaskActionPerformed(evt);
            }
        });
        this.jPanelButtons1.add(this.jButtonSetMask);
        this.jButtonCancelMask.setText("CANCEL");
        this.jButtonCancelMask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonCancelMaskActionPerformed(evt);
            }
        });
        this.jPanelButtons1.add(this.jButtonCancelMask);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jDialogMask.getContentPane().add((Component)this.jPanelButtons1, gridBagConstraints);
        this.jScrollPaneMask.setBorder(new TitledBorder("Select color as MASK"));
        this.jScrollPaneMask.setViewportView(this.imageColorPickerMask);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.jDialogMask.getContentPane().add((Component)this.jScrollPaneMask, gridBagConstraints);
        this.jDialogAnimation.setTitle("Gunmetry Animation");
        this.jDialogAnimation.getContentPane().add((Component)this.jImageAnimation, "Center");
        this.jPanel7.setLayout(new BorderLayout());
        this.jSliderFrame.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GunmetryViewer.this.jSliderFrameStateChanged(evt);
            }
        });
        this.jPanel7.add((Component)this.jSliderFrame, "Center");
        this.jLabel6.setText("Level: ");
        this.jPanel8.add(this.jLabel6);
        this.jLabelFrame.setMinimumSize(new Dimension(30, 16));
        this.jLabelFrame.setPreferredSize(new Dimension(30, 16));
        this.jPanel8.add(this.jLabelFrame);
        this.jPanel7.add((Component)this.jPanel8, "West");
        this.jButtonSaveAnimation.setText("SAVE");
        this.jButtonSaveAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonSaveAnimationActionPerformed(evt);
            }
        });
        this.jPanel7.add((Component)this.jButtonSaveAnimation, "East");
        this.jDialogAnimation.getContentPane().add((Component)this.jPanel7, "South");
        this.jDialogAnalyze.getContentPane().setLayout(new GridBagLayout());
        this.jDialogAnalyze.setTitle("RESULT");
        this.jScrollPane1.setMinimumSize(new Dimension(300, 300));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 300));
        this.jTableAnalyze.setModel(new DefaultTableModel(new Object[0][], new String[]{"Variable", "Output"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Boolean.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTableAnalyze);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.jDialogAnalyze.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonOKResult.setText("OK");
        this.jButtonOKResult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonOKResultActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jDialogAnalyze.getContentPane().add((Component)this.jButtonOKResult, gridBagConstraints);
        this.jButtonCancelResult.setText("CANCEL");
        this.jButtonCancelResult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonCancelResultActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jDialogAnalyze.getContentPane().add((Component)this.jButtonCancelResult, gridBagConstraints);
        this.jMenuDeleteSelection.setText("Delete Selected");
        this.jMenuDeleteSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jMenuDeleteSelectionActionPerformed(evt);
            }
        });
        this.jPopupMenuDelete.add(this.jMenuDeleteSelection);
        this.setDefaultCloseOperation(3);
        this.setTitle("Gunmetry Ver. 2.0");
        this.setCursor(new Cursor(0));
        this.jImageMain.setComponentPopupMenu(this.jPopupMenuDelete);
        this.jImageMain.setPreferredSize(new Dimension(640, 480));
        this.jImageMain.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                GunmetryViewer.this.jImageMainComponentResized(evt);
            }
        });
        this.jImageMain.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                GunmetryViewer.this.jImageMainMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                GunmetryViewer.this.jImageMainMouseMoved(evt);
            }
        });
        this.jImageMain.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GunmetryViewer.this.jImageMainMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                GunmetryViewer.this.jImageMainMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                GunmetryViewer.this.jImageMainMouseReleased(evt);
            }
        });
        this.getContentPane().add((Component)this.jImageMain, "Center");
        this.jLabelInfo.setText(" ");
        this.getContentPane().add((Component)this.jLabelInfo, "South");
        this.jPanelMain.setLayout(new GridBagLayout());
        this.jPanelImage.setLayout(new GridBagLayout());
        this.jPanelImage.setBorder(new TitledBorder("Image"));
        this.buttonGroupImage.add(this.jRadioCluster);
        this.jRadioCluster.setText("cluster");
        this.jRadioCluster.setEnabled(false);
        this.jRadioCluster.setFocusable(false);
        this.jRadioCluster.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jRadioClusterItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanelImage.add((Component)this.jRadioCluster, gridBagConstraints);
        this.buttonGroupImage.add(this.jRadioOriginal);
        this.jRadioOriginal.setSelected(true);
        this.jRadioOriginal.setText("original");
        this.jRadioOriginal.setFocusable(false);
        this.jRadioOriginal.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jRadioOriginalItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanelImage.add((Component)this.jRadioOriginal, gridBagConstraints);
        this.jButtonSetOriginal.setText("Load");
        this.jButtonSetOriginal.setFocusCycleRoot(true);
        this.jButtonSetOriginal.setFocusPainted(false);
        this.jButtonSetOriginal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonSetOriginalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanelImage.add((Component)this.jButtonSetOriginal, gridBagConstraints);
        this.jButtonSetCluster.setText("Load");
        this.jButtonSetCluster.setEnabled(false);
        this.jButtonSetCluster.setFocusable(false);
        this.jButtonSetCluster.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonSetClusterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanelImage.add((Component)this.jButtonSetCluster, gridBagConstraints);
        this.jCheckMask.setText("mask");
        this.jCheckMask.setEnabled(false);
        this.jCheckMask.setFocusable(false);
        this.jCheckMask.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jCheckMaskItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.jPanelImage.add((Component)this.jCheckMask, gridBagConstraints);
        this.jCanvasColorMask.setEnabled(false);
        this.jCanvasColorMask.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GunmetryViewer.this.jCanvasColorMaskMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 37, 0, 0);
        this.jPanelImage.add((Component)this.jCanvasColorMask, gridBagConstraints);
        this.buttonGroupImage.add(this.jRadioGradient);
        this.jRadioGradient.setText("gradient");
        this.jRadioGradient.setEnabled(false);
        this.jRadioGradient.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jRadioGradientItemStateChanged(evt);
            }
        });
        this.jRadioGradient.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jRadioGradientActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanelImage.add((Component)this.jRadioGradient, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        this.jPanelMain.add((Component)this.jPanelImage, gridBagConstraints);
        this.jPanelMarkers.setLayout(new GridBagLayout());
        this.jPanelMarkers.setBorder(new TitledBorder("Markers"));
        this.jButtonAssignColorsToMarkers.setText("RESETTING");
        this.jButtonAssignColorsToMarkers.setEnabled(false);
        this.jButtonAssignColorsToMarkers.setFocusable(false);
        this.jButtonAssignColorsToMarkers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonAssignColorsToMarkersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelMarkers.add((Component)this.jButtonAssignColorsToMarkers, gridBagConstraints);
        this.jToggleObject.setIcon(new ImageIcon(this.getClass().getResource("/mkBtn1.gif")));
        this.jToggleObject.setSelected(true);
        this.jToggleObject.setFocusable(false);
        this.jToggleObject.setMargin(new Insets(1, 1, 1, 1));
        this.jToggleObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jToggleObjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelMarkers.add((Component)this.jToggleObject, gridBagConstraints);
        this.jToggleBackground.setIcon(new ImageIcon(this.getClass().getResource("/mkBtn2.gif")));
        this.jToggleBackground.setSelected(true);
        this.jToggleBackground.setFocusable(false);
        this.jToggleBackground.setMargin(new Insets(1, 1, 1, 1));
        this.jToggleBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jToggleBackgroundActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanelMarkers.add((Component)this.jToggleBackground, gridBagConstraints);
        this.jLabel1.setText("size: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanelMarkers.add((Component)this.jLabel1, gridBagConstraints);
        this.jSpinnerMarkerSize.setFocusable(false);
        this.jSpinnerMarkerSize.setRequestFocusEnabled(false);
        this.jSpinnerMarkerSize.setVerifyInputWhenFocusTarget(false);
        this.jSpinnerMarkerSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GunmetryViewer.this.jSpinnerMarkerSizeStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelMarkers.add((Component)this.jSpinnerMarkerSize, gridBagConstraints);
        this.jCanvasColorObj.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GunmetryViewer.this.jCanvasColorObjMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanelMarkers.add((Component)this.jCanvasColorObj, gridBagConstraints);
        this.jCanvasColorBack.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GunmetryViewer.this.jCanvasColorBackMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.jPanelMarkers.add((Component)this.jCanvasColorBack, gridBagConstraints);
        this.jLabel7.setText("n =");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanelMarkers.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabelNObject.setHorizontalAlignment(4);
        this.jLabelNObject.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanelMarkers.add((Component)this.jLabelNObject, gridBagConstraints);
        this.jLabel9.setText("n =");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanelMarkers.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabelNBackground.setHorizontalAlignment(4);
        this.jLabelNBackground.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.jPanelMarkers.add((Component)this.jLabelNBackground, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 6;
        this.jPanelMain.add((Component)this.jPanelMarkers, gridBagConstraints);
        this.jPanelOeration.setLayout(new GridBagLayout());
        this.jPanelOeration.setBorder(new TitledBorder("Operation"));
        this.jButtonAnalyze.setText("ANALYZE");
        this.jButtonAnalyze.setEnabled(false);
        this.jButtonAnalyze.setFocusable(false);
        this.jButtonAnalyze.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonAnalyzeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelOeration.add((Component)this.jButtonAnalyze, gridBagConstraints);
        this.buttonGroupOperation.add(this.jToggleMarker);
        this.jToggleMarker.setIcon(new ImageIcon(this.getClass().getResource("/opBtn1.gif")));
        this.jToggleMarker.setSelected(true);
        this.jToggleMarker.setFocusPainted(false);
        this.jToggleMarker.setFocusable(false);
        this.jToggleMarker.setMargin(new Insets(1, 1, 1, 1));
        this.jToggleMarker.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jToggleMarkerItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanelOeration.add((Component)this.jToggleMarker, gridBagConstraints);
        this.buttonGroupOperation.add(this.jToggleImage);
        this.jToggleImage.setIcon(new ImageIcon(this.getClass().getResource("/opBtn4.gif")));
        this.jToggleImage.setFocusPainted(false);
        this.jToggleImage.setFocusable(false);
        this.jToggleImage.setMargin(new Insets(1, 1, 1, 1));
        this.jToggleImage.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jToggleImageItemStateChanged(evt);
            }
        });
        this.jToggleImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jToggleImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanelOeration.add((Component)this.jToggleImage, gridBagConstraints);
        this.jButtonSwitchMarker.setText("SWITCH MARKER");
        this.jButtonSwitchMarker.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonSwitchMarkerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelOeration.add((Component)this.jButtonSwitchMarker, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanelMain.add((Component)this.jPanelOeration, gridBagConstraints);
        this.jPanelResult.setLayout(new GridBagLayout());
        this.jPanelResult.setBorder(new TitledBorder("Result"));
        this.jLabel3.setText("alpha: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanelResult.add((Component)this.jLabel3, gridBagConstraints);
        this.jSliderAlpha.setMajorTickSpacing(50);
        this.jSliderAlpha.setMinorTickSpacing(10);
        this.jSliderAlpha.setPaintTicks(true);
        this.jSliderAlpha.setEnabled(false);
        this.jSliderAlpha.setPreferredSize(new Dimension(100, 24));
        this.jSliderAlpha.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GunmetryViewer.this.jSliderAlphaStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanelResult.add((Component)this.jSliderAlpha, gridBagConstraints);
        this.jToggleWatershed.setIcon(new ImageIcon(this.getClass().getResource("/reBtn1.gif")));
        this.jToggleWatershed.setSelected(true);
        this.jToggleWatershed.setFocusable(false);
        this.jToggleWatershed.setMargin(new Insets(1, 1, 1, 1));
        this.jToggleWatershed.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jToggleWatershedItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanelResult.add((Component)this.jToggleWatershed, gridBagConstraints);
        this.jToggleSkiz.setIcon(new ImageIcon(this.getClass().getResource("/reBtn2.gif")));
        this.jToggleSkiz.setSelected(true);
        this.jToggleSkiz.setFocusable(false);
        this.jToggleSkiz.setMargin(new Insets(1, 1, 1, 1));
        this.jToggleSkiz.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jToggleSkizItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanelResult.add((Component)this.jToggleSkiz, gridBagConstraints);
        this.jToggleObjCent.setIcon(new ImageIcon(this.getClass().getResource("/reBtn3.gif")));
        this.jToggleObjCent.setFocusable(false);
        this.jToggleObjCent.setMargin(new Insets(1, 1, 1, 1));
        this.jToggleObjCent.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jToggleObjCentItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jPanelResult.add((Component)this.jToggleObjCent, gridBagConstraints);
        this.jToggleSkizCent.setIcon(new ImageIcon(this.getClass().getResource("/reBtn4.gif")));
        this.jToggleSkizCent.setFocusable(false);
        this.jToggleSkizCent.setMargin(new Insets(1, 1, 1, 1));
        this.jToggleSkizCent.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jToggleSkizCentItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.jPanelResult.add((Component)this.jToggleSkizCent, gridBagConstraints);
        this.jToggleNearestNeighbor.setIcon(new ImageIcon(this.getClass().getResource("/reBtn5.gif")));
        this.jToggleNearestNeighbor.setFocusable(false);
        this.jToggleNearestNeighbor.setMargin(new Insets(1, 1, 1, 1));
        this.jToggleNearestNeighbor.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GunmetryViewer.this.jToggleNearestNeighborItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.jPanelResult.add((Component)this.jToggleNearestNeighbor, gridBagConstraints);
        this.jCanvasColorWatershed.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GunmetryViewer.this.jCanvasColorWatershedMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelResult.add((Component)this.jCanvasColorWatershed, gridBagConstraints);
        this.jCanvasColorSkiz.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GunmetryViewer.this.jCanvasColorSkizMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelResult.add((Component)this.jCanvasColorSkiz, gridBagConstraints);
        this.jCanvasColorObjCent.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GunmetryViewer.this.jCanvasColorObjCentMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelResult.add((Component)this.jCanvasColorObjCent, gridBagConstraints);
        this.jCanvasColorSkizCent.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GunmetryViewer.this.jCanvasColorSkizCentMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelResult.add((Component)this.jCanvasColorSkizCent, gridBagConstraints);
        this.jCanvasColorNearestNeighbor.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GunmetryViewer.this.jCanvasColorNearestNeighborMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelResult.add((Component)this.jCanvasColorNearestNeighbor, gridBagConstraints);
        this.jButtonAnimation.setText("ANIMATION");
        this.jButtonAnimation.setEnabled(false);
        this.jButtonAnimation.setFocusable(false);
        this.jButtonAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jButtonAnimationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.jPanelResult.add((Component)this.jButtonAnimation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanelMain.add((Component)this.jPanelResult, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanelMain, "West");
        this.jMenuFile.setText("File");
        this.jMenuFile.setEnabled(false);
        this.jMenuOpenMarkers.setText("Open Markers");
        this.jMenuOpenMarkers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jMenuOpenMarkersActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuOpenMarkers);
        this.jMenuSaveMarkers.setText("Save Markers");
        this.jMenuSaveMarkers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jMenuSaveMarkersActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveMarkers);
        this.jMenuBarMain.add(this.jMenuFile);
        this.jMenuResult.setText("Result");
        this.jMenuResult.setEnabled(false);
        this.jMenuSaveData.setText("Save Data");
        this.jMenuSaveData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jMenuSaveDataActionPerformed(evt);
            }
        });
        this.jMenuResult.add(this.jMenuSaveData);
        this.jMenuSaveImage.setText("Save Image");
        this.jMenuSaveImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GunmetryViewer.this.jMenuSaveImageActionPerformed(evt);
            }
        });
        this.jMenuResult.add(this.jMenuSaveImage);
        this.jMenuBarMain.add(this.jMenuResult);
        this.setJMenuBar(this.jMenuBarMain);
        this.pack();
    }

    private void jButtonSwitchMarkerActionPerformed(ActionEvent evt) {
        this.switchEditableMarkerType();
    }

    private void jComboBackAlgorithmItemStateChanged(ItemEvent evt) {
        this.pluginMarkerBackground = this.setMarkerOption(this.jPanelBackground, (String)this.jComboBackAlgorithm.getSelectedItem());
    }

    private void jComboObjAlgorithmItemStateChanged(ItemEvent evt) {
        this.pluginMarkerObject = this.setMarkerOption(this.jPanelObject, (String)this.jComboObjAlgorithm.getSelectedItem());
    }

    private void jButtonCancelMaskActionPerformed(ActionEvent evt) {
        this.jDialogMask.setVisible(false);
    }

    private void jButtonSetMaskActionPerformed(ActionEvent evt) {
        int nChecked = this.imageColorPickerMask.getCheckedNumber();
        if (nChecked == 0 || nChecked == this.imageColorPickerMask.getColorNumber()) {
            this.jLabelInfo.setText("Invalid color selections");
            return;
        }
        this.jDialogMask.setVisible(false);
    }

    private void jRadioGradientActionPerformed(ActionEvent evt) {
    }

    private void jRadioGradientItemStateChanged(ItemEvent evt) {
        if (this.jRadioGradient.isSelected() && this.gradient != null) {
            Image img = this.createImageFromGradient();
            this.drawImageToImgBackground(img);
        }
    }

    private void jCanvasColorNearestNeighborMousePressed(MouseEvent evt) {
        this.overlapImage();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jToggleImageItemStateChanged(ItemEvent evt) {
        if (this.jToggleImage.isSelected()) {
            this.jImageMain.setCursor(new Cursor(12));
            this.jImageMain.setComponentPopupMenu(null);
        }
    }

    private void jToggleMarkerItemStateChanged(ItemEvent evt) {
        if (this.jToggleMarker.isSelected()) {
            this.jImageMain.setCursor(cursorObject);
            this.jImageMain.setComponentPopupMenu(this.jPopupMenuDelete);
        }
    }

    private void jImageMainComponentResized(ComponentEvent evt) {
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jMenuDeleteSelectionActionPerformed(ActionEvent evt) {
        this.removeSelectedMarkers();
    }

    private void jToggleNearestNeighborItemStateChanged(ItemEvent evt) {
        this.overlapImage();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jMenuSaveImageActionPerformed(ActionEvent evt) {
        BufferedImage img = this.jImageMain.getImage();
        this.imageFileIO.writeImage(img);
    }

    private void jCanvasColorMaskMousePressed(MouseEvent evt) {
        this.overlapImage();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jCanvasColorSkizCentMousePressed(MouseEvent evt) {
        this.overlapImage();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jCanvasColorObjCentMousePressed(MouseEvent evt) {
        this.overlapImage();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jCanvasColorSkizMousePressed(MouseEvent evt) {
        this.overlapImage();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jCanvasColorWatershedMousePressed(MouseEvent evt) {
        this.overlapImage();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jToggleSkizCentItemStateChanged(ItemEvent evt) {
        this.overlapImage();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jToggleObjCentItemStateChanged(ItemEvent evt) {
        this.overlapImage();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jToggleSkizItemStateChanged(ItemEvent evt) {
        this.overlapImage();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jToggleWatershedItemStateChanged(ItemEvent evt) {
        this.overlapImage();
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jCheckMaskItemStateChanged(ItemEvent evt) {
        if (this.jCheckMask.isSelected()) {
            this.imageFileIO.resetChoosableFileFilters();
            this.imageFileIO.setFileFilter(filterGifPng);
            File fileMask = this.imageFileIO.getOpenFile("Select a GIF file for mask...");
            if (fileMask == null) {
                this.jCheckMask.setSelected(false);
                return;
            }
            BufferedImage img = SOSImageIO.readImage(fileMask);
            ImageInfo imiMask = new ImageInfo(img);
            int[] maskCluster = imiMask.getPixelsLabel();
            this.imageColorPickerMask.setColorTable(imiMask.getPixels(), imiMask.getPixelsLabel());
            this.jDialogMask.setVisible(true);
            boolean[] flag = this.imageColorPickerMask.getFlag();
            this.analyzeMask = this.getBinaryMap(flag, maskCluster);
            this.overlapImage();
            this.drawMarkers();
            this.updateFullCanvas();
        } else {
            this.analyzeMask = null;
        }
        this.jCanvasColorMask.setEnabled(this.jCheckMask.isSelected());
    }

    private void jButtonSaveAnimationActionPerformed(ActionEvent evt) {
        BufferedImage img = this.jImageAnimation.getImage();
        this.imageFileIO.writeImage(img);
    }

    private void jButtonOKResultActionPerformed(ActionEvent evt) {
        ArrayList<ArrayList<Double>> result = new ArrayList<ArrayList<Double>>();
        ArrayList<String> variableName = new ArrayList<String>();
        PluginClassLoader loader = new PluginClassLoader(pathAnalyze);
        for (int i = 0; i < this.jTableAnalyze.getRowCount(); ++i) {
            if (!((Boolean)this.jTableAnalyze.getValueAt(i, 1)).booleanValue()) continue;
            String algorithmName = (String)this.jTableAnalyze.getValueAt(i, 0);
            try {
                AnalyzePlugin plugin = (AnalyzePlugin)loader.loadClass(algorithmName).newInstance();
                result.add(plugin.analyze(this.nuclei, this.skiz));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            variableName.add(algorithmName);
        }
        String[] strResult = new String[this.markersObject.size() + 1];
        strResult[0] = "";
        for (int j = 0; j < variableName.size(); ++j) {
            strResult[0] = strResult[0] + (String)variableName.get(j) + ",";
        }
        for (int i = 1; i < strResult.length; ++i) {
            strResult[i] = "";
            for (int j = 0; j < result.size(); ++j) {
                int n = i;
                strResult[n] = strResult[n] + ((ArrayList)result.get(j)).get(i - 1) + ",";
            }
        }
        this.textFileIO.resetChoosableFileFilters();
        this.textFileIO.writeStrings(strResult);
        this.jDialogAnalyze.setVisible(false);
    }

    private void jButtonCancelResultActionPerformed(ActionEvent evt) {
        this.jDialogAnalyze.setVisible(false);
    }

    private void jMenuSaveDataActionPerformed(ActionEvent evt) {
        this.jDialogAnalyze.setVisible(true);
    }

    private void jSliderFrameStateChanged(ChangeEvent evt) {
        if (!this.jDialogAnimation.isVisible()) {
            return;
        }
        int distFrame = this.jSliderFrame.getValue();
        int currentFrame = this.stepArray[this.orderArray[this.currentOrder]];
        Graphics g = this.jImageAnimation.getOffGraphics();
        if (currentFrame < distFrame) {
            while (this.stepArray[this.orderArray[this.currentOrder]] < distFrame) {
                int pn = this.orderArray[this.currentOrder];
                if (this.imiAnalyze.getPixelsLabel(pn) > BACKGROUND) {
                    g.setColor(this.jCanvasColorObj.getColor());
                } else {
                    g.setColor(this.jCanvasColorBack.getColor());
                }
                int x = pn % this.imgBackground.getWidth();
                int y = pn / this.imgBackground.getWidth();
                g.drawLine(x, y, x, y);
                ++this.currentOrder;
            }
        } else {
            g.setColor(Color.black);
            while (distFrame < this.stepArray[this.orderArray[this.currentOrder]]) {
                int pn = this.orderArray[this.currentOrder];
                int x = pn % this.imgBackground.getWidth();
                int y = pn / this.imgBackground.getWidth();
                g.drawLine(x, y, x, y);
                --this.currentOrder;
            }
        }
        this.jImageAnimation.repaint();
        this.jLabelFrame.setText(Integer.toString(distFrame));
    }

    private void jToggleImageActionPerformed(ActionEvent evt) {
    }

    private void jButtonAnimationActionPerformed(ActionEvent evt) {
        this.jImageAnimation.setPreferredSize(new Dimension(this.imgBackground.getWidth(), this.imgBackground.getHeight()));
        this.jDialogAnimation.pack();
        this.jDialogAnimation.setVisible(true);
        this.jImageAnimation.setFullSrc();
        this.jImageAnimation.drawImage();
        this.jImageAnimation.repaint();
    }

    private void jCanvasColorBackMousePressed(MouseEvent evt) {
        this.drawMarkers();
        this.updateFullCanvas();
        cursorBackground = this.createCursor(this.jCanvasColorBack.getColor());
        if (this.jToggleMarker.isSelected() && !this.isObjectActive) {
            this.jImageMain.setCursor(cursorBackground);
        }
    }

    private void jCanvasColorObjMousePressed(MouseEvent evt) {
        this.drawMarkers();
        this.updateFullCanvas();
        cursorObject = this.createCursor(this.jCanvasColorObj.getColor());
        if (this.jToggleMarker.isSelected() && this.isObjectActive) {
            this.jImageMain.setCursor(cursorObject);
        }
    }

    private void jMenuOpenMarkersActionPerformed(ActionEvent evt) {
        Point p;
        int y;
        int x;
        int i;
        ArrayList<String> data = this.textFileIO.readStrings();
        if (data == null) {
            return;
        }
        this.markersObject.clear();
        String line = data.get(0);
        String[] location = line.split(",");
        int width = Integer.valueOf(location[0]);
        int height = Integer.valueOf(location[1]);
        int nObject = Integer.valueOf(data.get(1));
        int size = (Integer)this.jSpinnerMarkerSize.getValue();
        for (i = 2; i < nObject; ++i) {
            line = data.get(i);
            location = line.split(",");
            x = Integer.valueOf(location[0]) * this.imgBackground.getWidth() / width;
            y = Integer.valueOf(location[1]) * this.imgBackground.getHeight() / height;
            p = new Point(x, y);
            this.markersObject.add(p);
        }
        for (i = nObject; i < data.size(); ++i) {
            line = data.get(i);
            location = line.split(",");
            x = Integer.valueOf(location[0]) * this.imgBackground.getWidth() / width;
            y = Integer.valueOf(location[1]) * this.imgBackground.getHeight() / height;
            p = new Point(x, y);
            this.markersBackground.add(p);
        }
        this.jRadioCluster.setEnabled(false);
        this.imiAnalyze = new ImageInfo(this.imgBackground);
        this.drawMarkers();
        this.updateFullCanvas();
        this.updateMarkerNumber();
        this.checkReadyToAnalyze();
    }

    private void jMenuSaveMarkersActionPerformed(ActionEvent evt) {
        String arg;
        ArrayList<String> data = new ArrayList<String>();
        data.add(this.imgBackground.getWidth() + "," + this.imgBackground.getHeight());
        data.add(Integer.toString(this.markersObject.size() + 2));
        for (Point p : this.markersObject) {
            arg = p.x + "," + p.y;
            data.add(arg);
        }
        for (Point p : this.markersBackground) {
            arg = p.x + "," + p.y;
            data.add(arg);
        }
        this.textFileIO.resetChoosableFileFilters();
        this.textFileIO.writeStrings(data);
    }

    private void jButtonCancelMarkerActionPerformed(ActionEvent evt) {
        this.jDialogMarker.setVisible(false);
    }

    private void jSliderAlphaStateChanged(ChangeEvent evt) {
        this.updateResultImage();
    }

    private void jImageMainMouseReleased(MouseEvent evt) {
        if (this.selectionRect != null) {
            this.addToSelectedMarkers(this.markersObject);
            this.addToSelectedMarkers(this.markersBackground);
            this.selectionRect = null;
            this.readyToDrawSelectMarkers();
            this.drawMarkers();
            this.repaintDirtyRegion();
        }
    }

    private void jImageMainMouseClicked(MouseEvent evt) {
        if (this.jToggleImage.isSelected()) {
            this.jImageMain.mouseClicked(evt);
            this.jImageMain.clearCanvas();
            this.jImageMain.drawImage();
            this.drawMarkers();
            this.updateFullCanvas();
            return;
        }
        Point2D p2D = this.jImageMain.getImageTransform().inverseTransform(evt.getPoint());
        if (this.focusedMarker == null) {
            Point p = new Point((int)p2D.getX(), (int)p2D.getY());
            if (this.jToggleMarker.isSelected()) {
                if (this.isObjectActive) {
                    this.markersObject.add(p);
                } else {
                    this.markersBackground.add(p);
                }
                if (!this.jMenuSaveMarkers.isEnabled()) {
                    this.jMenuSaveMarkers.setEnabled(true);
                }
            }
            this.drawMarkers();
            this.pointRect.setLocation(p.x, p.y);
            this.updatePartialCanvas(this.pointRect.getBounds());
            this.checkReadyToAnalyze();
            this.updateMarkerNumber();
        } else {
            this.selectedMarkers.add(this.focusedMarker);
            this.drawMarkers();
            this.pointRect.setLocation(this.focusedMarker.x, this.focusedMarker.y);
            this.updatePartialCanvas(this.pointRect.getBounds());
        }
    }

    private void jButtonAnalyzeActionPerformed(ActionEvent evt) {
        int pn;
        this.imgOverlap = new BufferedImage(this.imgBackground.getWidth(), this.imgBackground.getHeight(), 1);
        this.jImageMain.drawImage();
        if (this.jCheckMask.isSelected()) {
            this.removeMaskedMarkers(this.markersObject);
            this.removeMaskedMarkers(this.markersBackground);
        }
        Watershed watershed = new Watershed(this.imiAnalyze, BACKGROUND);
        int INIT = watershed.getIndexInitial();
        Arrays.fill(this.imiAnalyze.getPixelsLabel(), INIT);
        int count = BACKGROUND + 1;
        for (Point p : this.markersObject) {
            this.imiAnalyze.setPixelsLabel(this.pointToOffset(p), count);
            ++count;
        }
        for (Point p : this.markersBackground) {
            this.imiAnalyze.setPixelsLabel(this.pointToOffset(p), BACKGROUND);
        }
        Morphology mo = new Morphology(this.imiAnalyze.getNeighborFrame());
        watershed.setOrder(this.gradient);
        FirstInFirstOut fifo = watershed.getFIFO();
        this.stepArray = new int[this.imiAnalyze.getImageSize()];
        this.orderArray = new int[this.imiAnalyze.getImageSize()];
        Arrays.fill(this.stepArray, -1);
        Arrays.fill(this.orderArray, -1);
        int step = 0;
        this.currentOrder = -1;
        do {
            watershed.setFIFOMarker();
            count = watershed.flood4();
            if (0 >= count) continue;
            fifo.rewindToMarker();
            int size = fifo.getSize();
            for (int i = 0; i < size; ++i) {
                pn = fifo.get();
                if (this.stepArray[pn] != -1) continue;
                this.stepArray[pn] = step;
                ++this.currentOrder;
                this.orderArray[this.currentOrder] = pn;
            }
            ++step;
        } while (!watershed.isConvergence());
        watershed.undeterminedToWatershed();
        this.contourRegion = watershed.getWatershed();
        this.convertMaskToWatershed(watershed.getIndexWatershed());
        this.nuclei = this.makeROI();
        this.makeResultImage();
        boolean[] backgroundMap = new boolean[this.imiAnalyze.getImageSize()];
        for (pn = 0; pn < this.imiAnalyze.getImageSize(); ++pn) {
            if (this.imiAnalyze.getPixelsLabel(pn) > BACKGROUND) {
                backgroundMap[pn] = false;
                continue;
            }
            this.imiAnalyze.setPixelsLabel(pn, INIT);
            backgroundMap[pn] = true;
        }
        watershed = new Watershed(this.imiAnalyze, BACKGROUND + 1);
        int[] dist = mo.geodesicDistance4(backgroundMap);
        watershed.setOrder(dist);
        do {
            watershed.flood4();
        } while (!watershed.isConvergence());
        watershed.undeterminedToWatershed();
        this.contourSkiz = this.jCheckMask.isSelected() ? this.deleteMaskedContour(watershed.getWatershed()) : watershed.getWatershed();
        this.convertMaskToWatershed(watershed.getIndexWatershed());
        this.skiz = this.makeROI();
        this.setNearestNeighbor(dist);
        this.jImageAnimation.setImage(this.imgResult);
        this.jSliderAlpha.setEnabled(true);
        this.updateResultImage();
        this.jSliderFrame.setMaximum(step - 1);
        this.jSliderFrame.setValue(step - 1);
        this.jButtonAnimation.setEnabled(true);
        this.jMenuResult.setEnabled(true);
    }

    private void jImageMainMouseDragged(MouseEvent evt) {
        if (this.jToggleImage.isSelected()) {
            this.jImageMain.mouseDragged(evt);
            this.jImageMain.clearCanvas();
            this.jImageMain.drawImage();
            this.drawMarkers();
            this.updateFullCanvas();
            return;
        }
        Point2D p = this.jImageMain.getImageTransform().inverseTransform(evt.getPoint());
        if (this.focusedMarker == null) {
            if (this.selectionRect == null) {
                this.selectionRect = new Rectangle((int)p.getX(), (int)p.getY(), 1, 1);
            } else {
                this.selectionRect.setLocation(this.dragStartPoint);
                this.selectionRect.setSize(1, 1);
                this.selectionRect.add(p);
            }
            this.drawMarkers();
            this.updatePartialCanvas(this.selectionRect);
        } else {
            this.focusedMarker.setLocation((int)p.getX(), (int)p.getY());
            this.drawMarkers();
            this.pointRect.setLocation(this.focusedMarker.x, this.focusedMarker.y);
            this.updatePartialCanvas(this.pointRect.getBounds());
        }
        this.jLabelInfo.setText("mouse(x,y)=" + evt.getX() + "," + evt.getY());
        this.jLabelInfo.setText("mouse(x,y)=" + (int)p.getX() + "," + (int)p.getY());
    }

    private void jImageMainMousePressed(MouseEvent evt) {
        if (this.jToggleImage.isSelected()) {
            this.jImageMain.mousePressed(evt);
            return;
        }
        if (evt.getModifiers() != 4) {
            this.checkSelectionType(evt.getModifiers());
            this.selectionRect = null;
            Point2D p = this.jImageMain.getImageTransform().inverseTransform(evt.getPoint());
            this.dragStartPoint.setLocation(p);
        }
    }

    private void jSpinnerMarkerSizeStateChanged(ChangeEvent evt) {
        int value = (Integer)this.jSpinnerMarkerSize.getValue();
        this.pointRect.setSize(value);
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jImageMainMouseMoved(MouseEvent evt) {
        if (!this.jToggleImage.isSelected()) {
            this.findFocusedMarker(evt.getPoint());
        }
        this.jLabelInfo.setText("mouse(x,y)=" + evt.getX() + "," + evt.getY());
    }

    private void jToggleBackgroundActionPerformed(ActionEvent evt) {
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jToggleObjectActionPerformed(ActionEvent evt) {
        this.drawMarkers();
        this.updateFullCanvas();
    }

    private void jRadioClusterItemStateChanged(ItemEvent evt) {
        if (this.jRadioCluster.isSelected() && this.fileCluster != null) {
            BufferedImage img = SOSImageIO.readImage(this.fileCluster);
            this.drawImageToImgBackground(img);
        }
    }

    private void jRadioOriginalItemStateChanged(ItemEvent evt) {
        if (this.jRadioOriginal.isSelected() && this.fileOriginal != null) {
            BufferedImage img = SOSImageIO.readImage(this.fileOriginal);
            this.drawImageToImgBackground(img);
        }
    }

    private void jButtonSetMarkerActionPerformed(ActionEvent evt) {
        int nChecked = this.imageColorPickerMarker.getCheckedNumber();
        if (nChecked == 0 || nChecked == this.imageColorPickerMarker.getColorNumber()) {
            this.jLabelInfo.setText("Invalid selections for seed");
            return;
        }
        this.jDialogMarker.setVisible(false);
    }

    private void jButtonAssignColorsToMarkersActionPerformed(ActionEvent evt) {
        this.jDialogMarker.setVisible(true);
    }

    private void jButtonSetClusterActionPerformed(ActionEvent evt) {
        this.imageFileIO.resetChoosableFileFilters();
        this.imageFileIO.setFileFilter(filterGifPng);
        this.fileCluster = this.imageFileIO.getOpenFile("Select a file for cluster image...");
        if (this.fileCluster == null) {
            return;
        }
        Dimension size = SOSImageIO.getImageSize(this.fileCluster);
        if (!this.checkBackgroundImageSize(size)) {
            return;
        }
        ImageInfo imiCluster = new ImageInfo(SOSImageIO.readImage(this.fileCluster));
        int[] colorCluster = imiCluster.getPixelsLabel();
        this.imageColorPickerMarker.setColorTable(imiCluster.getPixels(), imiCluster.getPixelsLabel());
        this.jDialogMarker.setVisible(true);
        boolean[] flag = this.imageColorPickerMarker.getFlag();
        this.setMarkers(flag, colorCluster);
        this.jRadioCluster.setEnabled(true);
        this.jButtonAssignColorsToMarkers.setEnabled(true);
    }

    private void jButtonSetOriginalActionPerformed(ActionEvent evt) {
        this.initializeAnalysis();
        this.imageFileIO.resetChoosableFileFilters();
        this.imageFileIO.setFileFilter(filterImg);
        this.fileOriginal = this.imageFileIO.getOpenFile("Select the original image...");
        if (this.fileOriginal == null) {
            return;
        }
        Dimension size = SOSImageIO.getImageSize(this.fileOriginal);
        if (!this.checkBackgroundImageSize(size)) {
            this.imgBackground = new BufferedImage(size.width, size.height, 1);
            this.jImageMain.setSize(size.width, size.height);
            this.pack();
        }
        if (this.jRadioOriginal.isSelected()) {
            BufferedImage img = SOSImageIO.readImage(this.fileOriginal);
            this.drawImageToImgBackground(img);
        } else {
            this.jRadioOriginal.setSelected(true);
        }
        this.imiAnalyze = new ImageInfo(this.imgBackground);
        Morphology mo = new Morphology(this.imiAnalyze.getNeighborFrame());
        double[][] LAB = new double[this.imiAnalyze.getImageSize()][3];
        ColorVector.getLAB(this.imiAnalyze.getPixels(), LAB);
        this.gradient = mo.calcSobel(LAB);
        this.jMenuFile.setEnabled(true);
        this.jRadioGradient.setEnabled(true);
        this.jButtonSetCluster.setEnabled(true);
        this.setTitle("Gunmetry Ver2.0 (" + this.fileOriginal.getName() + ")");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new GunmetryViewer().setVisible(true);
            }
        });
    }

    static {
        BACKGROUND = 0;
        String[] exts = ImageIO.getReaderFormatNames();
        String description = "Image Files (ImageI/O readable)";
        filterImg = new ExtensionFilter(exts, description);
        filterGifPng = new ExtensionFilter(new String[]{"gif", "png"}, "GIF or PNG");
    }
}

