
/*
 * NuclearSize.java
 *
 * Created on 2005/03/07, 1:25
 */

import gunmetry.AnalyzePlugin;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import sos.process.ROI;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/03/07)
 */
public class RegionDistance implements AnalyzePlugin{
	
	private ArrayList<Double> result = null;

	public ArrayList<Double> analyze(ROI[] nuclei, ROI[] skiz) {
		if (result==null){
			result = new ArrayList<Double>();
			double value = 0.0;
			for (int i=0; i<nuclei.length; i++){
				Point2D.Double obj = nuclei[i].getCentroid();
				Point2D.Double neighbor = nuclei[i].getNearestNeighbor().getCentroid();
				value = Math.sqrt((obj.x-neighbor.x)*(obj.x-neighbor.x)+(obj.y-neighbor.y)*(obj.y-neighbor.y));
				result.add(value);
			}
		}
		return result;
	}
	
}
