/*
 * JPanelColor.java
 *
 * Created on 2005/02/20, 3:09
 */

package gunmetry;

import java.awt.Color;
import java.awt.Dimension;
import java.util.HashSet;
import javax.swing.JComponent;

/**
 *
 * @author  pathologist
 */
public class JColorView extends javax.swing.JPanel {
	private HashSet<JComponent> listeners = new HashSet<JComponent>();
	private boolean colorChoosable;
	private int[] RGB = new int[3];
	
	/** Creates new form JPanelColor */
	public JColorView() {
		initComponents();
		colorChoosable = true;
	}
	
	public void addColorChangeListener(JComponent comp){
		listeners.add(comp);
	}
	
	public void setColor(Color color){
		RGB[0] = color.getRed();
		RGB[1] = color.getGreen();
		RGB[2] = color.getBlue();
		String str = "("+color.getRed()+","+color.getGreen()+","+color.getBlue()+")";
		jLabelColorStr.setText(str);
		jLabelColorPreview.setBackground(color);
		
		for (JComponent comp: listeners){
			comp.setForeground(color);
		}
	}
	
	public void setColor(int[] color){
		setColor(new Color(color[0],color[1],color[2]));
	}
	
	public Color getColor(){
		return jLabelColorPreview.getBackground();
	}
	
	public int getColorInt(){
		return getColor().getRGB();
	}
	
	public int[] getColorArray(){
		return RGB;
	}
	
	public void setColorChoosable(boolean value){
		colorChoosable = value;
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        jColorChooser = new javax.swing.JColorChooser();
        jLabel1 = new javax.swing.JLabel();
        jLabelColorPreview = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabelColorStr = new javax.swing.JLabel();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.X_AXIS));

        jLabel1.setText(" ");
        add(jLabel1);

        jLabelColorPreview.setBorder(new javax.swing.border.EtchedBorder());
        jLabelColorPreview.setMaximumSize(new java.awt.Dimension(15, 15));
        jLabelColorPreview.setMinimumSize(new java.awt.Dimension(15, 15));
        jLabelColorPreview.setOpaque(true);
        jLabelColorPreview.setPreferredSize(new java.awt.Dimension(15, 15));
        jLabelColorPreview.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jLabelColorPreviewMousePressed(evt);
            }
        });

        add(jLabelColorPreview);

        jLabel2.setText(" ");
        add(jLabel2);

        jLabelColorStr.setText("( , , )");
        add(jLabelColorStr);

    }//GEN-END:initComponents
	
	private void jLabelColorPreviewMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabelColorPreviewMousePressed
		Color newColor = jColorChooser.showDialog(this,"Choose color...",getColor());
		setColor(newColor);
	}//GEN-LAST:event_jLabelColorPreviewMousePressed
	
	
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JColorChooser jColorChooser;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabelColorPreview;
    private javax.swing.JLabel jLabelColorStr;
    // ϐ錾̏I//GEN-END:variables
	
}
