/*
 * basicMatching.java
 *
 * Created on 2005/01/31, 0:54
 */

package orch.plugin;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import orch.ImagePiece;
import orch.SearchPoint;
import sos.util.SortDouble;
import orch.Matching;

/**
 * This plugin use so-called Coarse to Fine algorithm.
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/02/15)
 */
public class CoarseFineMatching extends Matching{
	
	/**
	 * 
	 * @param ipUnmove 
	 * @param ipMove 
	 * @param isHorizontal 
	 * @return 
	 */
	protected Rectangle getSearchBounds(ImagePiece ipUnmove, ImagePiece ipMove, boolean isHorizontal){
		boolean reverseUnion = (ipUnmove.getIndex()<ipMove.getIndex())?false:true;
		
		Rectangle rect = ipUnmove.getBounds();
		Rectangle result = new Rectangle();
		
		Dimension size = new Dimension();
		size.width = (int)(rect.width*horizontalOverlapRatio);
		size.height = (int)(rect.height*verticalOverlapRatio);
		Dimension minSize = new Dimension();
		minSize.width = (int)(rect.width*minOverlapRatio);
		minSize.height = (int)(rect.height*minOverlapRatio);
		if (isHorizontal){
			if (reverseUnion){
				result.setLocation(rect.x-rect.width+minSize.width, rect.y-size.height);
			}else{
				result.setLocation(rect.x+rect.width-size.width, rect.y-size.height);
			}
			result.setSize(size.width-minSize.width, size.height*2);
		}else{
			if (reverseUnion){
				result.setLocation(rect.x-size.width, rect.y-rect.height+minSize.height);
			}else{
				result.setLocation(rect.x-size.width, rect.y+rect.height-size.height);
			}
			result.setSize(size.width*2, size.height-minSize.height);
		}
		
		return result;
	}
	
	/**
	 * 
	 * @param ipUnmove 
	 * @param ipMove 
	 * @param ipSub 
	 * @param isHorizontal 
	 */
	protected void matchThreeImage(ImagePiece ipUnmove, ImagePiece ipMove, ImagePiece ipSub, boolean isHorizontal){
		
		int step = ipMove.getThumbnailOriginalRatio();
		SearchPoint[][] points = getSearchPoints(ipUnmove.getBounds(),ipMove.getBounds(), ipSub.getBounds(), step);
		SearchPoint[] pointsMain = points[0];
		SearchPoint[] pointsSub = points[1];
		double[] fitnesses;
		double currentFitness = 0.0;
		do{
			fitnesses = new double[pointsMain.length];
			for (int i=0; i<fitnesses.length; i++){
				if (!pauseFlag){
					currentFitness = calcFitness(ipUnmove, ipMove, pointsMain[i], step);
					double ratioPre = 1.0*pointsMain[i].getRectSize()/(pointsMain[i].getRectSize()+pointsSub[i].getRectSize());
					fitnesses[i] = ratioPre*currentFitness+(1-ratioPre)*calcFitness(ipSub, ipMove, pointsSub[i],step);
				}else{
					break;
				}
			}
			
			SortDouble sd = new SortDouble(fitnesses);
			matchedBounds.setLocation(pointsMain[sd.getOrder(0)].getLocation());
			drawRects(ipUnmove,ipMove,ipSub, pointsMain[sd.getOrder(0)],pointsSub[sd.getOrder(0)]);
			
			step /= 2;
			pointsMain = sortSearchPoints(sd,pointsMain,step);
			pointsSub = sortSearchPoints(sd,pointsSub,step);
			ipUnmove.clearRGB();
			ipMove.clearRGB();
		}while(0<step && !pauseFlag);
		
	}
	
	/**
	 * 
	 * @param ipUnmove 
	 * @param ipMove 
	 * @param isHorizontal 
	 */
	protected void matchTwoImage(ImagePiece ipUnmove, ImagePiece ipMove, boolean isHorizontal){
		
		int step = ipMove.getThumbnailOriginalRatio();
		SearchPoint[] pointsMain = getSearchPoints(ipUnmove.getBounds(),ipMove.getBounds(),step);
		double[] fitnesses;
		do{
			fitnesses = new double[pointsMain.length];
			for (int i=0; i<fitnesses.length; i++){
				fitnesses[i] = calcFitness(ipUnmove,ipMove, pointsMain[i],step);
			}
			
			SortDouble sd = new SortDouble(fitnesses);
			System.out.println(matchedBounds);
			matchedBounds.setLocation(pointsMain[sd.getOrder(0)].getLocation());
			drawRects(ipUnmove,ipMove,null,pointsMain[sd.getOrder(0)],null);
			
			step /= 2;
			pointsMain = sortSearchPoints(sd,pointsMain,step);
			ipUnmove.clearRGB();
			ipMove.clearRGB();
		}while(0<step && !pauseFlag);
				
	}
	
	private SearchPoint[] getSearchPoints(Rectangle rect1, Rectangle rect2, int step){
		ArrayList<SearchPoint> tempList = new ArrayList<SearchPoint>(searchBounds.width*searchBounds.height/(step*step));
		for (int y=searchBounds.y; y<searchBounds.y+searchBounds.height; y+=step){
			for (int x=searchBounds.x; x<searchBounds.x+searchBounds.width; x+=step){
				rect2.setLocation(x,y);
				Rectangle intersectRect = (Rectangle)rect1.intersection(rect2);
				if (0<intersectRect.width*intersectRect.height){
					SearchPoint searchPoint = new SearchPoint(x,y);
					searchPoint.setIntersectRect(intersectRect);
					tempList.add(searchPoint);
				}
			}
		}
		tempList.toArray();
		SearchPoint[] result = new SearchPoint[tempList.size()];
		for (int i=0; i<result.length; i++){
			result[i] = tempList.get(i);
		}
		
		return result;
	}
	
	private SearchPoint[][] getSearchPoints(Rectangle rect1, Rectangle rect2, Rectangle rect3, int step){
		SearchPoint[] tempList1 = new SearchPoint[searchBounds.width*searchBounds.height/(step*step)];
		SearchPoint[] tempList2 = new SearchPoint[searchBounds.width*searchBounds.height/(step*step)];
		
		int count = 0;
		for (int y=searchBounds.y; y<searchBounds.y+searchBounds.height; y+=step){
			for (int x=searchBounds.x; x<searchBounds.x+searchBounds.width; x+=step){
				rect2.setLocation(x,y);
				Rectangle intersectRect1 = (Rectangle)rect1.intersection(rect2);
				rect2.setLocation(x,y);
				Rectangle intersectRect2 = (Rectangle)rect3.intersection(rect2);
				if (0<intersectRect1.width*intersectRect1.height*intersectRect2.width*intersectRect2.height){
					SearchPoint searchPoint1 = new SearchPoint(x,y);
					searchPoint1.setIntersectRect(intersectRect1);
					
					SearchPoint searchPoint2 = new SearchPoint(searchPoint1.getLocation());
					searchPoint2.setIntersectRect(intersectRect2);
					
					tempList1[count] = searchPoint1;
					tempList2[count] = searchPoint2;
					count ++;
				}
			}
		}
		SearchPoint[][] result = new SearchPoint[2][count];
		for (int i=0; i<count; i++){
			result[0][i] = tempList1[i];
			result[1][i] = tempList2[i];
		}
		
		return result;
	}
	
	private SearchPoint[] sortSearchPoints(SortDouble sd, SearchPoint[] points, int step){
		int newN;
		if (step==1){
			newN = 1;
		}else{
			newN = points.length/16;
		}
		SearchPoint[] result = new SearchPoint[newN*4];
		for (int i=0; i<newN; i++){
			int index = sd.getOrder(i);
			result[i] = points[index];
		}
		
		int offset = newN;
		for (int i=0; i<newN; i++){
			Point loc = result[i].getLocation();
			result[i+offset] = new SearchPoint(loc.x+step,loc.y);
		}
		offset = newN*2;
		for (int i=0; i<newN; i++){
			Point loc = result[i].getLocation();
			result[i+offset] = new SearchPoint(loc.x,loc.y+step);
		}
		offset = newN*3;
		for (int i=0; i<newN; i++){
			Point loc = result[i].getLocation();
			result[i+offset] = new SearchPoint(loc.x+step,loc.y+step);
		}
		
		return result;
	}
	
	private double calcFitness(ImagePiece ipFixed, ImagePiece ipFloppy, SearchPoint searchPoint, int step){
		
		if (searchPoint.isSaturated()){
			return searchPoint.getSaturatedFitness();
		}
		
		Rectangle rectFixed = ipFixed.getBounds();
		Rectangle rectFloppy = ipFloppy.getBounds();
		int[] grayFixed = ipFixed.getPixelsData(step);
		int[] grayFloppy = ipFloppy.getPixelsData(step);
		rectFloppy.setLocation(searchPoint.getLocation());
		
		Rectangle interRect = searchPoint.getIntersectRect();
		if (interRect==null){
			interRect = rectFixed.intersection(rectFloppy);
			searchPoint.setIntersectRect(interRect);
		}
		int sum = 0;
		int count = 0;
		int offStart1 = (interRect.x-rectFixed.x)+(interRect.y-rectFixed.y)*rectFixed.width;
		int offStart2 = (interRect.x-rectFloppy.x)+(interRect.y-rectFloppy.y)*rectFloppy.width;
		int off1,off2;
		
		for (int y=interRect.y; y<interRect.y+interRect.height; y+=step){
			off1 = offStart1+(y-interRect.y)*rectFixed.width;
			off2 = offStart2+(y-interRect.y)*rectFloppy.width;
			for (int x=interRect.x; x<interRect.x+interRect.width; x+=step){
				//for (int i=0; i<3; i++){
					sum += Math.abs(grayFixed[off1]-grayFloppy[off2]);
					count++;
				//}
				off1 += step;
				off2 += step;
			}
		}
		double result = 1.0*sum/count;
		
		return result;
	}
	
}
