/*
 * Decompiled with CFR 0.152.
 */
package sos.process;

import sos.image.ImageInfo;
import sos.math.MathVector;
import sos.process.NeighborFrame;
import sos.util.FirstInFirstOut;
import sos.util.Sort;
import sos.util.SortDouble;
import sos.util.SortInteger;

public class Watershed {
    private static int indexInitial;
    private static int indexUndetermined;
    private static int indexWatershed;
    private static FirstInFirstOut fifoMain;
    private static FirstInFirstOut fifoWshed;
    private NeighborFrame neighborF = null;
    private ImageInfo imi = null;
    private int[] order = null;
    private int[] denomination = null;
    private int waterLevel;

    public Watershed(ImageInfo imi, int firstLabel) {
        this.imi = imi;
        if (fifoMain.getCapacity() < imi.getImageSize()) {
            fifoMain = new FirstInFirstOut(imi.getImageSize());
            fifoWshed = new FirstInFirstOut(imi.getImageSize());
        }
        indexInitial = firstLabel - 4;
        indexWatershed = firstLabel - 2;
        indexUndetermined = firstLabel - 1;
        this.waterLevel = 2;
        this.neighborF = imi.getNeighborFrame();
    }

    public final void setOrder(double[] gradient) {
        for (int pn = 0; pn < this.imi.getImageSize(); ++pn) {
            if (this.imi.getPixelsLabel(pn) > indexUndetermined) {
                gradient[pn] = 0.0;
                continue;
            }
            int n = pn;
            gradient[n] = gradient[n] + 1.0;
        }
        SortDouble sd = new SortDouble(gradient);
        this.setOrderAndDenomination(sd);
    }

    public final void setOrder(int[] gradient) {
        for (int pn = 0; pn < this.imi.getImageSize(); ++pn) {
            if (this.imi.getPixelsLabel(pn) > indexUndetermined) {
                gradient[pn] = 0;
                continue;
            }
            int n = pn;
            gradient[n] = gradient[n] + 1;
        }
        SortInteger si = new SortInteger(gradient);
        this.setOrderAndDenomination(si);
    }

    private final void setOrderAndDenomination(Sort so) {
        this.order = so.getOrder();
        this.denomination = so.getDistributive();
    }

    public final boolean isConvergence() {
        if (this.waterLevel + 1 < this.denomination.length) {
            ++this.waterLevel;
            return false;
        }
        return true;
    }

    public final int flood4() {
        this.neighborF.set4();
        return this.flood();
    }

    public final int flood8() {
        this.neighborF.set8();
        return this.flood();
    }

    private final int flood() {
        int[] neighbor;
        int count = 0;
        block0: for (int i = this.denomination[this.waterLevel - 1]; i < this.denomination[this.waterLevel]; ++i) {
            this.imi.setPixelsLabel(this.order[i], indexUndetermined);
            neighbor = this.neighborF.getExist(this.order[i]);
            for (int n = 0; n < neighbor.length; ++n) {
                if (this.imi.getPixelsLabel(this.order[i] + neighbor[n]) <= indexUndetermined) continue;
                fifoMain.add(this.order[i]);
                continue block0;
            }
        }
        while (!fifoMain.isEmpty()) {
            int cn;
            int n;
            int cp = fifoMain.get();
            ++count;
            if (this.imi.getPixelsLabel(cp) != indexUndetermined) continue;
            neighbor = this.neighborF.getExist(cp);
            for (n = 0; n < neighbor.length; ++n) {
                cn = cp + neighbor[n];
                if (this.imi.getPixelsLabel(cn) <= indexUndetermined) continue;
                if (this.imi.getPixelsLabel(cp) == indexUndetermined) {
                    this.imi.setPixelsLabel(cp, this.imi.getPixelsLabel(cn));
                    continue;
                }
                if (this.imi.getPixelsLabel(cp) == this.imi.getPixelsLabel(cn)) continue;
                this.imi.setPixelsLabel(cp, indexWatershed);
                fifoWshed.add(cp);
                break;
            }
            if (this.imi.getPixelsLabel(cp) <= indexUndetermined) continue;
            for (n = 0; n < neighbor.length; ++n) {
                cn = cp + neighbor[n];
                if (this.imi.getPixelsLabel(cn) != indexUndetermined) continue;
                fifoMain.add(cn);
            }
        }
        return count;
    }

    public final void undeterminedToWatershed() {
        for (int pn = 0; pn < this.neighborF.size; ++pn) {
            if (this.imi.getPixelsLabel(pn) != indexUndetermined) continue;
            this.imi.setPixelsLabel(pn, indexWatershed);
            fifoWshed.add(pn);
        }
    }

    public final void assignLabelOfClosest(int[][] input) {
        this.undeterminedToWatershed();
        do {
            int pn = fifoWshed.get();
            int[] neighbor = this.neighborF.getExist(pn);
            int[] norm = new int[neighbor.length];
            for (int n = 0; n < neighbor.length; ++n) {
                norm[n] = MathVector.norm(input[pn], input[pn + neighbor[n]]);
            }
            this.setClosestLabel(pn, neighbor, new SortInteger(norm));
        } while (!fifoWshed.isEmpty());
    }

    public final void assignLabelOfClosest(int[][] input, int[] pns) {
        for (int i = 0; i < pns.length; ++i) {
            int pn = pns[i];
            int[] neighbor = this.neighborF.getExist(pn);
            int[] norm = new int[neighbor.length];
            for (int n = 0; n < neighbor.length; ++n) {
                norm[n] = MathVector.norm(input[pn], input[pn + neighbor[n]]);
            }
            this.setClosestLabel(pn, neighbor, new SortInteger(norm));
        }
    }

    public final void assignLabelOfClosest(double[][] input) {
        this.undeterminedToWatershed();
        do {
            int pn = fifoWshed.get();
            int[] neighbor = this.neighborF.getExist(pn);
            double[] norm = new double[neighbor.length];
            for (int n = 0; n < neighbor.length; ++n) {
                norm[n] = MathVector.norm(input[pn], input[pn + neighbor[n]]);
            }
            this.setClosestLabel(pn, neighbor, new SortDouble(norm));
        } while (!fifoWshed.isEmpty());
    }

    private final void setClosestLabel(int pn, int[] neighbor, Sort so) {
        int[] order = so.getOrder();
        for (int n = 0; n < neighbor.length; ++n) {
            int cn = pn + neighbor[order[n]];
            if (this.imi.getPixelsLabel(cn) <= indexUndetermined) continue;
            this.imi.setPixelsLabel(pn, this.imi.getPixelsLabel(cn));
            return;
        }
    }

    public final int[] getWatershed() {
        return fifoWshed.toArray();
    }

    public final FirstInFirstOut getFIFO() {
        return fifoMain;
    }

    public final void setFIFOMarker() {
        fifoMain.setMarker();
    }

    public int getIndexWatershed() {
        return indexWatershed;
    }

    public int getIndexInitial() {
        return indexInitial;
    }

    static {
        fifoMain = new FirstInFirstOut(1);
        fifoWshed = new FirstInFirstOut(1);
    }
}

