/*
 * Decompiled with CFR 0.152.
 */
package gunmetry;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import sos.graphics.PointRect;
import sos.graphics.SOSGraphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Markers
extends ArrayList<Point>
implements SOSGraphics {
    private PointRect pointRect;
    private HashSet<Point> selectedMarker = new HashSet();
    private boolean visible = true;
    private Color color;

    @Override
    public void draw(Graphics g) {
        if (this.visible) {
            if (0 < this.selectedMarker.size()) {
                g.setColor(Color.white);
                for (Point p : this.selectedMarker) {
                    this.pointRect.setLocation(p.x, p.y);
                    this.pointRect.fillRect(g);
                }
            }
            if (0 < this.size()) {
                g.setColor(this.color);
                for (int i = 0; i < this.size(); ++i) {
                    Point p;
                    p = (Point)this.get(i);
                    this.pointRect.setLocation(p.x, p.y);
                    this.pointRect.drawRect(g);
                }
            }
        }
    }

    public void setAll(ArrayList<Point> points) {
        this.clear();
        this.addAll(points);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPointRect(PointRect pointRect) {
        this.pointRect = pointRect;
    }

    public Point get(Point2D point) {
        for (int i = 0; i < this.size(); ++i) {
            Point p = (Point)this.get(i);
            this.pointRect.setLocation(p.x, p.y);
            if (!this.pointRect.contains(point)) continue;
            return p;
        }
        return null;
    }

    public void add(String strPoint, double ratioX, double ratioY) {
        String[] location = strPoint.split(",");
        int x = (int)((double)Integer.valueOf(location[0]).intValue() * ratioX);
        int y = (int)((double)Integer.valueOf(location[1]).intValue() * ratioY);
        Point p = new Point(x, y);
        this.add(p);
    }

    public void select(Shape shape) {
        Rectangle rect = shape.getBounds();
        for (int i = 0; i < this.size(); ++i) {
            Point p = (Point)this.get(i);
            if (!rect.contains(p)) continue;
            this.selectedMarker.add(p);
        }
    }

    public void select(Point p) {
        int index = this.indexOf(p);
        if (-1 < index) {
            this.selectedMarker.add((Point)this.get(index));
        }
    }

    public void clearSelection() {
        this.selectedMarker.clear();
    }

    public void removeSelected() {
        this.removeAll(this.selectedMarker);
        this.clearSelection();
    }

    public void translateSelected(int dx, int dy) {
        for (Point p : this.selectedMarker) {
            p.translate(dx, dy);
        }
    }
}

