/*
 * FocusedMarker.java
 *
 * Created on 2005/06/05, 12:34
 *
 */
package gunmetry;

import java.awt.Point;
import java.awt.geom.Point2D;
/**
 *
 * @author Scientific Open Source Project (Gaku Tanaka)
 */
public class FocusedMarker {
	private Markers markersObject;
	private Markers markersBackground;
	
	private Point point = null;
	private boolean isObjectMarker;
	
	/** Creates a new instance of FocusedMarker */
	public FocusedMarker(Markers object, Markers background) {
		markersObject = object;
		markersBackground = background;
	}
	
	/**
	 *
	 * @return
	 */
	public Point get() {
		return point;
	}
	
	/**
	 * Find Point under mouse point and set it as the current focused marker.
	 * To change the location of focused marker, use setLocation.
	 * @param point new Point instance as the focused marker
	 */
	public void set(Point2D mousePoint2D) {
		point = markersObject.get(mousePoint2D);
		if (isActive()){
			isObjectMarker = true;
		}else{
			point = markersBackground.get(mousePoint2D);
			isObjectMarker = false;
		}
	}
	
	/**
	 * Check if focusedMarker has a Point instance.
	 * If it has, it will be refered as "active".
	 * @return true - active
	 * flase - NOT active
	 */
	public boolean isActive(){
		return (point!=null);
	}
	
	/**
	 *
	 * @param p
	 * @return
	 */
	public boolean equals(Point p){
		if (point==null){
			if (p==null){
				return true;
			}else{
				return false;
			}
		}
		return point.equals(p);
	}
	
	/**
	 * Set the location of Point of focused marker.
	 * @param x
	 * @param y
	 * @return true Successfully set the location.
	 * false Point was null.
	 */
	public boolean setLocation(int x, int y){
		if (point!=null){
			point.setLocation(x,y);
			return true;
		}
		
		return false;
	}
	
	public void addToMarkers(){
		if (isObjectMarker){
			markersObject.add(point);
		}else{
			markersBackground.add(point);
		}
	}
	
	public void removeFromMarkers(){
		if (isObjectMarker){
			markersObject.remove(point);
		}else{
			markersBackground.remove(point);
		}
	}
}
