/*
 * Region.java
 *
 * Created on 2005/03/06, 20:04
 */

package gunmetry.region;

import java.awt.Rectangle;
import java.awt.geom.Point2D;

/**
 * This class represents the region which result from watershed with the object marker.
 * Each region correspond to the marker.
 * @author Scientific Open Source projects (Gaku Tanaka)
 */
public class Region {
	private int size;
	private Rectangle bounds;
	private boolean[] mask;
	
	private int minDistance;
	private Region nearestNeighbor;
	
	/** Creates a new instance of Region */
	public Region() {
	}
	
	/**
	 * 
	 * @param x 
	 * @param y 
	 */
	public void expandRegion(int x, int y){
		if (bounds==null){
			bounds = new Rectangle(x,y,1,1);
		}else{
			bounds.add(x,y);
		}
	}
	
	/**
	 * 
	 * @return 
	 */
	public Rectangle getBounds(){
		return bounds;
	}
	
	public void initMask(){
		mask = new boolean[bounds.width*bounds.height];
		size = 0;
	}
	
	/**
	 * set mask of bounds.
	 * @param x relative x to the bounds.x
	 * @param y relative y to the bounds.y
	 */
	public void setMask(int x, int y){
		int index = x+y*bounds.width;
		mask[index] = true;
		size++;
	}
	
	/**
	 * 
	 * @return width of the bounding rectangle.
	 */
	public int getWidth(){
		return bounds.width;
	}
	
	/**
	 * 
	 * @return height of the bounding rectangle.
	 */
	public int getHeight(){
		return bounds.height;
	}
	
	/**
	 * 
	 * @return 
	 */
	public Point2D.Double getCentroid(){
		int cumX,cumY;
		if (bounds!=null){
			cumX = bounds.x*size;
			cumY = bounds.y*size;
			int offset;
			for (int y=0; y<bounds.height; y++){
				offset = y*bounds.width;
				for (int x=0; x<bounds.width; x++){
					if (mask[offset+x]){
						cumX += x;
						cumY += y;
					}
				}
			}
		}else{
			return null;
		}
		
		return new Point2D.Double(1.0*cumX/size, 1.0*cumY/size);
	}

	/**
	 * 
	 * @return 
	 */
	public int getMinDistance() {
		return minDistance;
	}

	/**
	 * 
	 * @param minDistance 
	 */
	public void setMinDistance(int minDistance) {
		this.minDistance = minDistance;
	}

	/**
	 * 
	 * @return 
	 */
	public Region getNearestNeighbor() {
		return nearestNeighbor;
	}

	public void setNearestNeighbor(Region nearestNeighbor) {
		this.nearestNeighbor = nearestNeighbor;
	}
	
	/**
	 * 
	 * @param index 
	 * @return 
	 */
	public boolean getMask(int index){
		return mask[index];
	}
	
	/**
	 * 
	 * @return 
	 */
	public int getSize(){
		return size;
	}
}
