/*
 * RegionSet.java
 *
 * Created on 2005/06/05, 16:49
 *
 */

package gunmetry.region;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sos.image.ImageInfo;
import gunmetry.*;

/**
 *
 * @author Scientific Open Source Project (Gaku Tanaka)
 */
public class RegionSet {
	private Region[] regions;
	private int [] contour;
	
	private Color colorCentroid;
	private Color colorContour;
	private Color colorLine;
	
	private boolean drawCentroid;
	private boolean drawContour;
	private boolean drawLine;
	
	/** Creates a new instance of RegionSet */
	public RegionSet() {
	}
	
	public int size(){
		return regions.length;
	}
	
	public Point2D getCentroid(int index){
		return regions[index].getCentroid();
	}
	
	public void initMinDistance(){
		for (int i=0; i<regions.length; i++){
			regions[i].setMinDistance(Integer.MAX_VALUE);
		}		
	}
	
	public int getMinDistance(int index){
		return regions[index].getMinDistance();
	}
	
	public void setMinDistance(int index, int value){
		regions[index].setMinDistance(value); 
	}
	
	public Region getNearestNeighbor(int index){
		return regions[index].getNearestNeighbor();
	}	
	
	public void setNearestNeighbor(int index, Region neighbor){
		regions[index].setNearestNeighbor(neighbor);
	}
	
	public Region getRegion(int index){
		return regions[index];
	}
	
	public Region[] getRegion(){
		return regions;
	}
	
	public void setRegion(Markers markers, ImageInfo imi, int backgroundIndex){
		regions = new Region[markers.size()];
		for (int n=0; n<regions.length; n++){
			regions[n] = new Region();
		}
		int count = 0;
		for (int i=0; i<regions.length; i++){
			Point p = markers.get(i);
			regions[count].expandRegion(p.x, p.y);
			count++;
		}
		
		// make the region with adding points
		int offset,pn, index;
		int FIRST_LABEL = backgroundIndex+1;
		for (int y=0; y<imi.getHeight(); y++){
			offset = y*imi.getWidth();
			for (int x=0; x<imi.getWidth(); x++){
				pn = x+offset;
				index = imi.getPixelsLabel(pn)-FIRST_LABEL;
				if (0<=index){
					regions[index].expandRegion(x,y);
				}
			}
		}
		
		// set mask within the region
		for (int n=0; n<regions.length; n++){
			regions[n].initMask();
			Rectangle bounds = regions[n].getBounds();
			for (int y=0; y<bounds.height; y++){
				offset = (y+bounds.y)*imi.getWidth();
				for (int x=0; x<bounds.width; x++){
					pn = x+bounds.x+offset;
					if (imi.getPixelsLabel(pn)-FIRST_LABEL==n){
						regions[n].setMask(x,y);
					}
				}
			}
		}	
	}

	public int[] getContour() {
		return contour;
	}

	public void setContour(int[] contour) {
		this.contour = contour;
	}
	
}
