/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.colorspace;

import jp.sourceforge.sos.lib.colorspace.CIEXYZ;
import jp.sourceforge.sos.lib.colorspace.SOSColorSpace;

public class CIELab
extends SOSColorSpace {
    private static final String NAME = "CIE L*a*b";
    private static final double CO = 0.13793103396892548;
    private static final double[] CUBE_ROOT = new double[10891];
    private static CIEXYZ xyz = new CIEXYZ();

    static {
        double A_THIRD = 0.3333333333333333;
        int i = 0;
        while (i < CUBE_ROOT.length) {
            CIELab.CUBE_ROOT[i] = Math.pow((double)i / 10000.0, A_THIRD);
            ++i;
        }
    }

    public String toString() {
        return NAME;
    }

    public double[] fromRGB(int[] rgb) {
        double[] xyzValue = xyz.fromRGB(rgb);
        double[] result = new double[3];
        double yyn = this.fLAB(xyzValue[1]);
        result[0] = 116.0 * yyn - 16.0;
        result[1] = 500.0 * (this.fLAB(xyzValue[0]) - yyn);
        result[2] = 200.0 * (yyn - this.fLAB(xyzValue[2]));
        return result;
    }

    public int[] toRGB(double[] value) {
        double yyn = (value[0] + 16.0) / 116.0;
        double[] xyzValue = new double[]{this.invfLAB(value[1] / 500.0 + yyn), this.invfLAB(yyn), this.invfLAB(yyn - value[2] / 200.0)};
        return xyz.toRGB(xyzValue);
    }

    private double fLAB(double v) {
        double result;
        if (v > (double)0.008856f) {
            int index = (int)(v * 10000.0 + 0.5);
            result = CUBE_ROOT[index];
        } else {
            result = (double)7.787f * v + 0.13793103396892548;
        }
        return result;
    }

    private double invfLAB(double v) {
        return v > 0.2068927139043808 ? v * v * v : (v - 0.13793103396892548) / (double)7.787f;
    }
}

