/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.colorspace;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import jp.sourceforge.sos.lib.math.MathMatrix;
import jp.sourceforge.sos.lib.math.MathVector;
import jp.sourceforge.sos.lib.util.FirstInFirstOut;
import jp.sourceforge.sos.lib.util.SortInteger;

public final class ColorVector {
    public static final int dim = 3;
    private static final double at = 0.3333333333333333;
    private static final double atf = 0.4166666666666667;
    private static final double co = 0.13793103448275862;
    private static FirstInFirstOut fifo = new FirstInFirstOut(1);
    private static double[] cubeRoot = new double[10891];
    private static double[] sRGB = new double[256];
    private static int[] tempRGB = new int[3];
    private static double x;
    private static double y;
    private static double z;
    private static double yyn;
    private static double f;

    static {
        int i = 0;
        while (i < 11) {
            ColorVector.sRGB[i] = (double)i / 3294.6;
            ++i;
        }
        i = 11;
        while (i < 256) {
            ColorVector.sRGB[i] = Math.pow(((double)i / 255.0 + 0.055) / 1.055, 2.4);
            ++i;
        }
        i = 0;
        while (i < cubeRoot.length) {
            ColorVector.cubeRoot[i] = Math.pow((double)i / 10000.0, 0.3333333333333333);
            ++i;
        }
    }

    public static int[] RGBtoInt(int[][] rgbs) {
        int[] result = new int[rgbs.length];
        int i = 0;
        while (i < result.length) {
            result[i] = ColorVector.RGBtoInt(rgbs[i]);
            ++i;
        }
        return result;
    }

    public static int RGBtoInt(int[] rgb) {
        return (rgb[0] << 16) + (rgb[1] << 8) + rgb[2];
    }

    public static int[] intToRGB(int value) {
        int[] result = new int[]{(value & 0xFF0000) >> 16, (value & 0xFF00) >> 8, value & 0xFF};
        return result;
    }

    public static void intToRGB(int value, int[] result) {
        result[0] = (value & 0xFF0000) >> 16;
        result[1] = (value & 0xFF00) >> 8;
        result[2] = value & 0xFF;
    }

    public static final void getRGB(int[] data, int[][] result) {
        int pn = 0;
        while (pn < data.length) {
            result[pn][0] = (data[pn] & 0xFF0000) >> 16;
            result[pn][1] = (data[pn] & 0xFF00) >> 8;
            result[pn][2] = data[pn] & 0xFF;
            ++pn;
        }
    }

    public static final void getRGB(int[] data, double[][] result) {
        int pn = 0;
        while (pn < data.length) {
            result[pn][0] = (data[pn] & 0xFF0000) >> 16;
            result[pn][1] = (data[pn] & 0xFF00) >> 8;
            result[pn][2] = data[pn] & 0xFF;
            ++pn;
        }
    }

    public static final void getLAB(int[] data, double[][] result) {
        int pn = 0;
        while (pn < data.length) {
            ColorVector.tempRGB[0] = (data[pn] & 0xFF0000) >> 16;
            ColorVector.tempRGB[1] = (data[pn] & 0xFF00) >> 8;
            ColorVector.tempRGB[2] = data[pn] & 0xFF;
            ColorVector.RGBtoLAB(tempRGB, result[pn]);
            ++pn;
        }
    }

    public static final void RGBtoLAB(int[] rgb, double[] lab) {
        ColorVector.RGBtoXYZ(rgb);
        yyn = ColorVector.fLAB(y);
        lab[0] = 116.0 * yyn - 16.0;
        lab[1] = 500.0 * (ColorVector.fLAB(x) - yyn);
        lab[2] = 200.0 * (yyn - ColorVector.fLAB(z));
    }

    public static final void RGBtoLAB(int[] rgb, int[] lab) {
        ColorVector.RGBtoXYZ(rgb);
        yyn = ColorVector.fLAB(y);
        lab[0] = (int)Math.round(116.0 * yyn - 16.0);
        lab[1] = (int)Math.round(500.0 * (ColorVector.fLAB(x) - yyn));
        lab[2] = (int)Math.round(200.0 * (yyn - ColorVector.fLAB(z)));
    }

    public static final double[] RGBtoLAB(double[] rgb) {
        double[] lab = new double[3];
        ColorVector.RGBtoXYZ(rgb);
        yyn = ColorVector.fLAB(y);
        lab[0] = 116.0 * yyn - 16.0;
        lab[1] = 500.0 * (ColorVector.fLAB(x) - yyn);
        lab[2] = 200.0 * (yyn - ColorVector.fLAB(z));
        return lab;
    }

    private static final void RGBtoXYZ(int[] rgb) {
        x = 0.4124 * sRGB[rgb[0]] + 0.3576 * sRGB[rgb[1]] + 0.1805 * sRGB[rgb[2]];
        y = 0.2126 * sRGB[rgb[0]] + 0.7152 * sRGB[rgb[1]] + 0.0722 * sRGB[rgb[2]];
        z = 0.0193 * sRGB[rgb[0]] + 0.1192 * sRGB[rgb[1]] + 0.9505 * sRGB[rgb[2]];
    }

    private static final void RGBtoXYZ(double[] rgb) {
        x = 0.4124 * ColorVector.RGBtoSRGB(rgb[0]) + 0.3576 * ColorVector.RGBtoSRGB(rgb[1]) + 0.1805 * ColorVector.RGBtoSRGB(rgb[2]);
        y = 0.2126 * ColorVector.RGBtoSRGB(rgb[0]) + 0.7152 * ColorVector.RGBtoSRGB(rgb[1]) + 0.0722 * ColorVector.RGBtoSRGB(rgb[2]);
        z = 0.0193 * ColorVector.RGBtoSRGB(rgb[0]) + 0.1192 * ColorVector.RGBtoSRGB(rgb[1]) + 0.9505 * ColorVector.RGBtoSRGB(rgb[2]);
    }

    private static final double RGBtoSRGB(double rgb) {
        return rgb <= 10.0164 ? rgb / 3294.6 : Math.pow((rgb / 255.0 + 0.055) / 1.055, 2.4);
    }

    public static final void LABtoRGB(double[] lab, int[] rgb) {
        yyn = (lab[0] + 16.0) / 116.0;
        x = ColorVector.invfLAB(lab[1] / 500.0 + yyn);
        y = ColorVector.invfLAB(yyn);
        z = ColorVector.invfLAB(yyn - lab[2] / 200.0);
        double RR = 3.2406 * x - 1.5372 * y - 0.4986 * z;
        double GG = -0.9689 * x + 1.8758 * y + 0.0415 * z;
        double BB = 0.0557 * x - 0.204 * y + 1.057 * z;
        rgb[0] = ColorVector.invsRGB(RR);
        rgb[1] = ColorVector.invsRGB(GG);
        rgb[2] = ColorVector.invsRGB(BB);
    }

    public static final void LABtoRGB(int[] lab, int[] rgb) {
        yyn = ((double)lab[0] + 16.0) / 116.0;
        x = ColorVector.invfLAB((double)lab[1] / 500.0 + yyn);
        y = ColorVector.invfLAB(yyn);
        z = ColorVector.invfLAB(yyn - (double)lab[2] / 200.0);
        double RR = 3.2406 * x - 1.5372 * y - 0.4986 * z;
        double GG = -0.9689 * x + 1.8758 * y + 0.0415 * z;
        double BB = 0.0557 * x - 0.204 * y + 1.057 * z;
        rgb[0] = ColorVector.invsRGB(RR);
        rgb[1] = ColorVector.invsRGB(GG);
        rgb[2] = ColorVector.invsRGB(BB);
    }

    private static final double fLAB(double v) {
        f = v > 0.008856 ? cubeRoot[(int)(v * 10000.0)] : 7.787 * v + 0.13793103448275862;
        return f;
    }

    private static final double invfLAB(double v) {
        f = v > 0.2068927064827586 ? v * v * v : (v - 0.13793103448275862) / 7.787;
        return f;
    }

    private static final int invsRGB(double v) {
        f = v > 0.0031308 ? 1.055 * Math.pow(v, 0.4166666666666667) - 0.055 : 12.92 * v;
        int result = (int)Math.round(255.0 * f);
        if (result < 0) {
            result = 0;
        } else if (255 < result) {
            result = 255;
        }
        return result;
    }

    public static final void RGBtoYIQ(int[] rgb, double[] yiq) {
        yiq[0] = 0.299 * (double)rgb[0] + 0.587 * (double)rgb[1] + 0.114 * (double)rgb[2];
        yiq[1] = 0.596 * (double)rgb[0] - 0.274 * (double)rgb[1] - 0.322 * (double)rgb[2];
        yiq[2] = 0.211 * (double)rgb[0] - 0.522 * (double)rgb[1] + 0.311 * (double)rgb[2];
    }

    public static final int RGBtoL(int[] rgb) {
        return (int)Math.round(0.299 * (double)rgb[0] + 0.587 * (double)rgb[1] + 0.114 * (double)rgb[2]);
    }

    public static final int[] intRGBtoL(int[] intRGB) {
        int[] luminance = new int[intRGB.length];
        int[] rgb = new int[3];
        int i = 0;
        while (i < intRGB.length) {
            rgb[0] = (intRGB[i] & 0xFF0000) >> 16;
            rgb[1] = (intRGB[i] & 0xFF00) >> 8;
            rgb[2] = intRGB[i] & 0xFF;
            luminance[i] = (int)(0.299 * (double)rgb[0] + 0.587 * (double)rgb[1] + 0.114 * (double)rgb[2]);
            ++i;
        }
        return luminance;
    }

    public static int RGBtoAny(int[] rgb, double r, double g, double b, int c) {
        int result = (int)Math.round(r * (double)rgb[0] + g * (double)rgb[1] + b * (double)rgb[2]) + c;
        if (result < 0) {
            result = 0;
        }
        if (result > 255) {
            result = 255;
        }
        return result;
    }

    public static int mixtureToInt(int[] color1, int[] color2, double ratio) {
        int r = (int)((double)color1[0] * ratio + (double)color2[0] * (1.0 - ratio));
        int g = (int)((double)color1[1] * ratio + (double)color2[1] * (1.0 - ratio));
        int b = (int)((double)color1[2] * ratio + (double)color2[2] * (1.0 - ratio));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int[] extractUsedColor(int[] pixels) {
        if (fifo.getCapacity() < pixels.length) {
            fifo = new FirstInFirstOut(pixels.length);
        }
        boolean[] isUsed = new boolean[0x1000000];
        int pn = 0;
        while (pn < pixels.length) {
            int colorIndex = pixels[pn] & 0xFFFFFF;
            if (!isUsed[colorIndex]) {
                isUsed[colorIndex] = true;
                fifo.add(colorIndex);
            }
            ++pn;
        }
        return fifo.toArray();
    }

    public static int[] extractUsedColor(int[] pixels, int[] usedColors) {
        if (fifo.getCapacity() < pixels.length + usedColors.length) {
            fifo = new FirstInFirstOut(pixels.length + usedColors.length);
        }
        boolean[] isUsed = new boolean[0x1000000];
        if (usedColors != null) {
            int i = 0;
            while (i < usedColors.length) {
                isUsed[usedColors[i]] = true;
                fifo.add(usedColors[i]);
                ++i;
            }
        }
        return ColorVector.extractUsedColor(pixels);
    }

    public static int[] makeHistogram(int[] pixels, int[] colors) {
        int[] histogram = new int[colors.length];
        Arrays.sort(colors);
        int pn = 0;
        while (pn < pixels.length) {
            int index;
            int value = pixels[pn] & 0xFFFFFF;
            int n = index = Arrays.binarySearch(colors, value);
            histogram[n] = histogram[n] + 1;
            ++pn;
        }
        return histogram;
    }

    public static int[] makeHistogram(int[] pixels, int[] colors, int[] table) {
        int[] histogram = new int[colors.length];
        Arrays.sort(colors);
        int pn = 0;
        while (pn < pixels.length) {
            int index;
            int value = pixels[pn] & 0xFFFFFF;
            int n = index = Arrays.binarySearch(colors, value);
            histogram[n] = histogram[n] + 1;
            table[pn] = index;
            ++pn;
        }
        return histogram;
    }

    public static int[] addHistogram(int[] pixels, int[] colors, int[] oldHistogram) {
        int[] histogram = new int[colors.length];
        SortInteger si = new SortInteger(colors);
        int i = 0;
        while (i < colors.length) {
            histogram[si.getOrder((int)i)] = oldHistogram[i];
            ++i;
        }
        int pn = 0;
        while (pn < pixels.length) {
            int index;
            int value = pixels[pn] & 0xFFFFFF;
            int n = index = Arrays.binarySearch(colors, value);
            histogram[n] = histogram[n] + 1;
            ++pn;
        }
        return histogram;
    }

    public static double[] colorToLoc(double[] input, double[][] eigenVec) {
        double[] loc = new double[]{MathVector.dot(eigenVec[0], input), MathVector.dot(eigenVec[1], input)};
        return loc;
    }

    public static double[] colorToLoc(int[] input, double[][] eigenVec) {
        double[] loc = new double[]{MathVector.dot(eigenVec[0], input), MathVector.dot(eigenVec[1], input)};
        return loc;
    }

    public static double[][] colorToLoc(double[][] input, double[][] eigenVec) {
        double[][] covMx = MathVector.covariance(input);
        MathMatrix.eigenJacobi(covMx, eigenVec);
        double[][] loc = new double[2][input.length];
        int pn = 0;
        while (pn < input.length) {
            loc[0][pn] = MathVector.dot(eigenVec[0], input[pn]);
            loc[1][pn] = MathVector.dot(eigenVec[1], input[pn]);
            ++pn;
        }
        return loc;
    }

    public static int[][] colorToLoc(int[][] input, double[][] eigenVec) {
        double[][] covMx = MathVector.covariance(input);
        MathMatrix.eigenJacobi(covMx, eigenVec);
        int[][] loc = new int[2][input.length];
        int pn = 0;
        while (pn < input.length) {
            loc[0][pn] = (int)Math.round(MathVector.dot(eigenVec[0], input[pn]));
            loc[1][pn] = (int)Math.round(MathVector.dot(eigenVec[1], input[pn]));
            ++pn;
        }
        return loc;
    }

    public static Color invert(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static String toString(int[] rgb) {
        return String.valueOf(rgb[0]) + "," + rgb[1] + "," + rgb[2];
    }

    public static ArrayList makeCluster(int[] pixels, int[] cluster) {
        ArrayList<Integer> colorArray = new ArrayList<Integer>();
        int pn = 0;
        while (pn < pixels.length) {
            int index = 0;
            while (index < colorArray.size()) {
                if (((Integer)colorArray.get(index)).equals(new Integer(pixels[pn]))) break;
                ++index;
            }
            if (index == colorArray.size()) {
                colorArray.add(new Integer(pixels[pn]));
            }
            cluster[pn] = index;
            ++pn;
        }
        return colorArray;
    }

    public static void findNearestColor(int[] data, int[][] random) {
        double[][] randomD = new double[random.length][3];
        int n = 0;
        while (n < random.length) {
            ColorVector.RGBtoLAB(random[n], randomD[n]);
            ++n;
        }
        int[] rgb = new int[3];
        double[] lab = new double[3];
        int[] m = new int[random.length];
        double[] sentinel = new double[random.length];
        Arrays.fill(sentinel, 9.9999999E7);
        int i = 0;
        while (i < data.length) {
            ColorVector.intToRGB(data[i], rgb);
            ColorVector.RGBtoLAB(rgb, lab);
            int n2 = 0;
            while (n2 < random.length) {
                double norm = MathVector.norm(lab, randomD[n2]);
                if (norm < sentinel[n2]) {
                    sentinel[n2] = norm;
                    m[n2] = i;
                }
                ++n2;
            }
            ++i;
        }
        int n3 = 0;
        while (n3 < random.length) {
            int[] rgbArray = new int[3];
            ColorVector.intToRGB(data[m[n3]], rgbArray);
            random[n3] = rgbArray;
            ++n3;
        }
    }
}

