/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.image;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import jp.sourceforge.sos.lib.colorspace.IntRGB;

public class ImagePixelMediator {
    public static BufferedImage toImage(int[] pixels, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 1);
        int[][] rgb = ImagePixelMediator.convertToRGBArray(pixels);
        return ImagePixelMediator.createBufferedImage(rgb, bi);
    }

    public static BufferedImage toAlphaImage(int[] pixels, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        int[][] rgb = ImagePixelMediator.convertToRGBArray(pixels);
        return ImagePixelMediator.createBufferedImage(rgb, bi);
    }

    private static int[][] convertToRGBArray(int[] pixels) {
        int[][] rgb = new int[pixels.length][];
        IntRGB converter = new IntRGB();
        int i = 0;
        while (i < rgb.length) {
            rgb[i] = converter.toRGB(pixels[i]);
            ++i;
        }
        return rgb;
    }

    public static BufferedImage toImage(int[][] pixels, Dimension size) {
        return ImagePixelMediator.toImage(pixels, size.width, size.height);
    }

    public static BufferedImage toImage(int[][] pixels, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 1);
        return ImagePixelMediator.createBufferedImage(pixels, bi);
    }

    public static BufferedImage toAlphaImage(int[][] pixels, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        return ImagePixelMediator.createBufferedImage(pixels, bi);
    }

    private static BufferedImage createBufferedImage(int[][] pixels, BufferedImage bi) {
        WritableRaster wr = bi.getRaster();
        int index = 0;
        int y = 0;
        while (y < wr.getHeight()) {
            int x = 0;
            while (x < wr.getWidth()) {
                wr.setPixel(x, y, pixels[index]);
                ++index;
                ++x;
            }
            ++y;
        }
        return bi;
    }

    public static BufferedImage toImage(byte[] pixels, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 10);
        WritableRaster wr = bi.getRaster();
        int index = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                wr.setSample(x, y, 0, pixels[index] & 0xFF);
                ++index;
                ++x;
            }
            ++y;
        }
        return bi;
    }

    public static int[][] toPixelArray(BufferedImage img) {
        DataBuffer buffer = img.getRaster().getDataBuffer();
        int nBand = img.getRaster().getNumBands();
        int size = buffer.getSize() / nBand;
        int[][] result = new int[size][nBand];
        byte[] data = ((DataBufferByte)buffer).getData();
        int i = 0;
        while (i < size) {
            int index = i * nBand;
            int j = 0;
            while (j < nBand) {
                result[i][j] = data[index + j] & 0xFF;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static int[] toPixels(Image img) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
            return pixels;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int[] toPixels(Image img, Rectangle rect) {
        int[] pixels = new int[rect.width * rect.height];
        PixelGrabber pg = new PixelGrabber(img, rect.x, rect.y, rect.width, rect.height, pixels, 0, rect.width);
        try {
            pg.grabPixels();
            return pixels;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage toGrayImage(int[] data, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 10);
        WritableRaster wr = bi.getRaster();
        int index = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                wr.setSample(x, y, 0, data[index]);
                ++index;
                ++x;
            }
            ++y;
        }
        return bi;
    }
}

