/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.util;

public final class FirstInFirstOut {
    private int[] elements;
    private int first;
    private int last;
    private int marker;
    private boolean overFlow = false;

    public FirstInFirstOut(int capacity) {
        this.elements = new int[capacity];
        int i = 0;
        while (i < capacity) {
            this.elements[i] = -1;
            ++i;
        }
        this.clear();
    }

    public final void add(int value) {
        this.elements[this.last] = value;
        ++this.last;
        if (this.last == this.elements.length) {
            this.last = 0;
            this.overFlow = true;
        }
    }

    public final int get() {
        int value = this.elements[this.first];
        ++this.first;
        if (this.first == this.elements.length) {
            this.first = 0;
            this.overFlow = false;
        }
        return value;
    }

    public final boolean isEmpty() {
        return this.first == this.last && !this.overFlow;
    }

    public final void setMarker() {
        this.marker = this.first;
    }

    public final void rewindToMarker() {
        this.first = this.marker;
        if (this.last <= this.first) {
            this.overFlow = true;
        }
    }

    public final int[] toArray() {
        int[] result = this.makeArray(this.first, this.last);
        this.overFlow = false;
        this.first = this.last;
        return result;
    }

    private final int[] makeArray(int startPoint, int endPoint) {
        int[] result;
        if (this.overFlow) {
            int latter = this.elements.length - startPoint;
            result = new int[latter + endPoint];
            System.arraycopy(this.elements, startPoint, result, 0, latter);
            System.arraycopy(this.elements, 0, result, latter, endPoint);
        } else {
            result = new int[endPoint - startPoint];
            System.arraycopy(this.elements, startPoint, result, 0, result.length);
        }
        return result;
    }

    public final int getSize() {
        int n = 0;
        n = this.overFlow ? this.elements.length - this.first + this.last : this.last - this.first;
        return n;
    }

    public final int getCapacity() {
        return this.elements.length;
    }

    public void clear() {
        this.first = 0;
        this.last = 0;
        this.overFlow = false;
    }
}

