/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.util;

import java.util.ArrayList;
import jp.sourceforge.sos.lib.math.MathVector;
import jp.sourceforge.sos.lib.math.Statistics;
import jp.sourceforge.sos.lib.util.SortDouble;

public final class Sets {
    public static final int[][] enumerate(int dim, int[] template) {
        int[] number = new int[dim + 1];
        number[0] = 1;
        int d = 1;
        while (d <= dim) {
            number[d] = number[d - 1] * template.length;
            ++d;
        }
        int[][] result = new int[number[dim]][dim];
        int n = 0;
        while (n < result.length) {
            int d2 = 1;
            while (d2 <= dim) {
                result[n][dim - d2] = template[n / number[d2 - 1] % template.length];
                ++d2;
            }
            ++n;
        }
        return result;
    }

    public static final int permutation(int n) {
        int result = 1;
        int i = 2;
        while (i <= n) {
            result *= i;
            ++i;
        }
        return result;
    }

    public static final int[][] permutationSets(int first, int last) {
        int n = last - first + 1;
        int[] unit = new int[n];
        int[][] set = new int[Sets.permutation(n)][n];
        int i = first;
        while (i <= last) {
            unit[i] = i;
            ++i;
        }
        int[] c = new int[n + 1];
        int i2 = 1;
        while (i2 <= n) {
            c[i2] = i2;
            ++i2;
        }
        int count = 0;
        int k = 1;
        while (k < n) {
            int i3 = k % 2 == 0 ? 0 : c[k];
            int swap = unit[k];
            unit[k] = unit[i3];
            unit[i3] = swap;
            System.arraycopy(unit, 0, set[count], 0, n);
            ++count;
            k = 1;
            while (c[k] == 0) {
                c[k] = k;
                ++k;
            }
            int n2 = k;
            c[n2] = c[n2] - 1;
        }
        return set;
    }

    public static final int matchNorm(double[][] criteria, double[][] value) {
        int[][] matchSet = Sets.permutationSets(0, criteria.length - 1);
        int matchIndex = 0;
        double sentinel = 0.0;
        int n = 0;
        while (n < criteria.length) {
            sentinel += MathVector.norm(criteria[n], value[matchSet[0][n]]);
            ++n;
        }
        int m = 1;
        while (m < matchSet.length) {
            double totalNorm = 0.0;
            int n2 = 0;
            while (n2 < criteria.length) {
                totalNorm += MathVector.norm(criteria[n2], value[matchSet[m][n2]]);
                ++n2;
            }
            if (totalNorm < sentinel) {
                sentinel = totalNorm;
                matchIndex = m;
            }
            ++m;
        }
        return matchIndex;
    }

    public static final int matchNorm(int[][] criteria, int[][] value) {
        int[][] matchSet = Sets.permutationSets(0, criteria.length - 1);
        int matchIndex = 0;
        int sentinel = 0;
        int n = 0;
        while (n < criteria.length) {
            sentinel += MathVector.norm(criteria[n], value[matchSet[0][n]]);
            ++n;
        }
        int m = 1;
        while (m < matchSet.length) {
            int totalNorm = 0;
            int n2 = 0;
            while (n2 < criteria.length) {
                totalNorm += MathVector.norm(criteria[n2], value[matchSet[m][n2]]);
                ++n2;
            }
            if (totalNorm < sentinel) {
                sentinel = totalNorm;
                matchIndex = m;
            }
            ++m;
        }
        return matchIndex;
    }

    public static final int[] matchOrderNorm(int[][] criteria, int[][] finValue) {
        int[] result = new int[criteria.length];
        ArrayList<int[]> initArray = new ArrayList<int[]>();
        ArrayList<int[]> finArray = new ArrayList<int[]>();
        int i = 0;
        while (i < result.length) {
            initArray.add(criteria[i]);
            finArray.add(finValue[i]);
            ++i;
        }
        int n = 0;
        while (n < result.length) {
            int indexInit = 0;
            int indexFin = 0;
            int sentinel = 999999999;
            int i2 = 0;
            while (i2 < initArray.size()) {
                if (initArray.get(i2) != null) {
                    int j = 0;
                    while (j < finArray.size()) {
                        int difference;
                        if (finArray.get(j) != null && (difference = MathVector.norm((int[])initArray.get(i2), (int[])finArray.get(j))) < sentinel) {
                            sentinel = difference;
                            indexInit = i2;
                            indexFin = j;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            result[indexInit] = indexFin;
            initArray.set(indexInit, null);
            finArray.set(indexFin, null);
            ++n;
        }
        return result;
    }

    public static final int[] match(double[][] data, int[] histogram, double[][] ref, double[][] dest, int[] cluster) {
        int i;
        int m;
        int nRef = ref.length;
        double[][] nMatch = new double[nRef][nRef];
        int n = 0;
        while (n < nRef) {
            m = Sets.findNearest(data, ref[n]);
            System.arraycopy(data[m], 0, ref[n], 0, 3);
            ++n;
        }
        if (histogram == null) {
            i = 0;
            while (i < data.length) {
                m = Sets.findNearest(ref, data[i]);
                double[] dArray = nMatch[cluster[i]];
                int n2 = m;
                dArray[n2] = dArray[n2] + 1.0;
                ++i;
            }
        } else {
            i = 0;
            while (i < data.length) {
                m = Sets.findNearest(ref, data[i]);
                double[] dArray = nMatch[cluster[i]];
                int n3 = m;
                dArray[n3] = dArray[n3] + (double)histogram[i];
                ++i;
            }
        }
        int[] order = new int[nRef];
        int indexOld = 0;
        int indexNew = 0;
        int n4 = 0;
        while (n4 < order.length) {
            double sentinel = -1.0;
            int i2 = 0;
            while (i2 < nRef) {
                if (nMatch[i2] != null) {
                    int j = 0;
                    while (j < nRef) {
                        if (ref[j] != null) {
                            if (nMatch[i2][j] > sentinel) {
                                sentinel = nMatch[i2][j];
                                indexOld = i2;
                                indexNew = j;
                            } else if (nMatch[i2][j] == sentinel && indexNew == j) {
                                double r2;
                                double r1 = MathVector.norm(dest[indexNew], ref[indexOld]) / MathVector.normSum(dest, ref[indexOld]);
                                indexOld = r1 < (r2 = MathVector.norm(dest[indexNew], ref[i2]) / MathVector.normSum(dest, ref[i2])) ? indexOld : i2;
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            order[indexNew] = indexOld;
            nMatch[indexOld] = null;
            ref[indexNew] = null;
            ++n4;
        }
        return order;
    }

    public static final int findNearest(int[][] vec1, int[] vec2) {
        int m = 0;
        int minNorm = 0;
        int d = 0;
        while (d < vec2.length) {
            minNorm += (vec1[0][d] - vec2[d]) * (vec1[0][d] - vec2[d]);
            ++d;
        }
        int n = 1;
        while (n < vec1.length) {
            int norm = 0;
            int d2 = 0;
            while (d2 < vec2.length) {
                norm += (vec1[n][d2] - vec2[d2]) * (vec1[n][d2] - vec2[d2]);
                ++d2;
            }
            if (norm < minNorm) {
                m = n;
                minNorm = norm;
            }
            ++n;
        }
        return m;
    }

    public static final int findNearest(double[][] vec1, double[] vec2) {
        double diff;
        int m = 0;
        double minNorm = 0.0;
        int d = 0;
        while (d < vec2.length) {
            diff = vec1[0][d] - vec2[d];
            minNorm += diff * diff;
            ++d;
        }
        int n = 1;
        while (n < vec1.length) {
            double norm = 0.0;
            int d2 = 0;
            while (d2 < vec2.length) {
                diff = vec1[n][d2] - vec2[d2];
                norm += diff * diff;
                ++d2;
            }
            if (norm < minNorm) {
                m = n;
                minNorm = norm;
            }
            ++n;
        }
        return m;
    }

    public static final int findSecondNearest(double[][] vec1, double[] vec2, int first) {
        int d;
        int m = 0;
        double minNorm = 0.0;
        if (first != 0) {
            d = 0;
            while (d < vec2.length) {
                minNorm += (vec1[0][d] - vec2[d]) * (vec1[0][d] - vec2[d]);
                ++d;
            }
        } else {
            d = 0;
            while (d < vec2.length) {
                minNorm += (vec1[1][d] - vec2[d]) * (vec1[1][d] - vec2[d]);
                ++d;
            }
            m = 1;
        }
        int n = 0;
        while (n < vec1.length) {
            if (n != first) {
                double norm = 0.0;
                int d2 = 0;
                while (d2 < vec2.length) {
                    norm += (vec1[n][d2] - vec2[d2]) * (vec1[n][d2] - vec2[d2]);
                    ++d2;
                }
                if (norm < minNorm) {
                    m = n;
                    minNorm = norm;
                }
            }
            ++n;
        }
        return m;
    }

    public static final int findLargestCos(double[][] vec1, double[] vec2) {
        int m = 0;
        double maxCos = MathVector.cos(vec1[0], vec2);
        int n = 1;
        while (n < vec1.length) {
            double cos = MathVector.cos(vec1[n], vec2);
            if (cos > maxCos) {
                m = n;
                maxCos = cos;
            }
            ++n;
        }
        return m;
    }

    public static final int[][] findKNearestNeighbor(double[][] input, int interval, int k) {
        int c;
        int b;
        int a;
        Statistics stat = new Statistics(input);
        double[] max = stat.getMax();
        double[] min = stat.getMin();
        int[] l = new int[max.length];
        int i = 0;
        while (i < max.length) {
            l[i] = (int)((max[i] - min[i]) / (double)interval) + 1;
            ++i;
        }
        ArrayList[][][] zone = new ArrayList[l[0]][l[1]][l[2]];
        int x = 0;
        while (x < l[0]) {
            int y = 0;
            while (y < l[1]) {
                int z = 0;
                while (z < l[2]) {
                    zone[x][y][z] = new ArrayList();
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int i2 = 0;
        while (i2 < input.length) {
            a = (int)((input[i2][0] - min[0]) / (double)interval);
            b = (int)((input[i2][1] - min[1]) / (double)interval);
            c = (int)((input[i2][2] - min[2]) / (double)interval);
            zone[a][b][c].add(Integer.toString(i2));
            ++i2;
        }
        int[][] nearestNeighbors = new int[input.length][k];
        int in = 0;
        while (in < input.length) {
            int nPoints;
            a = (int)((input[in][0] - min[0]) / (double)interval);
            b = (int)((input[in][1] - min[1]) / (double)interval);
            c = (int)((input[in][2] - min[2]) / (double)interval);
            int coef = 0;
            do {
                nPoints = 0;
                int x2 = -(++coef);
                while (x2 <= coef) {
                    if (a + x2 >= 0 && a + x2 < l[0]) {
                        int y = -coef;
                        while (y <= coef) {
                            if (b + y >= 0 && b + y < l[1]) {
                                int z = -coef;
                                while (z <= coef) {
                                    if (c + z >= 0 && c + z < l[2]) {
                                        nPoints += zone[a + x2][b + y][c + z].size();
                                    }
                                    ++z;
                                }
                            }
                            ++y;
                        }
                    }
                    ++x2;
                }
            } while (nPoints <= k);
            double[] norms = new double[nPoints - 1];
            int[] indices = new int[nPoints - 1];
            int count = 0;
            int x3 = -coef;
            while (x3 <= coef) {
                if (a + x3 >= 0 && a + x3 < l[0]) {
                    int y = -coef;
                    while (y <= coef) {
                        if (b + y >= 0 && b + y < l[1]) {
                            int z = -coef;
                            while (z <= coef) {
                                if (c + z >= 0 && c + z < l[2]) {
                                    int n = 0;
                                    while (n < zone[a + x3][b + y][c + z].size()) {
                                        int index = Integer.parseInt((String)zone[a + x3][b + y][c + z].get(n));
                                        if (index != in) {
                                            norms[count] = MathVector.norm(input[in], input[index]);
                                            indices[count] = index;
                                            ++count;
                                        }
                                        ++n;
                                    }
                                }
                                ++z;
                            }
                        }
                        ++y;
                    }
                }
                ++x3;
            }
            SortDouble sd = new SortDouble(norms);
            int i3 = 0;
            while (i3 < k) {
                nearestNeighbors[in][i3] = indices[sd.getOrder(i3)];
                ++i3;
            }
            ++in;
        }
        return nearestNeighbors;
    }
}

