/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import jp.sourceforge.sos.lib.window.DoubleListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDoubleListDialog<T>
extends JDialog {
    private DoubleListModel model;
    private JButton jButtonAdd;
    private JButton jButtonDown;
    private JButton jButtonRemove;
    private JButton jButtonUp;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jListPreset;
    private JList jListSelected;

    public JDoubleListDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public void setModel(DoubleListModel model) {
        this.model = model;
        this.jListPreset.setModel(model.getModelPreset());
        this.jListSelected.setModel(model.getModelSelection());
    }

    private void setEnableButtons(boolean isPreset) {
        this.jButtonAdd.setEnabled(isPreset);
        this.jButtonRemove.setEnabled(!isPreset);
        this.jButtonUp.setEnabled(!isPreset);
        this.jButtonDown.setEnabled(!isPreset);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jListPreset = new JList();
        this.jListSelected = new JList();
        this.jButtonUp = new JButton();
        this.jButtonDown = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("List");
        this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints());
        this.jLabel2.setText("Selected");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jButtonAdd.setText(">");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDoubleListDialog.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        this.getContentPane().add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonRemove.setText("<");
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDoubleListDialog.this.jButtonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.jButtonRemove, gridBagConstraints);
        this.jListPreset.setPreferredSize(new Dimension(200, 300));
        this.jListPreset.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                JDoubleListDialog.this.jListPresetFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jListPreset, gridBagConstraints);
        this.jListSelected.setPreferredSize(new Dimension(200, 300));
        this.jListSelected.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                JDoubleListDialog.this.jListSelectedFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jListSelected, gridBagConstraints);
        this.jButtonUp.setText("UP");
        this.jButtonUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDoubleListDialog.this.jButtonUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.jButtonUp, gridBagConstraints);
        this.jButtonDown.setText("DOWN");
        this.jButtonDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDoubleListDialog.this.jButtonDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jButtonDown, gridBagConstraints);
        this.pack();
    }

    private void jListSelectedFocusGained(FocusEvent evt) {
        this.setEnableButtons(false);
    }

    private void jListPresetFocusGained(FocusEvent evt) {
        this.setEnableButtons(true);
    }

    private void jButtonDownActionPerformed(ActionEvent evt) {
        int[] indices = this.jListSelected.getSelectedIndices();
        int i = 0;
        while (i < indices.length) {
            this.model.switchWithPostElement(indices[i]);
            ++i;
        }
    }

    private void jButtonUpActionPerformed(ActionEvent evt) {
        int[] indices = this.jListSelected.getSelectedIndices();
        int i = 0;
        while (i < indices.length) {
            this.model.switchWithPreElement(indices[i]);
            ++i;
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        Object[] items = this.jListSelected.getSelectedValues();
        int i = 0;
        while (i < items.length) {
            this.model.removeSelection(i);
            ++i;
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        this.model.selectFromPreset(this.jListPreset.getSelectedIndices());
    }
}

