/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import jp.sourceforge.sos.gunmetry.graphics.AbstractRegion;
import jp.sourceforge.sos.gunmetry.main.RegionSet;

public class RegionContour
extends AbstractRegion {
    private BufferedImage img;
    private Color oldColor = Color.black;

    public RegionContour(RegionSet set) {
        super(set);
    }

    public void draw(Graphics g) {
        if (super.needToDraw()) {
            if (this.colorChanged()) {
                this.updateImage();
                this.oldColor = new Color(this.getColor().getRGB());
            }
            g.drawImage(this.img, 0, 0, null);
        }
    }

    private boolean colorChanged() {
        Color color = this.getColor();
        return !this.oldColor.equals(color);
    }

    Graphics getGraphics() {
        return this.img.getGraphics();
    }

    void setImage(BufferedImage img) {
        this.img = img;
    }

    void updateImage() {
        this.img = new BufferedImage(this.img.getWidth(), this.img.getHeight(), 2);
        Graphics g = this.getGraphics();
        g.setColor(this.getColor());
        Point[] p = this.regionSet.getContourPoints();
        int i = 0;
        while (i < p.length) {
            g.drawLine(p[i].x, p[i].y, p[i].x, p[i].y);
            ++i;
        }
    }
}

