/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.image;

import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import javax.swing.SwingUtilities;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IModel;
import jp.sourceforge.sos.gunmetry.common.Mediator;
import jp.sourceforge.sos.gunmetry.main.ViewFrameMain;
import jp.sourceforge.sos.gunmetry.marker.ModelMarker;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.canvas.JTransformCanvas;
import jp.sourceforge.sos.lib.colorspace.ColorVector;
import jp.sourceforge.sos.lib.graphics.GraphicsImage;
import jp.sourceforge.sos.lib.graphics.GraphicsOffscreen;
import jp.sourceforge.sos.lib.graphics.IGraphics;
import jp.sourceforge.sos.lib.image.ImageInfo;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.morphology.data.DataDoubleArray;
import jp.sourceforge.sos.lib.morphology.data.Elements;
import jp.sourceforge.sos.lib.morphology.extra.Sobel;
import jp.sourceforge.sos.lib.util.MinMaxDouble;

public class ModelImage
implements IModel {
    private SOSImageIO imageFileIO = new SOSImageIO();
    private File fileOriginal = null;
    private File fileCluster = null;
    private JTransformCanvas canvas;
    private GraphicsImage graphicsImage;
    private double[] gradient;
    private ImageInfo imiOriginal = new ImageInfo();
    private ImageInfo imiCluster;
    private ModelMarker modelMarker;
    private GraphicsOffscreen graphicsOffscreen;

    public void setAbstraction(IAbstraction abstraction) {
        this.modelMarker = (ModelMarker)abstraction;
        this.canvas = (JTransformCanvas)this.modelMarker.getCanvas();
        this.graphicsImage = new GraphicsImage();
        this.graphicsOffscreen = (GraphicsOffscreen)this.canvas.getGraphicObject(1);
        this.graphicsOffscreen.addGraphicObject(0, this.graphicsImage);
    }

    void setOriginal() {
        if (this.fileOriginal != null) {
            this.setImage(SOSImageIO.readImage(this.fileOriginal));
        }
    }

    void setGradient() {
        if (this.gradient != null) {
            this.setImage(this.createGradientImage(this.gradient));
        }
    }

    void setCluster() {
        if (this.fileCluster != null) {
            this.setImage(SOSImageIO.readImage(this.fileCluster));
        }
    }

    private void setImage(BufferedImage img) {
        if (img == null) {
            return;
        }
        this.graphicsImage.setImage(img);
        this.graphicsOffscreen.update();
        this.repaint();
    }

    boolean loadOriginal() {
        this.clearPreviousData();
        this.imageFileIO.resetChoosableFileFilters();
        this.imageFileIO.setFileFilter(ViewFrameMain.filterImg);
        this.fileOriginal = this.imageFileIO.getOpenFile("Select the original image...");
        if (this.fileOriginal == null) {
            return false;
        }
        BufferedImage img = SOSImageIO.readImage(this.fileOriginal);
        this.imiOriginal = new ImageInfo(img);
        this.modelMarker.setImageInfo(this.imiOriginal);
        this.createGradient();
        if (!this.isSameSize(img)) {
            this.canvas.setSize(img.getWidth(), img.getHeight());
            this.canvas.setSourceSize(img.getWidth(), img.getHeight());
            this.graphicsOffscreen.create(img.getWidth(), img.getHeight());
        }
        this.graphicsImage.setImage(img);
        this.graphicsOffscreen.update();
        this.canvas.getGraphicsTransform().setFullSrc();
        Window window = SwingUtilities.getWindowAncestor(this.canvas);
        window.pack();
        return true;
    }

    private void createGradient() {
        double[][] LAB = new double[this.imiOriginal.getImageSize()][3];
        ColorVector.getLAB(this.imiOriginal.getPixels(), LAB);
        Sobel sobel = new Sobel();
        Elements elements = new Elements(this.imiOriginal.getNeighbor(), new DataDoubleArray(LAB));
        sobel.operate(elements);
        this.gradient = (double[])elements.getResultData();
        this.modelMarker.setGradient(this.gradient);
    }

    private void repaint() {
        this.canvas.repaint();
    }

    private void clearPreviousData() {
        this.fileCluster = null;
        this.imiCluster = null;
        this.gradient = null;
        this.clearGraphicsOffScreen();
        this.modelMarker.init();
        Mediator.inform(Mediator.Subjects.READY_TO_ANALYSIS, Boolean.FALSE);
        Mediator.inform(Mediator.Subjects.POST_ANALYSIS, Boolean.FALSE);
    }

    private void clearGraphicsOffScreen() {
        int i = 0;
        while (i < this.graphicsOffscreen.getObjectsSize()) {
            IGraphics obj = this.graphicsOffscreen.getGraphicObject(i);
            if (obj instanceof GraphicsImage) {
                ((GraphicsImage)obj).setImage(null);
            }
            ++i;
        }
        this.graphicsOffscreen.update();
    }

    private boolean isSameSize(BufferedImage img) {
        return this.canvas.getSourceWidth() == img.getWidth() && this.canvas.getSourceHeight() == img.getHeight();
    }

    private BufferedImage createGradientImage(double[] gradient) {
        BufferedImage img = new BufferedImage(this.imiOriginal.getWidth(), this.imiOriginal.getHeight(), 10);
        DataBufferByte buffer = (DataBufferByte)img.getRaster().getDataBuffer();
        MinMaxDouble mmd = new MinMaxDouble();
        mmd.compareMax(gradient);
        double maxGradient = mmd.getValue();
        int i = 0;
        while (i < gradient.length) {
            byte value = (byte)(255.0 * gradient[i] / maxGradient);
            buffer.setElem(i, value);
            ++i;
        }
        return img;
    }

    boolean loadCluster() {
        this.imageFileIO.resetChoosableFileFilters();
        this.imageFileIO.setFileFilter(ViewFrameMain.filterGifPng);
        this.fileCluster = this.imageFileIO.getOpenFile("Select a file for cluster image...");
        if (this.fileCluster == null) {
            return false;
        }
        BufferedImage img = SOSImageIO.readImage(this.fileCluster);
        if (!this.isSameSize(img)) {
            return false;
        }
        this.imiCluster = new ImageInfo(img);
        this.setMarker();
        return true;
    }

    void setMarker() {
        if (this.imiCluster != null) {
            this.modelMarker.setColorPicker(this.imiCluster);
        }
    }

    JObjectCanvas getCanvas() {
        return this.canvas;
    }

    Image getImage() {
        return this.graphicsImage.getImage();
    }
}

