/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.main;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.gunmetry.common.AnalysisPlugin;
import jp.sourceforge.sos.gunmetry.main.RegionSet;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.canvas.JTransformCanvas;
import jp.sourceforge.sos.lib.colorspace.IntRGB;
import jp.sourceforge.sos.lib.graphics.GraphicsComposite;
import jp.sourceforge.sos.lib.graphics.GraphicsImage;
import jp.sourceforge.sos.lib.graphics.GraphicsOffscreen;
import jp.sourceforge.sos.lib.image.ImageInfo;
import jp.sourceforge.sos.lib.image.ImagePixelMediator;
import jp.sourceforge.sos.lib.io.Extension;
import jp.sourceforge.sos.lib.io.PluginClassLoader;
import jp.sourceforge.sos.lib.io.SOSFileIO;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.morphology.connection.Neighbor;

public class ModelMain
implements IAbstraction {
    private static final String pathAnalyze = "plugins/analysis";
    private static SOSFileIO textFileIO = new SOSFileIO();
    private SOSImageIO imageFileIO = new SOSImageIO();
    private RegionSet nuclei = new RegionSet("nuclei");
    private RegionSet skiz = new RegionSet("skiz");
    private DefaultTableModel tableModel;
    private JTransformCanvas canvas;
    private GraphicsOffscreen graphicsOffscreen;
    private GraphicsImage graphicsImage;
    private GraphicsComposite graphicComposite;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ModelMain() {
        this.setupCanvas();
        this.tableModel = new DefaultTableModel(new Object[0][], new String[]{"Variable", "Output"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Boolean.class};
                boolean[] blArray = new boolean[2];
                blArray[1] = true;
                this.canEdit = blArray;
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
        this.loadAnalysisPlugin();
    }

    private void setupCanvas() {
        this.canvas = new JTransformCanvas();
        this.graphicsOffscreen = new GraphicsOffscreen();
        this.graphicsImage = new GraphicsImage();
        this.graphicComposite = new GraphicsComposite();
        this.graphicComposite.setComposite(AlphaComposite.getInstance(3, 0.5f));
        this.graphicsOffscreen.addGraphicObject(this.graphicComposite);
        this.graphicsOffscreen.addGraphicObject(this.graphicsImage);
        this.graphicsOffscreen.addGraphicObject(new GraphicsComposite(AlphaComposite.Src));
        this.canvas.addGraphicObject(this.graphicsOffscreen);
    }

    private void loadAnalysisPlugin() {
        File file = new File(pathAnalyze);
        File[] fileList = file.listFiles();
        if (fileList != null) {
            this.tableModel.setRowCount(fileList.length);
            int i = 0;
            while (i < fileList.length) {
                String algorithmName = Extension.remove(fileList[i].getName());
                this.tableModel.setValueAt(algorithmName, i, 0);
                this.tableModel.setValueAt(false, i, 1);
                ++i;
            }
        }
    }

    public RegionSet getNuclei() {
        return this.nuclei;
    }

    public RegionSet getSkiz() {
        return this.skiz;
    }

    void saveImage() {
        BufferedImage img = this.canvas.getScreenImage();
        this.imageFileIO.writeImage(img);
    }

    void saveResult() {
        ArrayList<ArrayList<Double>> result = new ArrayList<ArrayList<Double>>();
        ArrayList<String> variableName = new ArrayList<String>();
        PluginClassLoader loader = new PluginClassLoader(pathAnalyze);
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            if (((Boolean)this.tableModel.getValueAt(i, 1)).booleanValue()) {
                String algorithmName = (String)this.tableModel.getValueAt(i, 0);
                try {
                    AnalysisPlugin plugin = (AnalysisPlugin)loader.loadClass(algorithmName).newInstance();
                    result.add(plugin.analyze(this.nuclei.getRegion(), this.skiz.getRegion()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                variableName.add(algorithmName);
            }
            ++i;
        }
        String[] strResult = new String[this.nuclei.size() + 1];
        strResult[0] = "";
        int j = 0;
        while (j < variableName.size()) {
            strResult[0] = String.valueOf(strResult[0]) + (String)variableName.get(j) + ",";
            ++j;
        }
        int i2 = 1;
        while (i2 < strResult.length) {
            strResult[i2] = "";
            int j2 = 0;
            while (j2 < result.size()) {
                int n = i2;
                strResult[n] = String.valueOf(strResult[n]) + ((ArrayList)result.get(j2)).get(i2 - 1) + ",";
                ++j2;
            }
            ++i2;
        }
        textFileIO.resetChoosableFileFilters();
        textFileIO.writeStrings(strResult);
    }

    TableModel getTableModel() {
        return this.tableModel;
    }

    public JObjectCanvas getCanvas() {
        return this.canvas;
    }

    public void setNearestNeighbor(int[] distanceMap, ImageInfo imageInfo, int BACKGROUND) {
        Neighbor nf = imageInfo.getNeighbor();
        nf.set8();
        this.skiz.initMinDistance();
        int[] contourSkiz = this.skiz.getContour();
        int i = 0;
        while (i < contourSkiz.length) {
            int pn = contourSkiz[i];
            int[] neighbor = nf.getDir(pn);
            this.findNeighbor(distanceMap, BACKGROUND + 1, imageInfo.getPixelsLabel(), pn, neighbor);
            ++i;
        }
    }

    private void findNeighbor(int[] distanceMap, int FIRST_LABEL, int[] labels, int pn, int[] neighbor) {
        int half = neighbor.length / 2;
        int n = 0;
        while (n < neighbor.length) {
            int label;
            if (neighbor[n] != 0 && (label = labels[pn + neighbor[n]] - FIRST_LABEL) >= 0 && distanceMap[pn + neighbor[n]] < this.skiz.getMinDistance(label)) {
                int contraNeighbor = pn + neighbor[(n + half) % neighbor.length];
                int neighborLabel = labels[contraNeighbor] - FIRST_LABEL;
                if (pn != contraNeighbor && neighborLabel >= 0) {
                    this.skiz.setMinDistance(label, distanceMap[pn + neighbor[n]]);
                    this.skiz.setNearestNeighbor(label, neighborLabel);
                    this.nuclei.setNearestNeighbor(label, neighborLabel);
                }
            }
            ++n;
        }
    }

    public void createImage(Color colorObject, Color colorBackground, ImageInfo imageInfo, int BACKGROUND) {
        IntRGB rgb = new IntRGB();
        int[] rgbObject = rgb.toRGB(colorObject.getRGB());
        int[] rgbBackground = rgb.toRGB(colorBackground.getRGB());
        int[] label = imageInfo.getPixelsLabel();
        int[][] result = new int[label.length][];
        int i = 0;
        while (i < result.length) {
            result[i] = label[i] > BACKGROUND ? rgbObject : rgbBackground;
            ++i;
        }
        BufferedImage img = ImagePixelMediator.toImage(result, imageInfo.getSize());
        this.graphicsImage.setImage(img);
        this.repaint();
    }

    void setAlpha(float value) {
        AlphaComposite composite = AlphaComposite.getInstance(3, value);
        this.graphicComposite.setComposite(composite);
        this.repaint();
    }

    private void repaint() {
        ((GraphicsOffscreen)this.canvas.getGraphicObject(1)).update();
        this.canvas.repaint();
    }

    public void init() {
        this.nuclei.clear();
        this.skiz.clear();
    }
}

