/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import jp.sourceforge.sos.gunmetry.common.Operation;

public class PanelButtons
extends JPanel {
    private ButtonGroup buttonGroup = new ButtonGroup();
    private AbstractButton[] buttons;

    public PanelButtons() {
        this.initialize();
        this.setupKeyInput();
    }

    public void add(Component comp, Object cons) {
        super.add(comp, cons);
        if (comp instanceof Operation) {
            this.buttonGroup.add((JToggleButton)comp);
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, "Operation", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
    }

    private void setupKeyInput() {
        KeyboardFocusManager keyboardManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardManager.addKeyEventPostProcessor(new KeyEventPostProcessor(){

            public boolean postProcessKeyEvent(KeyEvent evt) {
                if (evt.getID() == 401 && evt.getKeyCode() == 88) {
                    PanelButtons.this.switchButton();
                }
                return false;
            }
        });
    }

    private void switchButton() {
        if (this.buttons == null) {
            this.createButtonsArray();
        }
        int index = 0;
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i].isSelected()) {
                index = (i + 1) % this.buttons.length;
                break;
            }
            ++i;
        }
        this.buttons[index].doClick();
    }

    private void createButtonsArray() {
        int n = this.buttonGroup.getButtonCount();
        this.buttons = new AbstractButton[n];
        Enumeration<AbstractButton> e = this.buttonGroup.getElements();
        int i = 0;
        while (e.hasMoreElements()) {
            this.buttons[i++] = e.nextElement();
        }
    }
}

