/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.main;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import jp.sourceforge.sos.gunmetry.main.Region;
import jp.sourceforge.sos.gunmetry.marker.MarkerSet;
import jp.sourceforge.sos.lib.image.ImageInfo;

public class RegionSet {
    private Region[] regions;
    private int[] contour;
    private Point[] contourPoints;
    private String name;

    public RegionSet(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public void clear() {
        this.regions = null;
        this.contour = null;
        this.contourPoints = null;
    }

    public int size() {
        return this.regions == null ? 0 : this.regions.length;
    }

    public Point2D.Double getCentroid(int index) {
        return this.regions[index].getCentroid();
    }

    public void initMinDistance() {
        int i = 0;
        while (i < this.regions.length) {
            this.setMinDistance(i, Integer.MAX_VALUE);
            ++i;
        }
    }

    public int getMinDistance(int index) {
        return this.regions[index].getMinDistance();
    }

    public void setMinDistance(int index, int value) {
        this.regions[index].setMinDistance(value);
    }

    public Region getNearestNeighbor(int index) {
        return this.regions[index].getNearestNeighbor();
    }

    public void setNearestNeighbor(int index, int indexNeighbor) {
        Region neighbor = this.regions[indexNeighbor];
        this.regions[index].setNearestNeighbor(neighbor);
    }

    public Region[] getRegion() {
        return this.regions;
    }

    public void setRegion(MarkerSet markers, ImageInfo imi, int backgroundIndex) {
        int FIRST_LABEL = backgroundIndex + 1;
        this.regions = new Region[markers.size()];
        int i = 0;
        while (i < this.regions.length) {
            this.regions[i] = new Region();
            ++i;
        }
        this.addPoints(imi, FIRST_LABEL);
        this.setRegionUnmask(imi, FIRST_LABEL);
        this.removeZerosizedRegion();
    }

    private void addPoints(ImageInfo imi, int FIRST_LABEL) {
        int y = 0;
        while (y < imi.getHeight()) {
            int offset = y * imi.getWidth();
            int x = 0;
            while (x < imi.getWidth()) {
                int index = imi.getPixelsLabel(x + offset) - FIRST_LABEL;
                if (index >= 0) {
                    this.regions[index].expandRegion(x, y);
                }
                ++x;
            }
            ++y;
        }
    }

    private void removeZerosizedRegion() {
        ArrayList<Region> regionList = new ArrayList<Region>();
        int i = 0;
        while (i < this.regions.length) {
            if (this.regions[i].getSize() > 0) {
                regionList.add(this.regions[i]);
            }
            ++i;
        }
        this.regions = regionList.toArray(new Region[0]);
    }

    private void setRegionUnmask(ImageInfo imi, int FIRST_LABEL) {
        int n = 0;
        while (n < this.regions.length) {
            this.regions[n].initUnmask();
            Rectangle bounds = this.regions[n].getBounds();
            if (bounds != null) {
                int y = 0;
                while (y < bounds.height) {
                    int offset = bounds.x + (y + bounds.y) * imi.getWidth();
                    int x = 0;
                    while (x < bounds.width) {
                        if (imi.getPixelsLabel(x + offset) - FIRST_LABEL == n) {
                            this.regions[n].setUnmask(x, y);
                        }
                        ++x;
                    }
                    ++y;
                }
            }
            ++n;
        }
    }

    public int[] getContour() {
        return this.contour;
    }

    public void setContour(int[] contour) {
        this.contour = contour;
    }

    public Point[] getContourPoints() {
        return this.contourPoints;
    }

    public void setContourPoints(Point[] contourPoints) {
        this.contourPoints = contourPoints;
    }
}

