/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.ViewTopFrame;
import jp.sourceforge.sos.gunmetry.common.Mediator;
import jp.sourceforge.sos.gunmetry.common.Operation;
import jp.sourceforge.sos.gunmetry.graphics.PanelRegion;
import jp.sourceforge.sos.gunmetry.main.ModelMain;
import jp.sourceforge.sos.gunmetry.main.PanelButtons;
import jp.sourceforge.sos.gunmetry.main.ViewDialogResult;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.io.ExtensionFilter;

public class ViewFrameMain
extends ViewTopFrame {
    public static final ExtensionFilter filterImg;
    public static final ExtensionFilter filterGifPng;
    private JMenuBar jMenuBarMain;
    private JMenu jMenuFile;
    JMenu jMenuResult;
    private JMenuItem jMenuSaveData;
    private JMenuItem jMenuSaveImage;
    public JLabel jLabelInfo = null;
    private JPanel jPanelMain = null;
    private JPanel jContentPane = null;
    private PanelButtons jPanelOperation = null;
    private ViewDialogResult viewDialogResult;
    private ModelMain model;
    private JMenuItem jMenuItemSaveColors = null;

    static {
        String[] exts = ImageIO.getReaderFormatNames();
        String description = "Image Files (ImageI/O readable)";
        filterImg = new ExtensionFilter(exts, description);
        filterGifPng = new ExtensionFilter(new String[]{"gif", "png"}, "GIF or PNG");
    }

    public ViewFrameMain() {
        this.initComponents();
        this.viewDialogResult = new ViewDialogResult(this);
    }

    private void initComponents() {
        this.jMenuBarMain = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuResult = new JMenu();
        this.jMenuSaveData = new JMenuItem();
        this.jMenuSaveImage = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Gunmetry Ver. 2.0");
        this.setCursor(new Cursor(0));
        this.jMenuBarMain.setDoubleBuffered(true);
        this.jMenuFile.setText("File");
        this.jMenuFile.setEnabled(true);
        this.jMenuFile.add(this.getJMenuItemSaveColors());
        this.jMenuBarMain.add(this.jMenuFile);
        this.jMenuResult.setText("Result");
        this.jMenuResult.setEnabled(false);
        this.jMenuSaveData.setText("Save Data");
        this.jMenuSaveData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewFrameMain.this.viewDialogResult.setVisible(true);
            }
        });
        this.jMenuResult.add(this.jMenuSaveData);
        this.jMenuSaveImage.setText("Save Image");
        this.jMenuSaveImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewFrameMain.this.model.saveImage();
            }
        });
        this.jMenuResult.add(this.jMenuSaveImage);
        this.jMenuBarMain.add(this.jMenuResult);
        this.setJMenuBar(this.jMenuBarMain);
        this.pack();
    }

    public void setAbstraction(IAbstraction abstraction) {
        this.model = (ModelMain)abstraction;
        this.viewDialogResult.setAbstraction(abstraction);
        JObjectCanvas canvas = this.model.getCanvas();
        PanelRegion.setCanvas(canvas);
        Operation.setCanvas(canvas);
        this.jContentPane.add((Component)canvas, "Center");
    }

    JPanel getJPanelMain() {
        if (this.jPanelMain == null) {
            this.jPanelMain = new JPanel();
            this.jPanelMain.setLayout(new BoxLayout(this.getJPanelMain(), 1));
            this.jPanelMain.add((Component)this.getJPanelOperation(), null);
        }
        return this.jPanelMain;
    }

    protected JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanelMain(), "West");
        }
        return this.jContentPane;
    }

    private PanelButtons getJPanelOperation() {
        if (this.jPanelOperation == null) {
            this.jPanelOperation = new PanelButtons();
        }
        return this.jPanelOperation;
    }

    private JMenuItem getJMenuItemSaveColors() {
        if (this.jMenuItemSaveColors == null) {
            this.jMenuItemSaveColors = new JMenuItem();
            this.jMenuItemSaveColors.setText("Save colors");
            this.jMenuItemSaveColors.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Mediator.inform(Mediator.Subjects.SAVE_COLORS, null);
                }
            });
        }
        return this.jMenuItemSaveColors;
    }
}

