/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;
import jp.sourceforge.sos.gunmetry.main.ModelMain;

public class ViewPanel
extends JPanel
implements IPresentation {
    private JLabel jLabel = null;
    private JSlider jSliderAlpha = null;
    private ModelMain model;

    public ViewPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, "Result image", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.add((Component)this.getJLabel(), gridBagConstraints);
        this.add((Component)this.getJSliderAlpha(), gridBagConstraints1);
    }

    public void setAbstraction(IAbstraction abstraction) {
        this.model = (ModelMain)abstraction;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("alpha:");
        }
        return this.jLabel;
    }

    private JSlider getJSliderAlpha() {
        if (this.jSliderAlpha == null) {
            this.jSliderAlpha = new JSlider();
            this.jSliderAlpha.setPreferredSize(new Dimension(100, 24));
            this.jSliderAlpha.setMinorTickSpacing(10);
            this.jSliderAlpha.setPaintTicks(true);
            this.jSliderAlpha.setMajorTickSpacing(50);
            this.jSliderAlpha.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    float value = (float)ViewPanel.this.jSliderAlpha.getValue() / 100.0f;
                    ViewPanel.this.model.setAlpha(value);
                }
            });
        }
        return this.jSliderAlpha;
    }
}

