/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.marker;

import java.awt.Point;
import java.awt.geom.Point2D;
import jp.sourceforge.sos.gunmetry.marker.MarkerSet;

public class FocusedMarker {
    private MarkerSet markersObject;
    private MarkerSet markersBackground;
    private Point point = null;
    private boolean isObjectMarker;

    public FocusedMarker(MarkerSet object, MarkerSet background) {
        this.markersObject = object;
        this.markersBackground = background;
    }

    public Point get() {
        return this.point;
    }

    public void set(Point2D mousePoint2D) {
        this.point = this.markersObject.get(mousePoint2D);
        if (this.isActive()) {
            this.isObjectMarker = true;
        } else {
            this.point = this.markersBackground.get(mousePoint2D);
            this.isObjectMarker = false;
        }
    }

    public boolean isActive() {
        return this.point != null;
    }

    public boolean equals(Point p) {
        if (this.point == null) {
            return p == null;
        }
        return this.point.equals(p);
    }

    public boolean setLocation(int x, int y) {
        if (this.point != null) {
            this.point.setLocation(x, y);
            return true;
        }
        return false;
    }

    public void addToMarkers() {
        if (this.isObjectMarker) {
            this.markersObject.add(this.point);
        } else {
            this.markersBackground.add(this.point);
        }
    }

    public void removeFromMarkers() {
        if (this.isObjectMarker) {
            this.markersObject.remove(this.point);
        } else {
            this.markersBackground.remove(this.point);
        }
    }
}

