/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.marker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jp.sourceforge.sos.gunmetry.common.ExtractMarkerPlugin;
import jp.sourceforge.sos.gunmetry.common.JDialogColorPicker;
import jp.sourceforge.sos.lib.io.Extension;
import jp.sourceforge.sos.lib.io.PluginClassLoader;
import jp.sourceforge.sos.lib.morphology.connection.Neighbor;
import jp.sourceforge.sos.lib.morphology.connection.NeighborSimple;
import jp.sourceforge.sos.lib.morphology.data.DataBinary;
import jp.sourceforge.sos.lib.morphology.data.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerColorPicker
extends JDialogColorPicker {
    private static final String pathExtractMarker = "plugins/extractMarker";
    private JPanel jPanelObject = null;
    private JPanel jPanelObjAlgorithm = null;
    private JLabel jLabel = null;
    private JComboBox jComboObj = null;
    private JPanel jPanelBackground = null;
    private JPanel jPanelBackAlgorithm = null;
    private JLabel jLabel1 = null;
    private JComboBox jComboBack = null;

    public MarkerColorPicker() {
        this.initialize();
        this.getJContentPane().add((Component)this.getJPanelObject(), 1);
        this.getJContentPane().add((Component)this.getJPanelBackground(), 2);
        this.loadExtractMarkerPlugin();
        this.pack();
    }

    private void initialize() {
        this.setTitle("Set MarkerSet");
    }

    private JPanel getJPanelObject() {
        if (this.jPanelObject == null) {
            this.jPanelObject = new JPanel();
            this.jPanelObject.setLayout(new BorderLayout());
            this.jPanelObject.setBorder(new TitledBorder("Object"));
            this.jPanelObject.add((Component)this.getJPanelObjAlgorithm(), "North");
        }
        return this.jPanelObject;
    }

    private JPanel getJPanelObjAlgorithm() {
        if (this.jPanelObjAlgorithm == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("algorithm: ");
            this.jPanelObjAlgorithm = new JPanel();
            this.jPanelObjAlgorithm.add((Component)this.jLabel, this.jLabel.getName());
            this.jPanelObjAlgorithm.add((Component)this.getJComboObj(), this.getJComboObj().getName());
        }
        return this.jPanelObjAlgorithm;
    }

    private JComboBox getJComboObj() {
        if (this.jComboObj == null) {
            this.jComboObj = new JComboBox();
            this.jComboObj.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    MarkerColorPicker.this.setOption(MarkerColorPicker.this.jPanelObject, (ExtractMarkerPlugin)MarkerColorPicker.this.jComboObj.getSelectedItem());
                }
            });
        }
        return this.jComboObj;
    }

    private JPanel getJPanelBackground() {
        if (this.jPanelBackground == null) {
            this.jPanelBackground = new JPanel();
            this.jPanelBackground.setLayout(new BorderLayout());
            this.jPanelBackground.setBorder(new TitledBorder("Background"));
            this.jPanelBackground.add((Component)this.getJPanelBackAlgorithm(), "North");
        }
        return this.jPanelBackground;
    }

    private JPanel getJPanelBackAlgorithm() {
        if (this.jPanelBackAlgorithm == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("algorithm: ");
            this.jPanelBackAlgorithm = new JPanel();
            this.jPanelBackAlgorithm.add((Component)this.jLabel1, this.jLabel1.getName());
            this.jPanelBackAlgorithm.add((Component)this.getJComboBack(), this.getJComboBack().getName());
        }
        return this.jPanelBackAlgorithm;
    }

    private JComboBox getJComboBack() {
        if (this.jComboBack == null) {
            this.jComboBack = new JComboBox();
            this.jComboBack.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    MarkerColorPicker.this.setOption(MarkerColorPicker.this.jPanelBackground, (ExtractMarkerPlugin)MarkerColorPicker.this.jComboBack.getSelectedItem());
                }
            });
        }
        return this.jComboBack;
    }

    private void loadExtractMarkerPlugin() {
        File file = new File(pathExtractMarker);
        File[] fileList = file.listFiles();
        if (fileList != null) {
            PluginClassLoader loader = new PluginClassLoader(pathExtractMarker);
            int i = 0;
            while (i < fileList.length) {
                String algorithmName = Extension.remove(fileList[i].getName());
                this.jComboObj.addItem(this.getPlugin(loader, algorithmName));
                this.jComboBack.addItem(this.getPlugin(loader, algorithmName));
                ++i;
            }
            this.jComboObj.setSelectedIndex(1);
            this.jComboBack.setSelectedIndex(1);
        }
    }

    private ExtractMarkerPlugin getPlugin(PluginClassLoader loader, String algorithmName) {
        ExtractMarkerPlugin plugin = null;
        try {
            plugin = (ExtractMarkerPlugin)loader.loadClass(algorithmName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return plugin;
    }

    private void setOption(JPanel panel, ExtractMarkerPlugin plugin) {
        if (plugin != null) {
            JPanel optionPanel = plugin.getOptionPanel();
            this.removeOldOptionPanel(panel);
            if (optionPanel != null) {
                panel.add((Component)optionPanel, "Center");
            }
            this.pack();
        }
    }

    private void removeOldOptionPanel(JPanel panel) {
        if (1 < panel.getComponentCount()) {
            panel.remove(1);
        }
    }

    private ArrayList<Point> extractMarker(ExtractMarkerPlugin plugin, Neighbor neighbor, boolean[] binaryMap) {
        return plugin.extractMarker(new Elements(neighbor, new DataBinary(binaryMap)));
    }

    public ArrayList<Point> extractMarkerObj(int w, int h, boolean[] binaryMap) {
        ExtractMarkerPlugin plugin = (ExtractMarkerPlugin)this.jComboObj.getSelectedItem();
        return this.extractMarker(plugin, new NeighborSimple(w, h), binaryMap);
    }

    public ArrayList<Point> extractMarkerBack(int w, int h, boolean[] binaryMap) {
        ExtractMarkerPlugin plugin = (ExtractMarkerPlugin)this.jComboBack.getSelectedItem();
        return this.extractMarker(plugin, new NeighborSimple(w, h), binaryMap);
    }
}

