
import java.awt.geom.Point2D;
import java.util.ArrayList;

import jp.sourceforge.sos.gunmetry.common.AnalysisPlugin;
import jp.sourceforge.sos.gunmetry.main.Region;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/03/07)
 */
public class SKIZDistance implements AnalysisPlugin{
	
	private ArrayList<Double> result = null;

	public ArrayList<Double> analyze(Region[] nuclei, Region[] skiz) {
		if (result==null){
			result = new ArrayList<Double>();
			double value = 0.0;
			for (int i=0; i<nuclei.length; i++){
				Point2D.Double nu = nuclei[i].getCentroid();
				Point2D.Double sk = skiz[i].getCentroid();
				value = Math.sqrt((nu.x-sk.x)*(nu.x-sk.x)+(nu.y-sk.y)*(nu.y-sk.y));
				result.add(value);
			}
		}
		return result;		
	}
	
}
