import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;

import javax.swing.SpinnerNumberModel;

import jp.sourceforge.sos.gunmetry.common.ExtractMarkerPlugin;
import jp.sourceforge.sos.gunmetry.main.Region;
import jp.sourceforge.sos.lib.morphology.connection.Neighbor;
import jp.sourceforge.sos.lib.morphology.data.DataBinary;
import jp.sourceforge.sos.lib.morphology.data.DataInt;
import jp.sourceforge.sos.lib.morphology.data.Elements;
import jp.sourceforge.sos.lib.morphology.extra.ExtractRegion;
import jp.sourceforge.sos.lib.morphology.extra.GeodesicDistance;
import jp.sourceforge.sos.lib.morphology.extra.Reconstruction;
import jp.sourceforge.sos.lib.panel.JGenericPanel;

/*
 * AnyTopOfDoom.java
 *
 * Created on 2005/03/02, 0:34
 */

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/03/02)
 */
public class HDoom implements ExtractMarkerPlugin{
	int h;
	JGenericPanel optionPanel = new JGenericPanel();
	
	/** Creates a new instance of AnyTopOfDoom */
	public HDoom() {
		optionPanel.addNumericSpinner("min distance = ", new SpinnerNumberModel(2,1,Integer.MAX_VALUE,1));
		optionPanel.addNumericSpinner("h = ", new SpinnerNumberModel(1,1,Integer.MAX_VALUE,1));
	}
	
	public String toString(){
		return "HDoom";
	}
	
	@SuppressWarnings("unchecked")
	public ArrayList<Point> extractMarker(Elements elements) {
		// get value from optionPanel
		int minDistance = (Integer)optionPanel.getSpinnerNumber(0);
		h = (Integer)optionPanel.getSpinnerNumber(1);
		
		elements.set8();
		
		GeodesicDistance geodesicDistance = new GeodesicDistance();
		geodesicDistance.operate(elements);
		int[] distanceMap = (int[])elements.getResultData();
		
		int[] distanceMarker = new int[distanceMap.length];
		for (int i=0; i<distanceMap.length; i++){
			if (minDistance<=distanceMap[i]){
				distanceMarker[i] = distanceMap[i]-h;
			}else{
				distanceMarker[i] = distanceMap[i];
			}
		}
		elements.resultToInput();
		elements.setResult(new DataInt(distanceMarker));
		Reconstruction reconstruct = new Reconstruction();
		reconstruct.operate(elements);
		
		boolean[] topMap = new boolean[distanceMap.length];
		for (int i=0; i<elements.size(); i++){
			topMap[i] = (distanceMarker[i]<distanceMap[i]);
		}
		elements.setInput(new DataBinary(topMap));
		ExtractRegion extractReion = new ExtractRegion();
		extractReion.operate(elements);
		int[] regionMap = (int[])elements.getResultData();
		int nRegion = extractReion.getRegionNumber();
		
		Neighbor neighbor = elements.getNeighbor();
		Region[] rois = makeROI(regionMap,neighbor.getWidth(),neighbor.getHeight(),nRegion,0);
		ArrayList<Point> result = new ArrayList<Point>();
		for (int i=0; i<rois.length; i++){
			Point2D.Double p2D = rois[i].getCentroid();
			Point p = new Point((int)Math.round(p2D.x),(int)Math.round(p2D.y));
			result.add(p);
		}
		
		return result;		
	}

	public javax.swing.JPanel getOptionPanel() {
		return optionPanel;
	}

	private Region[] makeROI(int[] label, int width, int height, int nROI, int FIRST_LABEL){
		Region[] result = new Region[nROI];
		for (int n=0; n<result.length; n++){
			result[n] = new Region();
		}
		
		// make the region with adding points
		int offset,pn, index;
		int BACKGROUND = FIRST_LABEL-1;
		for (int y=0; y<height; y++){
			offset = y*width;
			for (int x=0; x<width; x++){
				pn = x + offset;
				if (label[pn]>BACKGROUND){
					index = label[pn]-FIRST_LABEL;
					result[index].expandRegion(x,y);
				}
			}
		}
		
		// set mask within the region
		for (int n=0; n<result.length; n++){
			result[n].initUnmask();
			Rectangle bounds = result[n].getBounds();
			for (int y=0; y<bounds.height; y++){
				offset = (y+bounds.y)*width;
				for (int x=0; x<bounds.width; x++){
					pn = x+bounds.x+offset;
					if (label[pn]-FIRST_LABEL==n){
						result[n].setUnmask(x,y);
					}
				}
			}
		}
		
		return result;
	}
}
