import java.awt.Point;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;

import jp.sourceforge.sos.gunmetry.common.ExtractMarkerPlugin;
import jp.sourceforge.sos.lib.morphology.connection.Neighbor;
import jp.sourceforge.sos.lib.morphology.data.Elements;
import jp.sourceforge.sos.lib.morphology.extra.ExtractRegion;
import jp.sourceforge.sos.lib.morphology.extra.GeodesicDistance;
import jp.sourceforge.sos.lib.panel.JGenericPanel;


/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (Created on 2005/03/02)
 */
public class OnePerRegion implements ExtractMarkerPlugin{
	private JGenericPanel optionPanel = new JGenericPanel();
	
	/** Creates a new instance of OnePerRegion */
	public OnePerRegion() {
		optionPanel.addNumericSpinner("min distance = ", new SpinnerNumberModel(2,1,Integer.MAX_VALUE,1));
	}
	
	public String toString(){
		return "OnePerRegion";
	}

	public JPanel getOptionPanel() {
		return optionPanel;
	}

	public ArrayList<Point> extractMarker(Elements elements) {
		// get value from optionPanel		
		int minDistance = (Integer)optionPanel.getSpinnerNumber(0);
		
		elements.set8();
		GeodesicDistance geodesicDistance = new GeodesicDistance();
		geodesicDistance.operate(elements);
		int[] distanceMap = (int[])elements.getResultData();
		
		elements.set4();
		ExtractRegion extractReion = new ExtractRegion();
		extractReion.operate(elements);
		int[] regionMap = (int[])elements.getResultData();
		int nRegion = extractReion.getRegionNumber();
		
		Point[] markers = new Point[nRegion];
		int[] maxDistance = new int[nRegion]; 
		int offset;
		Neighbor neighbor = elements.getNeighbor();
		for (int y=0; y<neighbor.getHeight(); y++){
			for (int x=0; x<neighbor.getWidth(); x++){
				offset = x+y*neighbor.getWidth();
				if (minDistance<=distanceMap[offset]){
					int region = regionMap[offset];
					if (maxDistance[region]<distanceMap[offset]){
						maxDistance[region] = distanceMap[offset];
						if (markers[region]!=null){
							markers[region].setLocation(x,y);
						}else{
							markers[region] = new Point(x,y);
						}
					}
				}
			}
		}
		
		ArrayList<Point> result = new ArrayList<Point>();
		for (int i=0; i<markers.length; i++){
			if (markers[i]!=null){
				result.add(markers[i]);
			}
		}
		
		return result;
	}
	
}
