/**
 * 
 */
package jp.sourceforge.sos.gunmetry.common;


import javax.swing.JComponent;

import jp.sourceforge.sos.framework.AbstractPACControl;
import jp.sourceforge.sos.framework.IPresentation;
import jp.sourceforge.sos.lib.design.observer.IObserver;
import jp.sourceforge.sos.lib.design.observer.ISubject;

/**
 * @author Gaku Tanaka
 * 
 */
@SuppressWarnings("unchecked")
public abstract class AbstractGunmetryControl extends AbstractPACControl {

	protected enum MainContainers {
		jContentPane,
		jPanelMain,
		jMenuFile, jPanelOperation, jMenuBarMain
	}
	
	public AbstractGunmetryControl(AbstractPACControl parent) {
		super(parent);
	}

	public void init(){}

	protected void set(MainContainers name, IPresentation presentation) {
		linkToTopView(name, presentation);
		setView(presentation);
	}
	
	protected void set(MainContainers name, IPresentation presentation, int index) {
		linkToTopView(name, presentation, index);
		setView(presentation);
	}	
	
	protected void set(MainContainers name, IPresentation presentation, Object constraints) {
		linkToTopView(name, presentation, constraints);
		setView(presentation);
	}

	/**
	 * @param name
	 * @param presentation
	 */
	protected void linkToTopView(MainContainers name, Object presentation) {
		adapterPanel.addToContainer(name.toString(), ((JComponent)presentation));
	}

	/**
	 * @param name
	 * @param presentation
	 * @param index
	 */
	protected void linkToTopView(MainContainers name, Object presentation, int index) {
		adapterPanel.addToContainer(name.toString(), ((JComponent)presentation),index);
	}
	
	protected void linkToTopView(MainContainers name, Object presentation, Object constraints) {
		adapterPanel.addToContainer(name.toString(), ((JComponent)presentation), constraints);
	}	
	
	protected <T>void addModelObserver() {
		ISubject parentModel = (ISubject<T>)getParentModel();
		parentModel.addObserver((IObserver<T>)model);
	}

}
