package jp.sourceforge.sos.gunmetry.common;

import java.awt.GridLayout;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

@SuppressWarnings("serial")
public class JDialogColorPicker extends JDialog {

	private JPanel jContentPane = null;

	private JScrollPane jScrollPane = null;

	private JPanel jPanel = null;

	private JButton jButtonSet = null;

	private JButton jButtonCancel = null;

	protected ColorPicker imageColorPicker = null;

	public JDialogColorPicker() {
		super();
		initialize();
		pack();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		this.setModal(true);
		this.setTitle("Set mask");
		this.setContentPane(getJContentPane());
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	protected JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BoxLayout(getJContentPane(), BoxLayout.Y_AXIS));
			jContentPane.add(getJScrollPane(), null);
			jContentPane.add(getJPanel(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jScrollPane
	 * 
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setViewportView(getImageColorPicker());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jPanel
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(1);
			gridLayout.setColumns(2);
			jPanel = new JPanel();
			jPanel.setLayout(gridLayout);
			jPanel.add(getJButtonSet(), null);
			jPanel.add(getJButtonCancel(), null);
		}
		return jPanel;
	}

	/**
	 * This method initializes jButton
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButtonSet() {
		if (jButtonSet == null) {
			jButtonSet = new JButton();
			jButtonSet.setText("SET");
			jButtonSet.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					int nChecked = imageColorPicker.getCheckedNumber();
					if (nChecked == 0 || nChecked == imageColorPicker.getColorNumber()) {
						return;
					}
					setVisible(false);
				}
			});
		}
		return jButtonSet;
	}

	/**
	 * This method initializes jButton1
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButtonCancel() {
		if (jButtonCancel == null) {
			jButtonCancel = new JButton();
			jButtonCancel.setText("CANCEL");
			jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					setVisible(false);
				}
			});
		}
		return jButtonCancel;
	}
	
	/**
	 * This method initializes imageColorPicker
	 * 
	 * @return jp.sourceforge.sos.gunmetry.marker.MarkerColorPicker
	 */
	protected ColorPicker getImageColorPicker() {
		if (imageColorPicker==null) {
			imageColorPicker = new ColorPicker();
		}
		return imageColorPicker;
	}
	
	public void setColorTable(int[] pixels, int[] colorCluster) {
		imageColorPicker.setColorTable(pixels, colorCluster);
		setVisible(true);
	}

	public boolean[] getFlag() {
		return imageColorPicker.getFlag();
	}

} // @jve:decl-index=0:visual-constraint="26,22"
