package jp.sourceforge.sos.gunmetry.common;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.JToggleButton;

import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.canvas.JTransformCanvas;


public abstract class Operation extends JToggleButton implements MouseListener,MouseMotionListener {

	static protected JTransformCanvas	canvas;

	protected Cursor				cursorCanvas;

	public Operation() {
		super();
		initialize();
		setCursor();
	}

	abstract protected void setCursor();

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		this.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				setListeners();
			}
		});
		this.setPreferredSize(new java.awt.Dimension(35, 35));
	}

	protected void setListeners() {

		MouseListener[] listeners = canvas.getMouseListeners();
		for (int i=0; i<listeners.length; i++){
			canvas.removeMouseListener(listeners[i]);
		}
		MouseMotionListener[] listeners1 = canvas.getMouseMotionListeners();
		for (int i=0; i<listeners.length; i++){
			canvas.removeMouseMotionListener(listeners1[i]);
		}

		canvas.setCursor(cursorCanvas);
		canvas.addMouseListener(this);
		canvas.addMouseMotionListener(this);
	}

	public static void setCanvas(JObjectCanvas canvas2) {
		canvas = (JTransformCanvas) canvas2;
	}
	
	public void mouseClicked(MouseEvent e) {}

	public void mousePressed(MouseEvent e) {}

	public void mouseReleased(MouseEvent e) {}

	public void mouseEntered(MouseEvent e) {}

	public void mouseExited(MouseEvent e) {}

	public void mouseDragged(MouseEvent e) {}

	public void mouseMoved(MouseEvent e) {}
}
