/**
 * 
 */
package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.Color;

import javax.swing.ButtonModel;
import javax.swing.JToggleButton;

import jp.sourceforge.sos.gunmetry.main.RegionSet;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.graphics.IGraphics;

/**
 * @author Gaku Tanaka
 *
 */
abstract class AbstractRegion implements IGraphics {

	protected RegionSet regionSet;
	
	private ButtonModel buttonModel;
	
	private ColorModel colorModel;
	/**
	 * 
	 */
	AbstractRegion(RegionSet regionSet) {
		super();
		
		buttonModel = new JToggleButton.ToggleButtonModel();
		buttonModel.setSelected(true);
		
		colorModel = new ColorModel();
		
		this.regionSet = regionSet;
	}
	
	public String toString(){
		return getClass()+"."+regionSet;
	}

	ButtonModel getButtonModel() {
		return buttonModel;
	}
	
	ColorModel getColorModel() {
		return colorModel;
	}
	
	Color getColor() {
		return colorModel.getColor();
	}
	
	void setColor(Color color){
		colorModel.setColor(color);
	}

	protected boolean needToDraw() {
		return buttonModel.isSelected() && (0 < regionSet.size());
	}

}
