package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.Image;
import java.awt.image.BufferedImage;

import jp.sourceforge.sos.gunmetry.common.Mediator;
import jp.sourceforge.sos.lib.design.observer.IObserver;

public class DecoratorLoad implements IObserver<Image> {

	private RegionContour	regionContour;

	public DecoratorLoad(AbstractRegion region) {
		this.regionContour = (RegionContour)region;
		Mediator.<Image>add(Mediator.Subjects.LOAD, this);
	}

	public void update(Image obj) {
		if (obj!=null) {
			BufferedImage img = new BufferedImage(obj.getWidth(null), obj.getHeight(null), BufferedImage.TYPE_INT_ARGB);
			regionContour.setImage(img);
		}
	}

}
