package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.Color;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IModel;
import jp.sourceforge.sos.gunmetry.main.ModelMain;
import jp.sourceforge.sos.lib.canvas.IGraphicsContainer;

public class ModelGraphics implements IModel {

	static final Color[]		defaultColors	= { Color.black, Color.black, Color.cyan, Color.blue, Color.white };

	private AbstractRegion[]	regions			= new AbstractRegion[5];

	private ModelMain			model;

	public ModelGraphics() {
		super();
	}

	public void setAbstraction(IAbstraction abstraction) {
		model = (ModelMain)abstraction;

		regions[0] = new RegionContour(model.getNuclei());
		regions[1] = new RegionContour(model.getSkiz());
		regions[2] = new RegionCentroid(model.getNuclei());
		regions[3] = new RegionCentroid(model.getSkiz());
		regions[4] = new RegionPath(model.getNuclei());

		IGraphicsContainer canvas = model.getCanvas();
		for (int i = 0; i<regions.length; i++) {
			regions[i].setColor(defaultColors[i]);
			canvas.addGraphicObject(3+i, regions[i]);
		}	
	}

	AbstractRegion getRegion(int i) {
		return regions[i];
	}

	AbstractRegion[] getRegions() {
		return regions;
	}

}
