/*
 * RegionShapePanel.java
 *
 * Created on 2005/06/06, 1:32
 */

package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.color.JCanvasColor;


/**
 * @author Gaku Tanaka
 */
@SuppressWarnings("serial")
public class PanelRegion extends JPanel{
	static protected JObjectCanvas canvas;
	
	private JCanvasColor jCanvasColor;

	private JToggleButton jToggleButton;
	
	/** Creates new form RegionShapePanel */
	public PanelRegion() {
		initComponents();
	}

	/**
	 * @param canvas
	 *            The gunmetryViewer to set.
	 * @uml.property name="gunmetryViewer"
	 */
	static public void setCanvas(JObjectCanvas objCanvas) {
		canvas = objCanvas;
	}

	public void init(AbstractRegion data, Icon icon) {		
		jToggleButton.setIcon(icon);
		jToggleButton.setModel(data.getButtonModel());
		jCanvasColor.setModel(data.getColorModel());
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc=" Generated Code
	// ">//GEN-BEGIN:initComponents
	private void initComponents() {
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.insets = new java.awt.Insets(0, 5, 0, 0);
		gridBagConstraints1.gridx = 1;
		gridBagConstraints1.gridy = 0;
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		jToggleButton = new javax.swing.JToggleButton();
		jCanvasColor = new JCanvasColor();

		setLayout(new GridBagLayout());

		jToggleButton.setSelected(true);
		jToggleButton.setPreferredSize(new java.awt.Dimension(35, 35));
		jToggleButton.setMargin(new java.awt.Insets(1, 1, 1, 1));
		this.add(jToggleButton, gridBagConstraints);
		this.add(jCanvasColor, gridBagConstraints1);
		jToggleButton.addItemListener(new java.awt.event.ItemListener() {
			public void itemStateChanged(java.awt.event.ItemEvent evt) {
				canvas.repaint();
			}
		});

		jCanvasColor.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mousePressed(java.awt.event.MouseEvent evt) {
				canvas.repaint();
			}
		});

	}
}
