package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.GridBagConstraints;
import java.net.URL;

import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;

@SuppressWarnings("serial")
public class ViewPanel extends JPanel implements IPresentation {

	static final private String	pathResource	= "/jp/sourceforge/sos/gunmetry/resources/";

	private ModelGraphics			model;

	private PanelRegion regionCentroid = null;

	private PanelRegion regionContour = null;

	private PanelRegion skizContour = null;

	private PanelRegion skizCentroid = null;

	private PanelRegion regionPath = null;

	public ViewPanel() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Results", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
				javax.swing.border.TitledBorder.DEFAULT_POSITION, null, null));
		this.add(getRegionContour(), null);
		this.add(getSkizContour(), null);
		this.add(getRegionCentroid(), null);
		this.add(getSkizCentroid(), null);
		this.add(getRegionPath(), null);
	}

	public void setAbstraction(IAbstraction abstraction) {
		model = (ModelGraphics)abstraction;

		regionContour.init(model.getRegion(0), getIcon("reBtn1.gif"));
		skizContour.init(model.getRegion(1), getIcon("reBtn2.gif"));
		regionCentroid.init(model.getRegion(2), getIcon("reBtn3.gif"));
		skizCentroid.init(model.getRegion(3), getIcon("reBtn4.gif"));
		regionPath.init(model.getRegion(4), getIcon("reBtn5.gif"));
	}

	private ImageIcon getIcon(String path) {
		URL url = getClass().getResource(pathResource+path);
		if (url==null){
			return null;
		}
		return new ImageIcon(url);
	}

	/**
	 * This method initializes regionCentroid	
	 * 	
	 * @return jp.sourceforge.sos.gunmetry.graphics.PanelRegion	
	 */
	private PanelRegion getRegionCentroid() {
		if (regionCentroid==null) {
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.gridx = -1;
			gridBagConstraints2.gridy = -1;
			regionCentroid = new PanelRegion();
		}
		return regionCentroid;
	}

	/**
	 * This method initializes abstractRegionGraphics	
	 * 	
	 * @return jp.sourceforge.sos.gunmetry.graphics.PanelRegion	
	 */
	PanelRegion getRegionContour() {
		if (regionContour==null) {
			regionContour = new PanelRegion();
		}
		return regionContour;
	}

	/**
	 * This method initializes abstractRegionGraphics	
	 * 	
	 * @return jp.sourceforge.sos.gunmetry.graphics.PanelRegion	
	 */
	PanelRegion getSkizContour() {
		if (skizContour==null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.gridx = -1;
			gridBagConstraints1.gridy = -1;
			skizContour = new PanelRegion();
		}
		return skizContour;
	}

	/**
	 * This method initializes abstractRegionGraphics	
	 * 	
	 * @return jp.sourceforge.sos.gunmetry.graphics.PanelRegion	
	 */
	private PanelRegion getSkizCentroid() {
		if (skizCentroid==null) {
			skizCentroid = new PanelRegion();
		}
		return skizCentroid;
	}

	/**
	 * This method initializes abstractRegionGraphics	
	 * 	
	 * @return jp.sourceforge.sos.gunmetry.graphics.PanelRegion	
	 */
	private PanelRegion getRegionPath() {
		if (regionPath==null) {
			regionPath = new PanelRegion();
		}
		return regionPath;
	}

}
