package jp.sourceforge.sos.gunmetry.image;

import java.awt.Cursor;
import java.awt.event.MouseEvent;

import jp.sourceforge.sos.gunmetry.common.Operation;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.canvas.JTransformCanvas;

@SuppressWarnings("serial")
class ViewButton extends Operation{

	private JTransformCanvas	canvas;

	ViewButton(JObjectCanvas canvas) {
		super();
		this.canvas = (JTransformCanvas) canvas;
		doClick();
	}

	public void mouseClicked(MouseEvent e) {
		canvas.mouseClicked(e);
		canvas.repaintLater();
	}

	public void mousePressed(MouseEvent e) {
		canvas.mousePressed(e);
		canvas.repaintLater();
	}

	public void mouseDragged(MouseEvent e) {
		canvas.mouseDragged(e);
		canvas.repaintLater();
	}

	@Override
	protected void setCursor() {
		cursorCanvas = new Cursor(Cursor.HAND_CURSOR);
	}

}
