package jp.sourceforge.sos.gunmetry.image;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;
import jp.sourceforge.sos.gunmetry.common.Mediator;
import jp.sourceforge.sos.lib.design.observer.IObserver;

import javax.swing.ButtonGroup;


@SuppressWarnings("serial")
public class ViewPanel extends JPanel implements IPresentation, IObserver<Image> {

	private ButtonGroup		buttonGroup			= new ButtonGroup();

	private JRadioButton	jRadioOriginal		= null;

	private JRadioButton	jRadioGradient		= null;

	private JRadioButton	jRadioCluster		= null;

	private JButton			jButton				= null;

	private JButton			jButtonSetCluster	= null;

	protected ModelImage	modelImage;

	private JButton jButtonReset = null;

	ViewPanel() {
		super();
		initialize();

		buttonGroup.add(jRadioCluster);
		buttonGroup.add(jRadioGradient);
		buttonGroup.add(jRadioOriginal);

		Mediator.<Image>add(Mediator.Subjects.LOAD, this);
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridwidth = 3;
		gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
		gridBagConstraints1.gridy = 3;
		GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
		gridBagConstraints5.gridy = 0;
		gridBagConstraints5.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints5.gridx = 0;
		GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
		gridBagConstraints4.gridy = 1;
		gridBagConstraints4.gridx = 0;
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.gridy = 2;
		gridBagConstraints3.gridx = 2;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.gridy = 0;
		gridBagConstraints2.gridx = 2;
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.gridx = 0;
		this.setLayout(new GridBagLayout());
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Image", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
				javax.swing.border.TitledBorder.DEFAULT_POSITION, null, null));
		this.add(getJRadioOriginal(), gridBagConstraints5);
		this.add(getJRadioGradient(), gridBagConstraints4);
		this.add(getJRadioCluster(), gridBagConstraints);
		this.add(getJButton(), gridBagConstraints2);
		this.add(getJButtonSetCluster(), gridBagConstraints3);
		this.add(getJButtonReset(), gridBagConstraints1);
	}

	public void setAbstraction(IAbstraction abstraction) {
		modelImage = (ModelImage)abstraction;
	}

	/**
	 * This method initializes jRadioButton
	 * 
	 * @return javax.swing.JRadioButton
	 */
	private JRadioButton getJRadioCluster() {
		if (jRadioCluster==null) {
			jRadioCluster = new JRadioButton();
			jRadioCluster.setEnabled(false);
			jRadioCluster.setPreferredSize(new java.awt.Dimension(75, 24));
			jRadioCluster.setText("cluster");
			jRadioCluster.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					if (jRadioCluster.isSelected()) {
						modelImage.setCluster();
					}
				}
			});
		}
		return jRadioCluster;
	}

	/**
	 * This method initializes jRadioButton1
	 * 
	 * @return javax.swing.JRadioButton
	 */
	private JRadioButton getJRadioOriginal() {
		if (jRadioOriginal==null) {
			jRadioOriginal = new JRadioButton();
			jRadioOriginal.setSelected(true);
			jRadioOriginal.setPreferredSize(new java.awt.Dimension(75, 24));
			jRadioOriginal.setText("original");
			jRadioOriginal.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					modelImage.setOriginal();
				}
			});
		}
		return jRadioOriginal;
	}

	/**
	 * This method initializes jButton
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButton() {
		if (jButton==null) {
			jButton = new JButton();
			jButton.setFocusCycleRoot(true);
			jButton.setText("Load");
			jButton.setFocusPainted(false);
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					boolean value = modelImage.loadOriginal();
					if (value){
						Mediator.inform(Mediator.Subjects.LOAD, modelImage.getImage());
					}else{
						Mediator.inform(Mediator.Subjects.LOAD, null);						
					}
					jRadioOriginal.setSelected(true);
				}
			});
		}
		return jButton;
	}

	/**
	 * This method initializes jButton1
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButtonSetCluster() {
		if (jButtonSetCluster==null) {
			jButtonSetCluster = new JButton();
			jButtonSetCluster.setEnabled(false);
			jButtonSetCluster.setText("Load");
			jButtonSetCluster.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					boolean value = modelImage.loadCluster();
					jRadioCluster.setEnabled(value);
					jButtonReset.setEnabled(value);
				}
			});
		}
		return jButtonSetCluster;
	}

	/**
	 * This method initializes jRadioButton2
	 * 
	 * @return javax.swing.JRadioButton
	 */
	private JRadioButton getJRadioGradient() {
		if (jRadioGradient==null) {
			jRadioGradient = new JRadioButton();
			jRadioGradient.setEnabled(false);
			jRadioGradient.setPreferredSize(new java.awt.Dimension(75, 24));
			jRadioGradient.setText("gradient");
			jRadioGradient.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					modelImage.setGradient();
				}
			});
		}
		return jRadioGradient;
	}

	public void update(Image img) {
		boolean b = (img!=null);
		jRadioGradient.setEnabled(b);
		jButtonSetCluster.setEnabled(b);
	}

	/**
	 * This method initializes jButtonReset	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonReset() {
		if (jButtonReset==null) {
			jButtonReset = new JButton();
			jButtonReset.setText("re-set markers");
			jButtonReset.setEnabled(false);
			jButtonReset.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					modelImage.setMarker();
				}
			});
		}
		return jButtonReset;
	}

}
