/*
 * Region.java
 *
 * Created on 2005/03/06, 20:04
 */

package jp.sourceforge.sos.gunmetry.main;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

/**
 * This class represents the region which result from watershed with the object
 * marker. Each region correspond to the marker.
 * 
 * @author Scientific Open Source projects (Gaku Tanaka)
 */
public class Region {
	private int			size = 0;

	private Rectangle	bounds;

	private boolean[]	unmask;

	private int			minDistance;

	private Region		nearestNeighbor;

	/** Creates a new instance of Region */
	public Region() {
	}

	public Region(Point p) {
		bounds = new Rectangle(p.x, p.y, 1,1);
	}
	
	/**
	 * 
	 * @param x
	 * @param y
	 */
	public void expandRegion(int x, int y) {
		if (bounds==null){
			bounds = new Rectangle(x, y, 1, 1);
		}else{
			bounds.add(x, y);
		}
	}

	/**
	 * @return
	 * @uml.property name="bounds"
	 */
	public Rectangle getBounds() {
		return bounds;
	}

	public void initUnmask() {
		size = 0;
		if (bounds!=null){
			unmask = new boolean[bounds.width*bounds.height];
		}
	}

	/**
	 * set unmask of bounds.
	 * 
	 * @param x
	 *            relative x to the bounds.x
	 * @param y
	 *            relative y to the bounds.y
	 */
	public void setUnmask(int x, int y) {
		int index = x+y*bounds.width;
		unmask[index] = true;
		size++;
	}

	/**
	 * 
	 * @return width of the bounding rectangle.
	 */
	public int getWidth() {
		return bounds.width;
	}

	/**
	 * 
	 * @return height of the bounding rectangle.
	 */
	public int getHeight() {
		return bounds.height;
	}

	/**
	 * 
	 * @return
	 */
	public Point2D.Double getCentroid() {
		int cumX, cumY;
		if (bounds!=null) {
			cumX = bounds.x*size;
			cumY = bounds.y*size;
			int offset;
			for (int y = 0; y<bounds.height; y++) {
				offset = y*bounds.width;
				for (int x = 0; x<bounds.width; x++) {
					if (unmask[offset+x]) {
						cumX += x;
						cumY += y;
					}
				}
			}
		} else {
			return null;
		}

		return new Point2D.Double(1.0*cumX/size, 1.0*cumY/size);
	}

	/**
	 * @return
	 * @uml.property name="minDistance"
	 */
	public int getMinDistance() {
		return minDistance;
	}

	/**
	 * @param minDistance
	 * @uml.property name="minDistance"
	 */
	public void setMinDistance(int minDistance) {
		this.minDistance = minDistance;
	}

	/**
	 * @return
	 * @uml.property name="nearestNeighbor"
	 */
	public Region getNearestNeighbor() {
		return nearestNeighbor;
	}

	/**
	 * @param nearestNeighbor
	 *            The nearestNeighbor to set.
	 * @uml.property name="nearestNeighbor"
	 */
	public void setNearestNeighbor(Region nearestNeighbor) {
		this.nearestNeighbor = nearestNeighbor;
	}

	/**
	 * 
	 * @param index
	 * @return
	 */
	public boolean getUnmask(int index) {
		return unmask[index];
	}

	/**
	 * @return
	 * @uml.property name="size"
	 */
	public int getSize() {
		return size;
	}
}
