/*
 * ViewPanel.java
 *
 * Created on 2005/02/19, 13:24
 */

package jp.sourceforge.sos.gunmetry.main;

import java.awt.BorderLayout;

import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.ViewTopFrame;
import jp.sourceforge.sos.gunmetry.common.Mediator;
import jp.sourceforge.sos.gunmetry.common.Operation;
import jp.sourceforge.sos.gunmetry.graphics.PanelRegion;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.io.ExtensionFilter;

/**
 * Created on 2005/02/19
 * 
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 2.1 (2005/06/05)
 */
@SuppressWarnings("serial")
public class ViewFrameMain extends ViewTopFrame {

	static final public ExtensionFilter	filterImg;

	static final public ExtensionFilter	filterGifPng;

	private JMenuBar					jMenuBarMain;

	private JMenu						jMenuFile;

	JMenu						jMenuResult;

	private JMenuItem					jMenuSaveData;

	private JMenuItem					jMenuSaveImage;

	public JLabel						jLabelInfo			= null;

	private JPanel						jPanelMain			= null;

	private JPanel						jContentPane		= null;

	private PanelButtons				jPanelOperation		= null;

	private ViewDialogResult			viewDialogResult;

	private ModelMain					model;

	private JMenuItem					jMenuItemSaveColors	= null;

	static {
		String[] exts = ImageIO.getReaderFormatNames();
		String description = "Image Files (ImageI/O readable)";
		filterImg = new ExtensionFilter(exts, description);
		filterGifPng = new ExtensionFilter(new String[]{ "gif", "png" }, "GIF or PNG");
	}

	/** Creates new form ViewPanel */
	public ViewFrameMain() {
		super();
		initComponents();
		viewDialogResult = new ViewDialogResult(this);
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	private void initComponents() {
		jMenuBarMain = new javax.swing.JMenuBar();
		jMenuFile = new javax.swing.JMenu();
		jMenuResult = new javax.swing.JMenu();
		jMenuSaveData = new javax.swing.JMenuItem();
		jMenuSaveImage = new javax.swing.JMenuItem();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		this.setContentPane(getJContentPane());

		setTitle("Gunmetry Ver. 2.0");
		setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));

		jMenuBarMain.setDoubleBuffered(true);
		jMenuFile.setText("File");
		jMenuFile.setEnabled(true);
		jMenuFile.add(getJMenuItemSaveColors());
		jMenuBarMain.add(jMenuFile);

		jMenuResult.setText("Result");
		jMenuResult.setEnabled(false);
		jMenuSaveData.setText("Save Data");
		jMenuSaveData.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				viewDialogResult.setVisible(true);
			}
		});

		jMenuResult.add(jMenuSaveData);

		jMenuSaveImage.setText("Save Image");
		jMenuSaveImage.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				model.saveImage();
			}
		});

		jMenuResult.add(jMenuSaveImage);

		jMenuBarMain.add(jMenuResult);

		setJMenuBar(jMenuBarMain);

		pack();
	}

	// </editor-fold>//GEN-END:initComponents

	public void setAbstraction(IAbstraction abstraction) {
		model = (ModelMain)abstraction;
		viewDialogResult.setAbstraction(abstraction);
		
		JObjectCanvas canvas = model.getCanvas();
		PanelRegion.setCanvas(canvas);
		Operation.setCanvas(canvas);
		jContentPane.add(canvas, java.awt.BorderLayout.CENTER);
	}

	/**
	 * This method initializes jPanelMain
	 * 
	 * @return javax.swing.JPanel
	 */
	JPanel getJPanelMain() {
		if (jPanelMain==null) {
			jPanelMain = new JPanel();
			jPanelMain.setLayout(new BoxLayout(getJPanelMain(), BoxLayout.Y_AXIS));
			jPanelMain.add(getJPanelOperation(), null);
		}
		return jPanelMain;
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	protected JPanel getJContentPane() {
		if (jContentPane==null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getJPanelMain(), java.awt.BorderLayout.WEST);
		}
		return jContentPane;
	}

	/**
	 * This method initializes viewPanel
	 * 
	 * @return jp.sourceforge.sos.gunmetry.main.PanelButtons
	 */
	private PanelButtons getJPanelOperation() {
		if (jPanelOperation==null) {
			jPanelOperation = new PanelButtons();
		}
		return jPanelOperation;
	}

	/**
	 * This method initializes jMenuItemSaveColors
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItemSaveColors() {
		if (jMenuItemSaveColors==null) {
			jMenuItemSaveColors = new JMenuItem();
			jMenuItemSaveColors.setText("Save colors");
			jMenuItemSaveColors.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					Mediator.inform(Mediator.Subjects.SAVE_COLORS, null);
				}
			});
		}
		return jMenuItemSaveColors;
	}
}
