package jp.sourceforge.sos.gunmetry.marker;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.gunmetry.common.Operation;
import jp.sourceforge.sos.lib.image.ROIRectangle;

@SuppressWarnings("serial")
class ViewButton extends Operation {
	static private final Cursor	CURSOR_MOVE	= new Cursor(Cursor.MOVE_CURSOR);

	static private MarkerSet	currentMarker;

	private ModelMarker			modelMarker;

	private MarkerSet			marker;

	private BufferedImage		imgCursor	= new BufferedImage(32, 32, BufferedImage.TYPE_INT_ARGB);

	private ROIRectangle		selectionRect;

	ViewButton(IAbstraction model, MarkerSet marker) {
		super();
		this.modelMarker = (ModelMarker)model;
		this.marker = marker;
		selectionRect = modelMarker.getSelectionRect();
	}

	protected Cursor createCursor() {
		int size = imgCursor.getWidth();
		int hSize = size/2;
		int fqSize = size/4;
		Graphics g = imgCursor.getGraphics();
		Color colorClear = new Color(0, 0, 0, 0);
		g.setColor(colorClear);
		g.fillRect(0, 0, size, size);

		g.setColor(Color.black);
		g.fillRect(fqSize, hSize-1, hSize+1, 3);
		g.fillRect(hSize-1, fqSize, 3, hSize+1);

		g.setColor(marker.getColor());
		g.drawLine(fqSize, hSize, size-fqSize, hSize);
		g.drawLine(hSize, fqSize, hSize, size-fqSize);

		return Toolkit.getDefaultToolkit().createCustomCursor(imgCursor, new Point(hSize, hSize), "object");
	}

	protected void setListeners() {
		currentMarker = marker;
		super.setListeners();
	}

	private void checkSelectionType(int modifier) {
		if ( (modifier&InputEvent.SHIFT_MASK)==0) {
			modelMarker.clearSelection();
		}
	}

	public void mouseClicked(MouseEvent e) {
		if (modelMarker.isFocusActive()) {
			modelMarker.selectFromFocus();
		} else {
			Point2D p2D = canvas.getGraphicsTransform().inverseTransform(e.getPoint());
			modelMarker.addPoint(currentMarker, p2D);
		}
	}

	public void mousePressed(MouseEvent e) {
		if (e.getModifiers()!=4) { // NOT pressed the shift key
			checkSelectionType(e.getModifiers());
			selectionRect.handleMousePressed(e.getPoint());
		}

		if (modelMarker.isFocusActive()) {
			modelMarker.removeFocus();
		} else {
			selectionRect.setVisible(true);
		}
	}

	public void mouseReleased(MouseEvent e) {
		if (!modelMarker.isFocusActive()) {
			if (selectionRect.isVisible()) {
				// add PointRects in the selectionRect to selectedMarkers
				Shape rect = canvas.getGraphicsTransform().inverseTransform(selectionRect);
				modelMarker.select(rect);
			}
		} else {
			Point2D p = canvas.getGraphicsTransform().inverseTransform(e.getPoint());
			modelMarker.setFocusPoint(p);
		}
	}

	public void mouseDragged(MouseEvent e) {
		if (!modelMarker.isFocusActive()) {
			selectionRect.handleMouseDragged(e.getPoint());
			modelMarker.repaint();
		}
	}

	public void mouseMoved(MouseEvent e) {
		Point2D mousePoint2D = canvas.getGraphicsTransform().inverseTransform(e.getPoint());
		if (!modelMarker.isSameFocus(mousePoint2D)) {
			if (modelMarker.isFocusActive()) {
				canvas.setCursor(CURSOR_MOVE);
			} else {
				canvas.setCursor(cursorCanvas);
			}
		}
	}

	@Override
	protected void setCursor() {
		cursorCanvas = new Cursor(Cursor.CROSSHAIR_CURSOR);
	}

}
