/**
 * 
 */
package jp.sourceforge.sos.gunmetry.marker;

import javax.swing.JButton;


import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;
import jp.sourceforge.sos.gunmetry.common.Mediator;
import jp.sourceforge.sos.lib.design.observer.IObserver;

/**
 * @author Gaku Tanaka
 *
 */
@SuppressWarnings("serial")
public class ViewButtonAnalysis extends JButton implements IPresentation, IObserver<Boolean>{

	protected ModelMarker	modelMarker;

	/**
	 * This method initializes 
	 * 
	 */
	public ViewButtonAnalysis() {
		super();
		initialize();
		
		Mediator.<Boolean>add(Mediator.Subjects.READY_TO_ANALYSIS,this);
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setText("ANALYSIS");
        this.setEnabled(false);
        this.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(java.awt.event.ActionEvent e) {
        		modelMarker.doWatershed();
        	}
        });
			
	}

	public void setAbstraction(IAbstraction abstraction) {
		modelMarker = (ModelMarker)abstraction;
	}

	public void update(Boolean obj) {
		setEnabled(obj);
	}

}  //  @jve:decl-index=0:visual-constraint="10,16"
